/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.processlog.multibucketsinglefile;

import com.gigaspaces.cluster.replication.IncomingReplicationOutOfSyncException;
import com.gigaspaces.internal.cluster.node.handlers.IReplicationInFacade;
import com.gigaspaces.internal.cluster.node.impl.backlog.IBacklogHandshakeRequest;
import com.gigaspaces.internal.cluster.node.impl.backlog.IIdleStateData;
import com.gigaspaces.internal.cluster.node.impl.backlog.multibucketsinglefile.AbstractMultiBucketSingleFileGroupBacklog;
import com.gigaspaces.internal.cluster.node.impl.backlog.multibucketsinglefile.BucketKey;
import com.gigaspaces.internal.cluster.node.impl.backlog.multibucketsinglefile.DeletedMultiBucketOrderedPacket;
import com.gigaspaces.internal.cluster.node.impl.backlog.multibucketsinglefile.DiscardedMultiBucketOrderedPacket;
import com.gigaspaces.internal.cluster.node.impl.backlog.multibucketsinglefile.IMultiBucketSingleFileReplicationOrderedPacket;
import com.gigaspaces.internal.cluster.node.impl.backlog.multibucketsinglefile.ISingleBucketReplicationOrderedPacket;
import com.gigaspaces.internal.cluster.node.impl.backlog.multibucketsinglefile.MultiBucketSingleFileHandshakeRequest;
import com.gigaspaces.internal.cluster.node.impl.backlog.multibucketsinglefile.MultipleBucketOrderedPacket;
import com.gigaspaces.internal.cluster.node.impl.filters.IReplicationInFilterCallback;
import com.gigaspaces.internal.cluster.node.impl.groups.IReplicationGroupHistory;
import com.gigaspaces.internal.cluster.node.impl.groups.handshake.IHandshakeIteration;
import com.gigaspaces.internal.cluster.node.impl.packets.IReplicationOrderedPacket;
import com.gigaspaces.internal.cluster.node.impl.packets.data.IReplicationPacketDataConsumer;
import com.gigaspaces.internal.cluster.node.impl.processlog.AbstractSingleFileTargetProcessLog;
import com.gigaspaces.internal.cluster.node.impl.processlog.IProcessLogHandshakeResponse;
import com.gigaspaces.internal.cluster.node.impl.processlog.IProcessResult;
import com.gigaspaces.internal.cluster.node.impl.processlog.IReplicationProcessLogExceptionHandler;
import com.gigaspaces.internal.cluster.node.impl.processlog.ProcessLogConfig;
import com.gigaspaces.internal.cluster.node.impl.processlog.ProcessLogState;
import com.gigaspaces.internal.cluster.node.impl.processlog.multibucketsinglefile.IMultiBucketSingleFileProcessLog;
import com.gigaspaces.internal.cluster.node.impl.processlog.multibucketsinglefile.MultiBucketSingleFileHandshakeResponse;
import com.gigaspaces.internal.cluster.node.impl.processlog.multibucketsinglefile.MultiBucketSingleFileProcessLogConfig;
import com.gigaspaces.internal.cluster.node.impl.processlog.multibucketsinglefile.MultiBucketSingleFileProcessResult;
import com.gigaspaces.internal.cluster.node.impl.processlog.multibucketsinglefile.ParallelBatchProcessingContext;
import com.gigaspaces.internal.cluster.node.impl.processlog.multibucketsinglefile.ProcessLogBucket;
import com.gigaspaces.internal.collections.CollectionsFactory;
import com.gigaspaces.internal.collections.ShortObjectIterator;
import com.gigaspaces.internal.collections.ShortObjectMap;
import com.gigaspaces.internal.utils.StringUtils;
import com.gigaspaces.time.SystemTime;
import com.j_spaces.core.exception.ClosedResourceException;
import com.j_spaces.kernel.threadpool.DynamicExecutors;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractMultiBucketSingleFileTargetProcessLog
extends AbstractSingleFileTargetProcessLog
implements IMultiBucketSingleFileProcessLog {
    private final Object _lifeCycleLock = new Object();
    private final ProcessLogBucket[] _buckets;
    private final int _batchProcessingThreshold;
    private final int _batchParallelProcessingThreshold;
    private final long _consumeTimeout;
    private final MultiBucketSingleFileProcessLogConfig _typedConfig;
    private final long[] _lastProcessedKeys;
    private final long[] _lastGlobalProcessedKeys;
    private final ExecutorService _executorService;
    private final int _parallelFactor;
    private final boolean _useCallerThreadAsParallelExecutor = true;
    private volatile boolean _firstHandshakeForTarget;
    private ProcessLogState _state = ProcessLogState.OPEN;

    public AbstractMultiBucketSingleFileTargetProcessLog(ProcessLogConfig config, IReplicationPacketDataConsumer<?> dataConsumer, IReplicationProcessLogExceptionHandler exceptionHandler, IReplicationInFacade replicationInFacade, String name, String groupName, String sourceLookupName, IReplicationGroupHistory groupHistory) {
        this(config, dataConsumer, exceptionHandler, replicationInFacade, name, groupName, sourceLookupName, new long[((MultiBucketSingleFileProcessLogConfig)config).getBucketsCount()], new long[((MultiBucketSingleFileProcessLogConfig)config).getBucketsCount()], true, groupHistory);
    }

    protected AbstractMultiBucketSingleFileTargetProcessLog(ProcessLogConfig config, IReplicationPacketDataConsumer<?> dataConsumer, IReplicationProcessLogExceptionHandler exceptionHandler, IReplicationInFacade replicationInFacade, String name, String groupName, String sourceLookupName, long[] lastProcessedKeys, long[] lastGlobalProcessedKeys, boolean firstHandshakeForTarget, IReplicationGroupHistory groupHistory) {
        super(dataConsumer, exceptionHandler, replicationInFacade, name, groupName, sourceLookupName, groupHistory);
        this._firstHandshakeForTarget = firstHandshakeForTarget;
        this._typedConfig = (MultiBucketSingleFileProcessLogConfig)config;
        this._consumeTimeout = this._typedConfig.getConsumeTimeout();
        this._buckets = this.createBuckets(this._typedConfig.getBucketsCount());
        this._lastProcessedKeys = lastProcessedKeys;
        this._lastGlobalProcessedKeys = lastGlobalProcessedKeys;
        this._batchProcessingThreshold = this._typedConfig.getBatchProcessingThreshold();
        this._batchParallelProcessingThreshold = this._typedConfig.getBatchParallelProcessingThreshold();
        this._parallelFactor = this._typedConfig.getBatchParallelFactor();
        this._executorService = DynamicExecutors.newScalingThreadPool(1, this._parallelFactor, 10000L);
    }

    private ProcessLogBucket[] createBuckets(short numberOfBuckets) {
        ProcessLogBucket[] buckets = new ProcessLogBucket[numberOfBuckets];
        for (short i = 0; i < numberOfBuckets; i = (short)(i + 1)) {
            buckets[i] = new ProcessLogBucket(i, this);
        }
        return buckets;
    }

    public ExecutorService getExecutorService() {
        return this._executorService;
    }

    public long[] getLastProcessedKeys() {
        return this._lastProcessedKeys;
    }

    public long[] getLastGlobalProcessedKeys() {
        return this._lastGlobalProcessedKeys;
    }

    public boolean isFirstHandshakeForTarget() {
        return this._firstHandshakeForTarget;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MultiBucketSingleFileHandshakeResponse performHandshake(String memberName, IBacklogHandshakeRequest handshakeRequest) throws IncomingReplicationOutOfSyncException {
        Object object = this._lifeCycleLock;
        synchronized (object) {
            this.validateOpen();
            MultiBucketSingleFileHandshakeRequest typedHandshakeRequest = (MultiBucketSingleFileHandshakeRequest)handshakeRequest;
            if (this._firstHandshakeForTarget) {
                this._firstHandshakeForTarget = false;
                return this.overrideBucketsConfirmedKeys(typedHandshakeRequest);
            }
            if (typedHandshakeRequest.isFirstHandshake() && this.canResetState()) {
                return this.overrideBucketsConfirmedKeys(typedHandshakeRequest);
            }
            long[] handshakeBucketsConfirmedKeys = typedHandshakeRequest.getBucketsConfirmedKeys();
            long globalConfirmedKey = typedHandshakeRequest.getGlobalConfirmedKey();
            long maxGlobalLastProcessedKey = Long.MIN_VALUE;
            long[] bucketsLastProcessedkeys = new long[this._buckets.length];
            for (int i = 0; i < handshakeBucketsConfirmedKeys.length; ++i) {
                long lastProcessedKey = this._lastProcessedKeys[i];
                if (lastProcessedKey < handshakeBucketsConfirmedKeys[i]) {
                    throw new IncomingReplicationOutOfSyncException("Replication out of sync, buckets keys mismatch at index " + i + " confirmed=" + handshakeBucketsConfirmedKeys[i] + " processed=" + lastProcessedKey);
                }
                maxGlobalLastProcessedKey = Math.max(maxGlobalLastProcessedKey, this._lastGlobalProcessedKeys[i]);
                bucketsLastProcessedkeys[i] = lastProcessedKey;
            }
            if (maxGlobalLastProcessedKey < globalConfirmedKey) {
                throw new IncomingReplicationOutOfSyncException("Replication out of sync, global key mismatch, local max last processed key=" + maxGlobalLastProcessedKey + " global confirmed=" + globalConfirmedKey);
            }
            return new MultiBucketSingleFileHandshakeResponse(bucketsLastProcessedkeys, globalConfirmedKey);
        }
    }

    protected boolean canResetState() {
        return true;
    }

    public void validateOpen() {
        if (this._state != ProcessLogState.OPEN) {
            this.throwClosedException();
        }
    }

    public void validateNotClosed() {
        if (this._state == ProcessLogState.CLOSED) {
            this.throwClosedException();
        }
    }

    protected void throwClosedException() {
        throw new ClosedResourceException("Process log is closed");
    }

    private MultiBucketSingleFileHandshakeResponse overrideBucketsConfirmedKeys(MultiBucketSingleFileHandshakeRequest typedHandshakeRequest) {
        long[] handshakeBucketsConfirmedKeys = typedHandshakeRequest.getBucketsConfirmedKeys();
        long handshakeGlobalKeyConfirmed = typedHandshakeRequest.getGlobalConfirmedKey();
        for (int i = 0; i < handshakeBucketsConfirmedKeys.length; ++i) {
            this._lastProcessedKeys[i] = handshakeBucketsConfirmedKeys[i];
            this._lastGlobalProcessedKeys[i] = handshakeGlobalKeyConfirmed;
        }
        return new MultiBucketSingleFileHandshakeResponse(handshakeBucketsConfirmedKeys, handshakeGlobalKeyConfirmed);
    }

    @Override
    public MultiBucketSingleFileProcessResult processBatch(String sourceLookupName, List<IReplicationOrderedPacket> packets, IReplicationInFilterCallback inFilterCallback) {
        this.validateOpen();
        if (packets.isEmpty()) {
            return MultiBucketSingleFileProcessResult.OK;
        }
        int size = packets.size();
        MultiBucketSingleFileProcessResult result = size < this._batchProcessingThreshold ? (size < this._batchParallelProcessingThreshold ? this.processIteratively(sourceLookupName, packets, inFilterCallback, null, -1) : this.processParallelIteratively(sourceLookupName, packets, inFilterCallback)) : this.processInBatches(sourceLookupName, packets, inFilterCallback);
        this.replaceWithExceptionIfNeeded(result);
        return result;
    }

    private MultiBucketSingleFileProcessResult processParallelIteratively(String sourceLookupName, List<IReplicationOrderedPacket> packets, IReplicationInFilterCallback inFilterCallback) {
        List<IReplicationOrderedPacket>[] parallelLists = this.split(packets);
        int parallelParticipants = parallelLists.length - 1;
        ParallelBatchProcessingContext context = new ParallelBatchProcessingContext(parallelLists, parallelParticipants);
        for (int i = 1; i < parallelLists.length; ++i) {
            this.createBatchParallelProcessingContinuationTask(sourceLookupName, inFilterCallback, context, parallelLists[i], i);
        }
        MultiBucketSingleFileProcessResult processResult = this.processIteratively(sourceLookupName, parallelLists[0], inFilterCallback, null, -1);
        if (!processResult.isProcessed()) {
            return processResult;
        }
        try {
            context.waitForCompletion(this._consumeTimeout, TimeUnit.MILLISECONDS);
        }
        catch (Throwable e) {
            return new MultiBucketSingleFileProcessResult(e);
        }
        return MultiBucketSingleFileProcessResult.OK;
    }

    private List<IReplicationOrderedPacket>[] split(List<IReplicationOrderedPacket> packets) {
        LinkedList<IReplicationOrderedPacket> currentSegment;
        int packetsSize = packets.size();
        int segmentsCount = Math.min(this._parallelFactor, packetsSize);
        int segmentSize = packetsSize / segmentsCount;
        List[] split = new List[segmentsCount];
        int index = 0;
        int nextSegmentIndex = 1;
        split[0] = currentSegment = new LinkedList<IReplicationOrderedPacket>();
        for (IReplicationOrderedPacket packet : packets) {
            if (nextSegmentIndex < this._parallelFactor && index++ >= segmentSize) {
                index = 1;
                currentSegment = new LinkedList();
                split[nextSegmentIndex++] = currentSegment;
            }
            currentSegment.add(packet);
        }
        return split;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createBatchParallelProcessingContinuationTask(final String sourceLookupName, final IReplicationInFilterCallback inFilterCallback, final ParallelBatchProcessingContext context, final List<IReplicationOrderedPacket> batch, final int segmentIndex) {
        try {
            this._executorService.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        AbstractMultiBucketSingleFileTargetProcessLog.this.validateOpen();
                        MultiBucketSingleFileProcessResult result = AbstractMultiBucketSingleFileTargetProcessLog.this.processIteratively(sourceLookupName, batch, inFilterCallback, context, segmentIndex);
                        if (result.isPending()) {
                            return;
                        }
                        if (result.isProcessed()) {
                            context.signalOneProcessedOk();
                        } else {
                            context.setError(result.getError());
                        }
                    }
                    catch (Throwable t) {
                        context.setError(t);
                    }
                }
            });
        }
        catch (RejectedExecutionException e) {
            try {
                Object object = this._lifeCycleLock;
                synchronized (object) {
                    this.validateOpen();
                }
            }
            catch (ClosedResourceException cre) {
                context.setError(cre);
                throw cre;
            }
            context.setError(e);
        }
    }

    private MultiBucketSingleFileProcessResult processInBatches(String sourceLookupName, List<IReplicationOrderedPacket> packets, IReplicationInFilterCallback inFilterCallback) {
        try {
            List bucketPackets;
            ShortObjectMap<List<IMultiBucketSingleFileReplicationOrderedPacket>> bucketsMappedPackets = CollectionsFactory.getInstance().createShortObjectMap();
            for (IReplicationOrderedPacket packet : packets) {
                IMultiBucketSingleFileReplicationOrderedPacket typedPacket = (IMultiBucketSingleFileReplicationOrderedPacket)packet;
                typedPacket.associateToBuckets(bucketsMappedPackets);
            }
            ShortObjectIterator<Object> iterator = bucketsMappedPackets.iterator();
            while (iterator.hasNext()) {
                iterator.advance();
                short bucketIndex = iterator.key();
                bucketPackets = (List)iterator.value();
                this._buckets[bucketIndex].add(bucketPackets);
            }
            while (!bucketsMappedPackets.isEmpty()) {
                iterator = bucketsMappedPackets.iterator();
                while (iterator.hasNext()) {
                    iterator.advance();
                    short bucketIndex = iterator.key();
                    bucketPackets = (List)iterator.value();
                    Throwable error = this._buckets[bucketIndex].process(sourceLookupName, bucketPackets, inFilterCallback);
                    if (error != null) {
                        return new MultiBucketSingleFileProcessResult(error);
                    }
                    if (!bucketPackets.isEmpty()) continue;
                    iterator.remove();
                }
            }
            return MultiBucketSingleFileProcessResult.OK;
        }
        catch (Throwable t) {
            this.releaseOnErrorResult(t);
            return new MultiBucketSingleFileProcessResult(t);
        }
    }

    private MultiBucketSingleFileProcessResult processIteratively(String sourceLookupName, List<IReplicationOrderedPacket> packets, IReplicationInFilterCallback inFilterCallback, ParallelBatchProcessingContext batchContext, int segmentIndex) {
        MultiBucketSingleFileProcessResult result = MultiBucketSingleFileProcessResult.OK;
        Iterator<IReplicationOrderedPacket> iterator = packets.iterator();
        while (iterator.hasNext()) {
            IReplicationOrderedPacket packet = iterator.next();
            result = this.process(sourceLookupName, packet, inFilterCallback, batchContext, segmentIndex);
            if (result.isProcessed()) {
                if (batchContext == null) continue;
                iterator.remove();
                continue;
            }
            return result;
        }
        return result;
    }

    public MultiBucketSingleFileProcessResult process(String sourceLookupName, IReplicationOrderedPacket packet, IReplicationInFilterCallback inFilterCallback, ParallelBatchProcessingContext batchContext, int segmentIndex) {
        IMultiBucketSingleFileReplicationOrderedPacket typedPacket = (IMultiBucketSingleFileReplicationOrderedPacket)packet;
        MultiBucketSingleFileProcessResult result = typedPacket.process(sourceLookupName, this, inFilterCallback, batchContext, segmentIndex);
        return result;
    }

    @Override
    public MultiBucketSingleFileProcessResult process(String sourceLookupName, IReplicationOrderedPacket packet, IReplicationInFilterCallback inFilterCallback) {
        MultiBucketSingleFileProcessResult processResult = this.process(sourceLookupName, packet, inFilterCallback, null, -1);
        this.replaceWithExceptionIfNeeded(processResult);
        return processResult;
    }

    private void replaceWithExceptionIfNeeded(MultiBucketSingleFileProcessResult processResult) {
        if (processResult.isProcessed()) {
            return;
        }
        if (processResult.getError() instanceof ClosedResourceException) {
            throw (ClosedResourceException)processResult.getError();
        }
    }

    private void releaseOnErrorResult(Throwable error) {
        for (ProcessLogBucket bucket : this._buckets) {
            bucket.releaseOnErrorResult(error);
        }
    }

    @Override
    public MultiBucketSingleFileProcessResult process(String sourceLookupName, ISingleBucketReplicationOrderedPacket packet, IReplicationInFilterCallback inFilterCallback, ParallelBatchProcessingContext batchContext, int segmentIndex) {
        short buckIndex = packet.getBucketIndex();
        try {
            MultiBucketSingleFileProcessResult result = this._buckets[buckIndex].addAndProcess(sourceLookupName, packet, inFilterCallback, batchContext, segmentIndex);
            if (result.getError() != null) {
                return new MultiBucketSingleFileProcessResult(result.getError());
            }
            return result;
        }
        catch (Throwable e) {
            this.releaseOnErrorResult(e);
            return new MultiBucketSingleFileProcessResult(e);
        }
    }

    @Override
    public MultiBucketSingleFileProcessResult process(String sourceLookupName, MultipleBucketOrderedPacket packet, IReplicationInFilterCallback inFilterCallback, ParallelBatchProcessingContext batchContext, int segmentIndex) {
        ShortObjectMap<BucketKey> bucketsKeys = packet.getBucketsKeys();
        try {
            ShortObjectIterator<BucketKey> iterator = bucketsKeys.iterator();
            while (iterator.hasNext()) {
                iterator.advance();
                MultiBucketSingleFileProcessResult result = this._buckets[iterator.key()].addAndProcess(sourceLookupName, packet, inFilterCallback, batchContext, segmentIndex);
                if (result.getError() != null) {
                    return result;
                }
                if (!result.isPending()) continue;
                return result;
            }
            iterator = bucketsKeys.iterator();
            while (iterator.hasNext()) {
                iterator.advance();
                this._buckets[iterator.key()].signalDoneProcessing(sourceLookupName, packet, inFilterCallback);
            }
            return MultiBucketSingleFileProcessResult.OK;
        }
        catch (Throwable e) {
            this.releaseOnErrorResult(e);
            return new MultiBucketSingleFileProcessResult(e);
        }
    }

    @Override
    public MultiBucketSingleFileProcessResult process(String sourceLookupName, DiscardedMultiBucketOrderedPacket packet, IReplicationInFilterCallback inFilterCallback, ParallelBatchProcessingContext batchContext, int segmentIndex) {
        ShortObjectMap<BucketKey> bucketsKeys = packet.getBucketsKeys();
        try {
            ShortObjectIterator<BucketKey> iterator = bucketsKeys.iterator();
            while (iterator.hasNext()) {
                iterator.advance();
                MultiBucketSingleFileProcessResult result = this._buckets[iterator.key()].addAndProcess(sourceLookupName, packet, inFilterCallback, batchContext, segmentIndex);
                if (result.getError() == null) continue;
                return result;
            }
            return MultiBucketSingleFileProcessResult.OK;
        }
        catch (Throwable e) {
            this.releaseOnErrorResult(e);
            return new MultiBucketSingleFileProcessResult(e);
        }
    }

    @Override
    public MultiBucketSingleFileProcessResult process(String sourceLookupName, DeletedMultiBucketOrderedPacket packet, IReplicationInFilterCallback inFilterCallback, ParallelBatchProcessingContext batchContext, int segmentIndex) {
        ShortObjectMap<BucketKey> bucketsKeys = packet.getBucketsKeys();
        try {
            ShortObjectIterator<BucketKey> iterator = bucketsKeys.iterator();
            while (iterator.hasNext()) {
                iterator.advance();
                MultiBucketSingleFileProcessResult result = this._buckets[iterator.key()].addAndProcess(sourceLookupName, packet, inFilterCallback, batchContext, segmentIndex);
                if (result.getError() == null) continue;
                return result;
            }
            return MultiBucketSingleFileProcessResult.OK;
        }
        catch (Throwable e) {
            this.releaseOnErrorResult(e);
            return new MultiBucketSingleFileProcessResult(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean close(long time, TimeUnit unit) throws InterruptedException {
        Object object = this._lifeCycleLock;
        synchronized (object) {
            this._state = ProcessLogState.CLOSING;
        }
        try {
            long remainingTime = unit.toMillis(time);
            for (ProcessLogBucket bucket : this._buckets) {
                long startTime = SystemTime.timeMillis();
                bucket.close(remainingTime, TimeUnit.MILLISECONDS);
                long endTime = SystemTime.timeMillis();
                if ((remainingTime -= endTime - startTime) > 0L) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            Object object2 = this._lifeCycleLock;
            synchronized (object2) {
                this._executorService.shutdown();
                this._state = ProcessLogState.CLOSED;
            }
        }
    }

    public long getConsumeTimeout() {
        return this._consumeTimeout;
    }

    @Override
    public void processHandshakeIteration(String sourceMemberName, IHandshakeIteration handshakeIteration) {
        throw new UnsupportedOperationException();
    }

    protected boolean shouldCloneOnFilter() {
        return false;
    }

    protected void afterSuccessfulConsumption(String sourceLookupName, IReplicationOrderedPacket packet) {
        if (!packet.isDataPacket() && packet instanceof DeletedMultiBucketOrderedPacket) {
            DeletedMultiBucketOrderedPacket deletedBacklogPacket = (DeletedMultiBucketOrderedPacket)packet;
            String deletionMessage = "packets [" + deletedBacklogPacket.getKey() + "-" + deletedBacklogPacket.getEndKey() + "] are lost due to backlog deletion at the source";
            this.getGroupHistory().logEvent(this.getSourceLookupName(), deletionMessage);
            if (this._specificLogger.isLoggable(Level.WARNING)) {
                this._specificLogger.warning(deletionMessage);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IProcessLogHandshakeResponse resync(IBacklogHandshakeRequest handshakeRequest) {
        Object object = this._lifeCycleLock;
        synchronized (object) {
            this.validateOpen();
            MultiBucketSingleFileHandshakeRequest typedHandshakeRequest = (MultiBucketSingleFileHandshakeRequest)handshakeRequest;
            this._firstHandshakeForTarget = false;
            return this.overrideBucketsConfirmedKeys(typedHandshakeRequest);
        }
    }

    @Override
    public Object toWireForm(IProcessResult processResult) {
        if (processResult == MultiBucketSingleFileProcessResult.OK) {
            return null;
        }
        return processResult;
    }

    @Override
    public String dumpState() {
        return "State [" + (Object)((Object)this._state) + "] had any handshake [" + !this._firstHandshakeForTarget + "] last processed bucket keys " + AbstractMultiBucketSingleFileGroupBacklog.printBucketsKeys(this._lastProcessedKeys) + StringUtils.NEW_LINE + this.dumpStateExtra();
    }

    protected String dumpStateExtra() {
        return "last processed global key " + AbstractMultiBucketSingleFileGroupBacklog.printBucketsKeys(this._lastGlobalProcessedKeys) + StringUtils.NEW_LINE + "buckets state " + this.printBucketsFirstPendingPacket();
    }

    private String printBucketsFirstPendingPacket() {
        StringBuilder sb = new StringBuilder("[");
        for (int i = 0; i < this._buckets.length; ++i) {
            sb.append(i);
            sb.append(": ");
            sb.append(this._buckets[i].printPendingState());
            if (i >= this._buckets.length - 1) continue;
            sb.append(", ");
        }
        sb.append("]");
        return sb.toString();
    }

    public Logger getSpecificLogger() {
        return this._specificLogger;
    }

    @Override
    public IProcessResult processIdleStateData(String string, IIdleStateData idleStateData, IReplicationInFilterCallback inFilterCallback) {
        throw new UnsupportedOperationException();
    }
}

