/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.processlog.multibucketsinglefile;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.cluster.replication.IncomingReplicationOutOfSyncException;
import com.gigaspaces.internal.cluster.node.handlers.IReplicationInFacade;
import com.gigaspaces.internal.cluster.node.impl.backlog.IBacklogHandshakeRequest;
import com.gigaspaces.internal.cluster.node.impl.backlog.multibucketsinglefile.DeletedMultiBucketOrderedPacket;
import com.gigaspaces.internal.cluster.node.impl.backlog.multibucketsinglefile.DiscardedMultiBucketOrderedPacket;
import com.gigaspaces.internal.cluster.node.impl.backlog.multibucketsinglefile.DiscardedSingleBucketOrderedPacket;
import com.gigaspaces.internal.cluster.node.impl.backlog.multibucketsinglefile.IMultiBucketSingleFileReplicationOrderedPacket;
import com.gigaspaces.internal.cluster.node.impl.backlog.multibucketsinglefile.MultiBucketSingleFileHandshakeRequest;
import com.gigaspaces.internal.cluster.node.impl.filters.IReplicationInFilterCallback;
import com.gigaspaces.internal.cluster.node.impl.groups.IReplicationGroupHistory;
import com.gigaspaces.internal.cluster.node.impl.packets.IReplicationOrderedPacket;
import com.gigaspaces.internal.cluster.node.impl.packets.data.IDataConsumeFix;
import com.gigaspaces.internal.cluster.node.impl.packets.data.IDataConsumeResult;
import com.gigaspaces.internal.cluster.node.impl.packets.data.IReplicationPacketData;
import com.gigaspaces.internal.cluster.node.impl.packets.data.IReplicationPacketDataBatchConsumer;
import com.gigaspaces.internal.cluster.node.impl.processlog.IReplicationProcessLogExceptionHandler;
import com.gigaspaces.internal.cluster.node.impl.processlog.ProcessLogConfig;
import com.gigaspaces.internal.cluster.node.impl.processlog.async.IReplicationBatchConsumeAsyncTargetProcessLog;
import com.gigaspaces.internal.cluster.node.impl.processlog.multibucketsinglefile.AbstractMultiBucketSingleFileTargetProcessLog;
import com.gigaspaces.internal.cluster.node.impl.processlog.multibucketsinglefile.IBatchExecutedCallback;
import com.gigaspaces.internal.cluster.node.impl.processlog.multibucketsinglefile.MultiBucketSingleFileHandshakeResponse;
import com.gigaspaces.internal.cluster.node.impl.processlog.multibucketsinglefile.MultiBucketSingleFileProcessResult;
import com.gigaspaces.internal.cluster.node.impl.processlog.multibucketsinglefile.MultiBucketSingleFileReplicationInBatchContext;
import com.gigaspaces.internal.collections.CollectionsFactory;
import com.gigaspaces.internal.collections.ShortLongIterator;
import com.gigaspaces.internal.collections.ShortLongMap;
import com.j_spaces.core.exception.internal.ReplicationInternalSpaceException;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;

@InternalApi
public class MultiBucketSingleFileBatchConsumeTargetProcessLog
extends AbstractMultiBucketSingleFileTargetProcessLog
implements IBatchExecutedCallback,
IReplicationBatchConsumeAsyncTargetProcessLog {
    protected final Lock _lock = new ReentrantLock();
    private final IReplicationPacketDataBatchConsumer<?> _batchDataConsumer;
    private long _lastGlobalProcessedKey;

    public MultiBucketSingleFileBatchConsumeTargetProcessLog(ProcessLogConfig config, IReplicationPacketDataBatchConsumer<?> dataConsumer, IReplicationProcessLogExceptionHandler exceptionHandler, IReplicationInFacade replicationInFacade, String name, String groupName, String sourceLookupName, IReplicationGroupHistory groupHistory) {
        super(config, dataConsumer, exceptionHandler, replicationInFacade, name, groupName, sourceLookupName, groupHistory);
        this._lastGlobalProcessedKey = -1L;
        this._batchDataConsumer = dataConsumer;
    }

    protected MultiBucketSingleFileBatchConsumeTargetProcessLog(ProcessLogConfig config, IReplicationPacketDataBatchConsumer<?> dataConsumer, IReplicationProcessLogExceptionHandler exceptionHandler, IReplicationInFacade replicationInFacade, String name, String groupName, String sourceLookupName, long lastGlobalProcessedKey, long[] lastProcessedKeys, long[] lastGlobalProcessedKeys, boolean firstHandshakeForTarget, IReplicationGroupHistory groupHistory) {
        super(config, dataConsumer, exceptionHandler, replicationInFacade, name, groupName, sourceLookupName, lastProcessedKeys, lastGlobalProcessedKeys, firstHandshakeForTarget, groupHistory);
        this._lastGlobalProcessedKey = lastGlobalProcessedKey;
        this._batchDataConsumer = dataConsumer;
    }

    @Override
    protected boolean contentRequiredWhileProcessing() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MultiBucketSingleFileHandshakeResponse performHandshake(String memberName, IBacklogHandshakeRequest handshakeRequest) throws IncomingReplicationOutOfSyncException {
        this._lock.lock();
        try {
            MultiBucketSingleFileHandshakeResponse response = super.performHandshake(memberName, handshakeRequest);
            MultiBucketSingleFileHandshakeRequest typedHandshakeRequest = (MultiBucketSingleFileHandshakeRequest)handshakeRequest;
            this._lastGlobalProcessedKey = typedHandshakeRequest.isFirstHandshake() ? response.getLastProcessedGlobalKey() : Math.max(response.getLastProcessedGlobalKey(), this._lastGlobalProcessedKey);
            MultiBucketSingleFileHandshakeResponse multiBucketSingleFileHandshakeResponse = response;
            return multiBucketSingleFileHandshakeResponse;
        }
        finally {
            this._lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MultiBucketSingleFileProcessResult processBatch(String sourceLookupName, List<IReplicationOrderedPacket> packets, IReplicationInFilterCallback inFilterCallback) {
        this.validateOpen();
        this._lock.lock();
        try {
            this.validateNotClosed();
            this.filterDuplicate(packets);
            if (packets.isEmpty()) {
                MultiBucketSingleFileProcessResult multiBucketSingleFileProcessResult = MultiBucketSingleFileProcessResult.OK;
                return multiBucketSingleFileProcessResult;
            }
            long firstKeyInBatch = packets.get(0).getKey();
            if (this._lastGlobalProcessedKey + 1L < firstKeyInBatch) {
                MultiBucketSingleFileProcessResult multiBucketSingleFileProcessResult = new MultiBucketSingleFileProcessResult(new ReplicationInternalSpaceException("Incompatible keys, last processed is " + this._lastGlobalProcessedKey + " while first packets received is " + firstKeyInBatch));
                return multiBucketSingleFileProcessResult;
            }
            MultiBucketSingleFileProcessResult multiBucketSingleFileProcessResult = this.processPackets(sourceLookupName, packets, inFilterCallback);
            return multiBucketSingleFileProcessResult;
        }
        finally {
            this._lock.unlock();
        }
    }

    @Override
    public MultiBucketSingleFileProcessResult process(String sourceLookupName, IReplicationOrderedPacket packet, IReplicationInFilterCallback inFilterCallback) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MultiBucketSingleFileProcessResult processPackets(String sourceLookupName, List<IReplicationOrderedPacket> packets, IReplicationInFilterCallback inFilterCallback) throws Exception {
        MultiBucketSingleFileReplicationInBatchContext context = new MultiBucketSingleFileReplicationInBatchContext(this, sourceLookupName, this.getGroupName(), this._specificLogger, packets.size());
        int lastDataPacketIndex = this.locateLastDataPacketIndex(packets);
        int packetIndex = 0;
        block3: for (IReplicationOrderedPacket packet : packets) {
            if (packetIndex++ > lastDataPacketIndex) break;
            context.setCurrentPacket((IMultiBucketSingleFileReplicationOrderedPacket)packet);
            if (this.preprocess(packet)) {
                context.setContextPacket(packet);
                try {
                    IReplicationPacketData<?> data = packet.getData();
                    IDataConsumeResult prevResult = null;
                    while (true) {
                        this.validateNotClosed();
                        context.snapshot();
                        IDataConsumeResult consumeResult = this.getDataConsumer().consume(context, data, this.getReplicationInFacade(), inFilterCallback);
                        if (!consumeResult.isFailed()) continue block3;
                        MultiBucketSingleFileBatchConsumeTargetProcessLog.throwIfRepetitiveError(prevResult, consumeResult);
                        if (this._specificLogger.isLoggable(Level.FINER)) {
                            this._specificLogger.log(Level.FINER, "Encountered error while consuming packet [" + packet + "], trying to resolve issue", consumeResult.toException());
                        }
                        IDataConsumeFix fix = this.getExceptionHandler().handleException(consumeResult, null);
                        data = this.getDataConsumer().applyFix(context, data, fix);
                        if (this._specificLogger.isLoggable(Level.FINER)) {
                            this._specificLogger.log(Level.FINER, "Fix applied - retrying the operation [" + fix + "]");
                        }
                        context.rollback();
                        prevResult = consumeResult;
                    }
                }
                finally {
                    context.setContextPacket(null);
                    continue;
                }
            }
            context.updatePendingProcessedKeys();
        }
        this.consumePendingPacketsInBatch(context);
        int batchSize = packets.size();
        if (batchSize > 0 && lastDataPacketIndex < batchSize - 1) {
            this.updateProcessedOfRemainingPackets(lastDataPacketIndex, packets);
        }
        return MultiBucketSingleFileProcessResult.OK;
    }

    private void consumePendingPacketsInBatch(MultiBucketSingleFileReplicationInBatchContext context) throws Exception {
        this.validateNotClosed();
        IDataConsumeResult result = this._batchDataConsumer.consumePendingPackets(context, this.getReplicationInFacade());
        if (result.isFailed()) {
            throw result.toException();
        }
    }

    private int locateLastDataPacketIndex(List<IReplicationOrderedPacket> packets) {
        int lastDataPacketIndex = -1;
        int index = -1;
        for (IReplicationOrderedPacket packet : packets) {
            ++index;
            if (!packet.isDataPacket()) continue;
            lastDataPacketIndex = index;
        }
        return lastDataPacketIndex;
    }

    private boolean preprocess(IReplicationOrderedPacket packet) {
        if (packet.isDataPacket()) {
            return true;
        }
        if (packet instanceof DiscardedMultiBucketOrderedPacket) {
            return false;
        }
        if (packet instanceof DiscardedSingleBucketOrderedPacket) {
            return false;
        }
        return !(packet instanceof DeletedMultiBucketOrderedPacket);
    }

    @Override
    public void batchConsumed(ShortLongMap bucketProcessedKeys, ShortLongMap bucketGlobalProcessedKeys, long lastGlobalprocessedKey) {
        this._lastGlobalProcessedKey = lastGlobalprocessedKey;
        ShortLongIterator it = bucketProcessedKeys.iterator();
        while (it.hasNext()) {
            it.advance();
            short bucketIndex = it.key();
            this.getLastProcessedKeys()[bucketIndex] = it.value();
            this.getLastGlobalProcessedKeys()[bucketIndex] = bucketGlobalProcessedKeys.get(bucketIndex);
        }
    }

    private void updateProcessedOfRemainingPackets(int lastDataPacketIndex, List<IReplicationOrderedPacket> packets) {
        ShortLongMap bucketProcessedKeys = CollectionsFactory.getInstance().createShortLongMap();
        ShortLongMap bucketGlobalProcessedKeys = CollectionsFactory.getInstance().createShortLongMap();
        long lastGlobalprocessedKey = this._lastGlobalProcessedKey;
        int index = 0;
        for (IReplicationOrderedPacket packet : packets) {
            if (index++ < lastDataPacketIndex) continue;
            IMultiBucketSingleFileReplicationOrderedPacket typedPacket = (IMultiBucketSingleFileReplicationOrderedPacket)packet;
            for (short bucketIndex : typedPacket.getBuckets()) {
                bucketProcessedKeys.put(bucketIndex, typedPacket.getBucketKey(bucketIndex));
                bucketGlobalProcessedKeys.put(bucketIndex, packet.getKey());
            }
            lastGlobalprocessedKey = typedPacket.getKey();
        }
        this.batchConsumed(bucketProcessedKeys, bucketGlobalProcessedKeys, lastGlobalprocessedKey);
    }

    protected void filterDuplicate(List<IReplicationOrderedPacket> packets) {
        IReplicationOrderedPacket packet;
        Iterator<IReplicationOrderedPacket> iterator = packets.iterator();
        while (iterator.hasNext() && this.filterDuplicate(packet = iterator.next())) {
            iterator.remove();
        }
    }

    protected boolean filterDuplicate(IReplicationOrderedPacket packet) {
        return packet.getKey() <= this._lastGlobalProcessedKey;
    }

    public long getLastGlobalProcessedKey() {
        return this._lastGlobalProcessedKey;
    }

    @Override
    protected String dumpStateExtra() {
        return "last global processed key " + this._lastGlobalProcessedKey;
    }
}

