/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.processlog.multibucketsinglefile;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.cluster.node.impl.backlog.multibucketsinglefile.AbstractMultiBucketSingleFileGroupBacklog;
import com.gigaspaces.internal.cluster.node.impl.processlog.IProcessLogHandshakeResponse;
import com.gigaspaces.internal.io.IOUtils;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

@InternalApi
public class MultiBucketSingleFileHandshakeResponse
implements IProcessLogHandshakeResponse {
    private static final long serialVersionUID = 1L;
    private long[] _lastProcessesKeysBuckets;
    private long _lastProcessedGlobalKey;

    public MultiBucketSingleFileHandshakeResponse() {
    }

    public MultiBucketSingleFileHandshakeResponse(long[] lastProcessesKeysBuckets, long lastProcessedGlobalKey) {
        this._lastProcessesKeysBuckets = lastProcessesKeysBuckets;
        this._lastProcessedGlobalKey = lastProcessedGlobalKey;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(this._lastProcessedGlobalKey);
        IOUtils.writeLongArray(out, this._lastProcessesKeysBuckets);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this._lastProcessedGlobalKey = in.readLong();
        this._lastProcessesKeysBuckets = IOUtils.readLongArray(in);
    }

    public long[] getLastProcessesKeysBuckets() {
        return this._lastProcessesKeysBuckets;
    }

    public long getLastProcessedGlobalKey() {
        return this._lastProcessedGlobalKey;
    }

    @Override
    public String toLogMessage() {
        return "Handshake was successful. Last global process key by target is [" + this.getLastProcessedGlobalKey() + "] Last processed bucket keys by the target are " + AbstractMultiBucketSingleFileGroupBacklog.printBucketsKeys(this._lastProcessesKeysBuckets);
    }

    public String toString() {
        return this.toLogMessage();
    }
}

