/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.processlog.multibucketsinglefile;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.cluster.node.handlers.IReplicationInFacade;
import com.gigaspaces.internal.cluster.node.impl.backlog.IBacklogHandshakeRequest;
import com.gigaspaces.internal.cluster.node.impl.config.TargetGroupConfig;
import com.gigaspaces.internal.cluster.node.impl.groups.IReplicationGroupHistory;
import com.gigaspaces.internal.cluster.node.impl.groups.reliableasync.IReplicationReliableAsyncMediator;
import com.gigaspaces.internal.cluster.node.impl.packets.data.IReplicationPacketDataBatchConsumer;
import com.gigaspaces.internal.cluster.node.impl.processlog.IReplicationProcessLogBuilder;
import com.gigaspaces.internal.cluster.node.impl.processlog.IReplicationProcessLogExceptionHandler;
import com.gigaspaces.internal.cluster.node.impl.processlog.async.IReplicationAsyncTargetProcessLog;
import com.gigaspaces.internal.cluster.node.impl.processlog.async.IReplicationBatchConsumeAsyncTargetProcessLog;
import com.gigaspaces.internal.cluster.node.impl.processlog.multibucketsinglefile.MultiBucketSingleFileBatchConsumeTargetProcessLog;
import com.gigaspaces.internal.cluster.node.impl.processlog.multibucketsinglefile.MultiBucketSingleFileReliableAsyncTargetKeeperProcessLog;
import com.gigaspaces.internal.cluster.node.impl.processlog.multibucketsinglefile.MultiBucketSingleFileReliableAsyncTargetProcessLog;
import com.gigaspaces.internal.cluster.node.impl.processlog.multibucketsinglefile.MultiBucketSingleFileSyncTargetProcessLog;
import com.gigaspaces.internal.cluster.node.impl.processlog.reliableasync.IReplicationReliableAsyncTargetProcessLog;
import com.gigaspaces.internal.cluster.node.impl.processlog.sync.IReplicationSyncTargetProcessLog;
import java.util.logging.Logger;

@InternalApi
public class MultiBucketSingleFileProcessLogBuilder
implements IReplicationProcessLogBuilder {
    private final IReplicationPacketDataBatchConsumer<?> _dataConsumer;

    public MultiBucketSingleFileProcessLogBuilder(IReplicationPacketDataBatchConsumer<?> dataConsumer) {
        this._dataConsumer = dataConsumer;
    }

    @Override
    public IReplicationSyncTargetProcessLog createSyncProcessLog(TargetGroupConfig groupConfig, IReplicationInFacade replicationInFacade, IReplicationProcessLogExceptionHandler exceptionHandler, String myLookupName, String groupName, String sourceLookupName, IReplicationGroupHistory groupHistory) {
        return new MultiBucketSingleFileSyncTargetProcessLog(groupConfig.getProcessLogConfig(), this._dataConsumer, exceptionHandler, replicationInFacade, myLookupName, groupName, sourceLookupName, groupHistory);
    }

    @Override
    public IReplicationAsyncTargetProcessLog createAsyncProcessLog(TargetGroupConfig groupConfig, IReplicationInFacade replicationInFacade, IReplicationProcessLogExceptionHandler exceptionHandler, String myLookupName, String groupName, String sourceLookupName, IReplicationGroupHistory groupHistory) {
        throw new UnsupportedOperationException("Use global order replication processing instead");
    }

    @Override
    public IReplicationSyncTargetProcessLog createReliableAsyncKeeperProcessLog(TargetGroupConfig groupConfig, IReplicationInFacade replicationInFacade, IReplicationProcessLogExceptionHandler exceptionHandler, String myLookupName, String groupName, String sourceLookupName, IReplicationGroupHistory groupHistory, IReplicationReliableAsyncMediator mediator, IReplicationSyncTargetProcessLog synchronizingProcessLog) {
        if (synchronizingProcessLog == null) {
            return new MultiBucketSingleFileReliableAsyncTargetKeeperProcessLog(groupConfig.getProcessLogConfig(), this._dataConsumer, exceptionHandler, replicationInFacade, myLookupName, groupName, sourceLookupName, groupHistory, mediator);
        }
        MultiBucketSingleFileReliableAsyncTargetKeeperProcessLog typedSynchronizingProcessLog = (MultiBucketSingleFileReliableAsyncTargetKeeperProcessLog)synchronizingProcessLog;
        return new MultiBucketSingleFileReliableAsyncTargetKeeperProcessLog(groupConfig.getProcessLogConfig(), this._dataConsumer, exceptionHandler, replicationInFacade, myLookupName, groupName, sourceLookupName, typedSynchronizingProcessLog.getLastProcessedKeys(), typedSynchronizingProcessLog.getLastGlobalProcessedKeys(), typedSynchronizingProcessLog.isFirstHandshakeForTarget(), groupHistory, mediator);
    }

    @Override
    public IReplicationReliableAsyncTargetProcessLog createReliableAsyncProcessLog(TargetGroupConfig groupConfig, IBacklogHandshakeRequest handshakeRequest, IReplicationInFacade replicationInFacade, IReplicationProcessLogExceptionHandler exceptionHandler, String myLookupName, String groupName, String sourceLookupName, IReplicationReliableAsyncTargetProcessLog synchronizingProcessLog, IReplicationGroupHistory groupHistory, Logger specificLogger) {
        if (synchronizingProcessLog == null) {
            return new MultiBucketSingleFileReliableAsyncTargetProcessLog(groupConfig.getProcessLogConfig(), this._dataConsumer, exceptionHandler, replicationInFacade, myLookupName, groupName, sourceLookupName, groupHistory);
        }
        MultiBucketSingleFileReliableAsyncTargetProcessLog typedProcessLog = (MultiBucketSingleFileReliableAsyncTargetProcessLog)synchronizingProcessLog;
        return new MultiBucketSingleFileReliableAsyncTargetProcessLog(groupConfig.getProcessLogConfig(), this._dataConsumer, exceptionHandler, replicationInFacade, myLookupName, groupName, sourceLookupName, typedProcessLog.getLastGlobalProcessedKey(), typedProcessLog.getLastProcessedKeys(), typedProcessLog.getLastGlobalProcessedKeys(), typedProcessLog.isFirstHandshakeForTarget(), groupHistory);
    }

    @Override
    public IReplicationBatchConsumeAsyncTargetProcessLog createBatchConsumeAsyncProcessLog(TargetGroupConfig groupConfig, IBacklogHandshakeRequest handshakeRequest, IReplicationInFacade replicationInFacade, IReplicationProcessLogExceptionHandler exceptionHandler, String myLookupName, String groupName, String sourceLookupName, IReplicationGroupHistory groupHistory) {
        return new MultiBucketSingleFileBatchConsumeTargetProcessLog(groupConfig.getProcessLogConfig(), this._dataConsumer, exceptionHandler, replicationInFacade, myLookupName, groupName, sourceLookupName, groupHistory);
    }

    public String toString() {
        return "MultiBucketSingleFileProcessLogBuilder [_dataConsumer=" + this._dataConsumer + "]";
    }
}

