/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.processlog.multibucketsinglefile;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.cluster.node.impl.processlog.IProcessResult;
import com.gigaspaces.internal.io.IOUtils;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

@InternalApi
public class MultiBucketSingleFileProcessResult
implements IProcessResult {
    private static final long serialVersionUID = 1L;
    public static final MultiBucketSingleFileProcessResult OK = new MultiBucketSingleFileProcessResult(true);
    public static final MultiBucketSingleFileProcessResult PENDING = new MultiBucketSingleFileProcessResult(null);
    private boolean _processed;
    private Throwable _error;

    public MultiBucketSingleFileProcessResult() {
    }

    public MultiBucketSingleFileProcessResult(boolean processed) {
        this._processed = processed;
    }

    public MultiBucketSingleFileProcessResult(Throwable error) {
        this._processed = false;
        this._error = error;
    }

    public boolean isProcessed() {
        return this._processed;
    }

    public Throwable getError() {
        return this._error;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeBoolean(this._processed);
        if (!this._processed) {
            IOUtils.writeObject(out, this._error);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this._processed = in.readBoolean();
        if (!this._processed) {
            this._error = (Throwable)IOUtils.readObject(in);
        }
    }

    public boolean isPending() {
        return !this.isProcessed() && this.getError() == null;
    }
}

