/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.processlog.multibucketsinglefile;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.cluster.replication.IncomingReplicationOutOfSyncException;
import com.gigaspaces.internal.cluster.node.handlers.IReplicationInFacade;
import com.gigaspaces.internal.cluster.node.impl.ReplicationInContext;
import com.gigaspaces.internal.cluster.node.impl.backlog.IBacklogHandshakeRequest;
import com.gigaspaces.internal.cluster.node.impl.backlog.IBacklogMemberState;
import com.gigaspaces.internal.cluster.node.impl.backlog.multibucketsinglefile.IMultiBucketSingleFileReplicationOrderedPacket;
import com.gigaspaces.internal.cluster.node.impl.backlog.multibucketsinglefile.MultiBucketSingleFileReliableAsyncHandshakeRequest;
import com.gigaspaces.internal.cluster.node.impl.backlog.multibucketsinglefile.MultiBucketSingleFileReliableAsyncState;
import com.gigaspaces.internal.cluster.node.impl.backlog.reliableasync.ReliableAsyncHandshakeIteration;
import com.gigaspaces.internal.cluster.node.impl.backlog.reliableasync.SynchronizeMissingPacketsHandshakeIteration;
import com.gigaspaces.internal.cluster.node.impl.groups.IReplicationGroupHistory;
import com.gigaspaces.internal.cluster.node.impl.groups.IReplicationSourceGroup;
import com.gigaspaces.internal.cluster.node.impl.groups.handshake.IHandshakeIteration;
import com.gigaspaces.internal.cluster.node.impl.groups.reliableasync.IReplicationReliableAsyncMediator;
import com.gigaspaces.internal.cluster.node.impl.packets.IReplicationOrderedPacket;
import com.gigaspaces.internal.cluster.node.impl.packets.data.IReplicationPacketDataConsumer;
import com.gigaspaces.internal.cluster.node.impl.processlog.IReplicationProcessLogExceptionHandler;
import com.gigaspaces.internal.cluster.node.impl.processlog.ProcessLogConfig;
import com.gigaspaces.internal.cluster.node.impl.processlog.multibucketsinglefile.MultiBucketSingleFileHandshakeResponse;
import com.gigaspaces.internal.cluster.node.impl.processlog.multibucketsinglefile.MultiBucketSingleFileSyncTargetProcessLog;
import com.gigaspaces.internal.cluster.node.impl.processlog.reliableasync.IReplicationReliableAsyncKeeperTargetProcessLog;
import com.gigaspaces.internal.utils.ConditionLatch;
import com.j_spaces.core.exception.internal.ReplicationInternalSpaceException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

@InternalApi
public class MultiBucketSingleFileReliableAsyncTargetKeeperProcessLog
extends MultiBucketSingleFileSyncTargetProcessLog
implements IReplicationReliableAsyncKeeperTargetProcessLog {
    private final IReplicationReliableAsyncMediator _mediator;
    private final ReplicationInContext _replicationInContext;

    public MultiBucketSingleFileReliableAsyncTargetKeeperProcessLog(ProcessLogConfig config, IReplicationPacketDataConsumer<?> dataConsumer, IReplicationProcessLogExceptionHandler exceptionHandler, IReplicationInFacade replicationInFacade, String name, String groupName, String sourceLookupName, IReplicationGroupHistory groupHistory, IReplicationReliableAsyncMediator mediator) {
        super(config, dataConsumer, exceptionHandler, replicationInFacade, name, groupName, sourceLookupName, groupHistory);
        this._mediator = mediator;
        this._replicationInContext = this.createReplicationInContext();
    }

    public MultiBucketSingleFileReliableAsyncTargetKeeperProcessLog(ProcessLogConfig config, IReplicationPacketDataConsumer dataConsumer, IReplicationProcessLogExceptionHandler exceptionHandler, IReplicationInFacade replicationInFacade, String name, String groupName, String sourceLookupName, long[] lastProcessedKeys, long[] lastGlobalProcessedKeys, boolean firstHandshakeForTarget, IReplicationGroupHistory groupHistory, IReplicationReliableAsyncMediator mediator) {
        super(config, dataConsumer, exceptionHandler, replicationInFacade, name, groupName, sourceLookupName, lastProcessedKeys, lastGlobalProcessedKeys, firstHandshakeForTarget, groupHistory);
        this._mediator = mediator;
        this._replicationInContext = this.createReplicationInContext();
    }

    @Override
    public ReplicationInContext createReplicationInContext() {
        return new ReplicationInContext(this.getSourceLookupName(), this.getGroupName(), this._specificLogger, this.contentRequiredWhileProcessing(), false, this.getMediator());
    }

    @Override
    public ReplicationInContext getReplicationInContext() {
        return this._replicationInContext;
    }

    @Override
    protected boolean contentRequiredWhileProcessing() {
        return true;
    }

    @Override
    public IReplicationReliableAsyncMediator getMediator() {
        return this._mediator;
    }

    @Override
    protected boolean shouldCloneOnFilter() {
        return true;
    }

    @Override
    protected void afterSuccessfulConsumption(String sourceLookupName, IReplicationOrderedPacket packet) {
        super.afterSuccessfulConsumption(sourceLookupName, packet);
        IMultiBucketSingleFileReplicationOrderedPacket typedPacket = (IMultiBucketSingleFileReplicationOrderedPacket)packet;
        if (typedPacket.getReliableAsyncBeforeFilterPacket() != null) {
            packet = typedPacket.getReliableAsyncBeforeFilterPacket();
        }
        this._mediator.reliableAsyncSourceAdd(sourceLookupName, packet);
    }

    @Override
    public void processHandshakeIteration(final String sourceMemberName, IHandshakeIteration handshakeIteration) {
        if (handshakeIteration instanceof SynchronizeMissingPacketsHandshakeIteration) {
            final IReplicationSourceGroup sourceGroup = this.getReplicationInFacade().getReplicationSourceGroup(this.getGroupName());
            sourceGroup.createTemporaryChannel(sourceMemberName, Boolean.FALSE);
            ConditionLatch conditionLatch = new ConditionLatch();
            conditionLatch.timeout(30L, TimeUnit.SECONDS).pollingInterval(50L, TimeUnit.MILLISECONDS);
            try {
                conditionLatch.waitFor(new ConditionLatch.Predicate(){

                    @Override
                    public boolean isDone() throws InterruptedException {
                        if (sourceGroup.getGroupBacklog().size(sourceMemberName) == 0L) {
                            return true;
                        }
                        IBacklogMemberState state = sourceGroup.getGroupBacklog().getState(sourceMemberName);
                        if (state.isBacklogDropped()) {
                            if (MultiBucketSingleFileReliableAsyncTargetKeeperProcessLog.this._specificLogger.isLoggable(Level.WARNING)) {
                                MultiBucketSingleFileReliableAsyncTargetKeeperProcessLog.this._specificLogger.warning("failed completing missing packets from keeper to active primary - backlog is dropped for source, skipping process ");
                            }
                            return true;
                        }
                        if (!state.isExistingMember()) {
                            if (MultiBucketSingleFileReliableAsyncTargetKeeperProcessLog.this._specificLogger.isLoggable(Level.WARNING)) {
                                MultiBucketSingleFileReliableAsyncTargetKeeperProcessLog.this._specificLogger.warning("failed completing missing packets from keeper to active primary - source does not exists in backlog, skipping process ");
                            }
                            return true;
                        }
                        if (state.isInconsistent()) {
                            if (MultiBucketSingleFileReliableAsyncTargetKeeperProcessLog.this._specificLogger.isLoggable(Level.WARNING)) {
                                MultiBucketSingleFileReliableAsyncTargetKeeperProcessLog.this._specificLogger.log(Level.WARNING, "failed completing missing packets from keeper to active primary, skipping process", state.getInconsistencyReason());
                            }
                            return true;
                        }
                        return false;
                    }
                });
            }
            catch (Exception e) {
                throw new ReplicationInternalSpaceException("Timeout occurred while waiting for keeper to complete missing packets in the primary source");
            }
            finally {
                sourceGroup.closeTemporaryChannel(sourceMemberName);
            }
        } else {
            ReliableAsyncHandshakeIteration sharedHandshakeIteration = (ReliableAsyncHandshakeIteration)handshakeIteration;
            List<IReplicationOrderedPacket> packets = sharedHandshakeIteration.getPackets();
            for (IReplicationOrderedPacket packet : packets) {
                this._mediator.reliableAsyncSourceKeep(sourceMemberName, packet);
            }
        }
    }

    @Override
    public MultiBucketSingleFileHandshakeResponse performHandshake(String memberName, IBacklogHandshakeRequest handshakeRequest) throws IncomingReplicationOutOfSyncException {
        MultiBucketSingleFileHandshakeResponse response = super.performHandshake(memberName, handshakeRequest);
        if (!(handshakeRequest instanceof MultiBucketSingleFileReliableAsyncHandshakeRequest)) {
            throw new IllegalStateException("Trying to execute handshake with reliable async target keeper from source which is not in reliable async mode");
        }
        MultiBucketSingleFileReliableAsyncHandshakeRequest typedHandshakeRequest = (MultiBucketSingleFileReliableAsyncHandshakeRequest)handshakeRequest;
        MultiBucketSingleFileReliableAsyncState reliableAsyncState = typedHandshakeRequest.getReliableAsyncState();
        this._mediator.afterHandshake(response);
        this._mediator.updateReliableAsyncState(reliableAsyncState, memberName);
        return response;
    }

    @Override
    protected boolean canResetState() {
        return false;
    }
}

