/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.processlog.multibucketsinglefile;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.cluster.node.IReplicationInBatchContext;
import com.gigaspaces.internal.cluster.node.impl.ReplicationInContext;
import com.gigaspaces.internal.cluster.node.impl.backlog.multibucketsinglefile.IMultiBucketSingleFileReplicationOrderedPacket;
import com.gigaspaces.internal.cluster.node.impl.processlog.multibucketsinglefile.IBatchExecutedCallback;
import com.gigaspaces.internal.collections.CollectionsFactory;
import com.gigaspaces.internal.collections.ShortLongMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;

@InternalApi
public class MultiBucketSingleFileReplicationInBatchContext
extends ReplicationInContext
implements IReplicationInBatchContext {
    private final IBatchExecutedCallback _batchExecutedCallback;
    private final LinkedList<Object> _batchContext = new LinkedList();
    private final int _entireBatchSize;
    private final ShortLongMap _bucketProcessedKeys = CollectionsFactory.getInstance().createShortLongMap();
    private final ShortLongMap _bucketGlobalProcessedKeys = CollectionsFactory.getInstance().createShortLongMap();
    private long _lastUnprocessedKey;
    private IMultiBucketSingleFileReplicationOrderedPacket _currentPacket;
    private Object _tagObject;
    private int _snapshotBatchContextSize;
    private long _snapshotLastUnprocessedKeyInBatch;

    public MultiBucketSingleFileReplicationInBatchContext(IBatchExecutedCallback batchExecutedCallback, String sourceLookupName, String groupName, Logger contextLogger, int entireBatchSize) {
        super(sourceLookupName, groupName, contextLogger, false, false);
        this._batchExecutedCallback = batchExecutedCallback;
        this._entireBatchSize = entireBatchSize;
    }

    @Override
    public void pendingConsumed() {
        if (this._batchContext.isEmpty()) {
            throw new IllegalStateException("No pending operation to consume");
        }
        this._batchContext.clear();
        this._batchExecutedCallback.batchConsumed(this._bucketProcessedKeys, this._bucketGlobalProcessedKeys, this._lastUnprocessedKey);
    }

    @Override
    public <T> void addPendingContext(T operationContext) {
        this._batchContext.add(operationContext);
        this.updatePendingProcessedKeys();
    }

    public void updatePendingProcessedKeys() {
        for (short bucketIndex : this._currentPacket.getBuckets()) {
            long bucketKey = this._currentPacket.getBucketKey(bucketIndex);
            this._bucketProcessedKeys.put(bucketIndex, bucketKey);
            this._bucketGlobalProcessedKeys.put(bucketIndex, this._currentPacket.getKey());
        }
        this._lastUnprocessedKey = this._currentPacket.getKey();
    }

    @Override
    public <T> List<T> getPendingContext() {
        return this._batchContext;
    }

    public void setCurrentPacket(IMultiBucketSingleFileReplicationOrderedPacket packet) {
        this._currentPacket = packet;
    }

    @Override
    public void currentConsumed() {
        this.updatePendingProcessedKeys();
        this._batchExecutedCallback.batchConsumed(this._bucketProcessedKeys, this._bucketGlobalProcessedKeys, this._lastUnprocessedKey);
    }

    @Override
    public <T> void setTagObject(T tagObject) {
        this._tagObject = tagObject;
    }

    @Override
    public <T> T getTagObject() {
        return (T)this._tagObject;
    }

    @Override
    public int getEntireBatchSize() {
        return this._entireBatchSize;
    }

    public void snapshot() {
        this._snapshotBatchContextSize = this._batchContext.size();
        this._snapshotLastUnprocessedKeyInBatch = this._lastUnprocessedKey;
    }

    public void rollback() {
        int index = 0;
        Iterator iterator = this._batchContext.iterator();
        while (iterator.hasNext()) {
            iterator.next();
            if (index++ < this._snapshotBatchContextSize) continue;
            iterator.remove();
        }
        this._lastUnprocessedKey = this._snapshotLastUnprocessedKeyInBatch;
    }

    @Override
    public boolean isBatchContext() {
        return true;
    }
}

