/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.processlog.multibucketsinglefile;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.cluster.node.impl.packets.IReplicationOrderedPacket;
import com.gigaspaces.internal.cluster.node.impl.processlog.ReplicationConsumeTimeoutException;
import com.gigaspaces.time.SystemTime;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

@InternalApi
public class ParallelBatchProcessingContext {
    private final AtomicInteger _processedCount = new AtomicInteger(0);
    private Throwable _errorResult;
    private final List<IReplicationOrderedPacket>[] _parallelLists;
    private final int _parallelParticipants;

    public ParallelBatchProcessingContext(List<IReplicationOrderedPacket>[] parallelLists, int parallelParticipants) {
        this._parallelLists = parallelLists;
        this._parallelParticipants = parallelParticipants;
    }

    public synchronized void waitForCompletion(long timeout, TimeUnit units) throws Throwable {
        long startTime = SystemTime.timeMillis();
        while (this._processedCount.get() < this._parallelParticipants && this._errorResult == null) {
            long currentTime = SystemTime.timeMillis();
            if (currentTime - startTime > units.toMillis(timeout)) {
                throw new ReplicationConsumeTimeoutException("Timeout exceeded [" + timeout + "ms] while waiting for batch to be consumed");
            }
            this.wait(units.toMillis(timeout));
        }
        if (this._errorResult != null) {
            throw this._errorResult;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void signalOneProcessedOk() {
        if (this._processedCount.incrementAndGet() == this._parallelParticipants) {
            ParallelBatchProcessingContext parallelBatchProcessingContext = this;
            synchronized (parallelBatchProcessingContext) {
                this.notifyAll();
            }
        }
    }

    public synchronized void setError(Throwable error) {
        this._errorResult = error;
        this.notifyAll();
    }

    public List<IReplicationOrderedPacket> getSegment(int segmentIndex) {
        return this._parallelLists[segmentIndex];
    }
}

