/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.processlog.multibucketsinglefile;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.cluster.node.impl.ReplicationInContext;
import com.gigaspaces.internal.cluster.node.impl.backlog.multibucketsinglefile.DeletedMultiBucketOrderedPacket;
import com.gigaspaces.internal.cluster.node.impl.backlog.multibucketsinglefile.DiscardedMultiBucketOrderedPacket;
import com.gigaspaces.internal.cluster.node.impl.backlog.multibucketsinglefile.DiscardedSingleBucketOrderedPacket;
import com.gigaspaces.internal.cluster.node.impl.backlog.multibucketsinglefile.IMultiBucketSingleFileReplicationOrderedPacket;
import com.gigaspaces.internal.cluster.node.impl.backlog.multibucketsinglefile.MultipleBucketOrderedPacket;
import com.gigaspaces.internal.cluster.node.impl.backlog.multibucketsinglefile.PacketConsumeState;
import com.gigaspaces.internal.cluster.node.impl.filters.IReplicationInFilterCallback;
import com.gigaspaces.internal.cluster.node.impl.packets.data.IDataConsumeFix;
import com.gigaspaces.internal.cluster.node.impl.packets.data.IDataConsumeResult;
import com.gigaspaces.internal.cluster.node.impl.packets.data.IReplicationPacketData;
import com.gigaspaces.internal.cluster.node.impl.processlog.ReplicationConsumeTimeoutException;
import com.gigaspaces.internal.cluster.node.impl.processlog.multibucketsinglefile.AbstractMultiBucketSingleFileTargetProcessLog;
import com.gigaspaces.internal.cluster.node.impl.processlog.multibucketsinglefile.MultiBucketSingleFileProcessResult;
import com.gigaspaces.internal.cluster.node.impl.processlog.multibucketsinglefile.ParallelBatchProcessingContext;
import com.gigaspaces.internal.cluster.node.impl.processlog.multibucketsinglefile.ProcessExchangeObject;
import com.gigaspaces.internal.collections.CollectionsFactory;
import com.gigaspaces.internal.collections.LongObjectIterator;
import com.gigaspaces.internal.collections.LongObjectMap;
import com.gigaspaces.internal.utils.concurrent.ExchangeCountDownLatch;
import com.j_spaces.core.exception.ClosedResourceException;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;

@InternalApi
public class ProcessLogBucket {
    private final Lock _lock = new ReentrantLock();
    private final SortedSet<IMultiBucketSingleFileReplicationOrderedPacket> _packetsQueue;
    private final LongObjectMap<ExchangeCountDownLatch<ProcessExchangeObject>> _pendingPackets = CollectionsFactory.getInstance().createLongObjectMap();
    private final AbstractMultiBucketSingleFileTargetProcessLog _processLog;
    private final short _bucketIndex;
    private final ReplicationInContext _replicationInContext;

    public ProcessLogBucket(short bucketIndex, AbstractMultiBucketSingleFileTargetProcessLog processLog) {
        this._bucketIndex = bucketIndex;
        this._processLog = processLog;
        this._packetsQueue = new TreeSet<IMultiBucketSingleFileReplicationOrderedPacket>(new MultiBucketSingleFileOrderedPacketComperator(bucketIndex));
        this._replicationInContext = this._processLog.createReplicationInContext();
    }

    private ExchangeCountDownLatch<ProcessExchangeObject> addPendingPacketLock(long waitOnKey, ParallelBatchProcessingContext batchContext, int segmentIndex) {
        ExchangeCountDownLatch<ProcessExchangeObject> latch = new ExchangeCountDownLatch<ProcessExchangeObject>();
        if (batchContext != null) {
            latch.exchange(new ProcessExchangeObject(batchContext, segmentIndex));
        }
        this._pendingPackets.put(waitOnKey, latch);
        return latch;
    }

    private ExchangeCountDownLatch<ProcessExchangeObject> addPendingPacketLock(long waitOnKey) {
        return this.addPendingPacketLock(waitOnKey, null, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseOnErrorResult(Throwable error) {
        this._lock.lock();
        try {
            LongObjectIterator<ExchangeCountDownLatch<ProcessExchangeObject>> iterator = this._pendingPackets.iterator();
            while (iterator.hasNext()) {
                iterator.advance();
                ExchangeCountDownLatch<ProcessExchangeObject> latch = iterator.value();
                ProcessExchangeObject processExchangeObject = latch.get();
                if (processExchangeObject != null) {
                    processExchangeObject.getBatchContext().setError(error);
                    continue;
                }
                latch.countDown(new ProcessExchangeObject(error));
            }
            this._pendingPackets.clear();
        }
        finally {
            this._lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProcessResult processPackets(String sourceLookupName, IReplicationInFilterCallback inFilterCallback, long myLastKey) throws Exception {
        Iterator iterator = this._packetsQueue.iterator();
        while (iterator.hasNext()) {
            long lastProcessedKey;
            IMultiBucketSingleFileReplicationOrderedPacket packet = (IMultiBucketSingleFileReplicationOrderedPacket)iterator.next();
            long packetBucketKey = packet.getBucketKey(this._bucketIndex);
            if (packetBucketKey > (lastProcessedKey = this._processLog.getLastProcessedKeys()[this._bucketIndex]) + 1L) {
                return lastProcessedKey >= myLastKey ? ProcessResult.CONSUMED : ProcessResult.MISSING_PACKET;
            }
            boolean processedAlready = false;
            boolean wasPreprocessed = true;
            if (this.preprocess(packet)) {
                wasPreprocessed = false;
                PacketConsumeState packetConsumeState = packet.getConsumeState(this._bucketIndex);
                block1 : switch (packetConsumeState) {
                    case CAN_CONSUME: {
                        this._replicationInContext.setContextPacket(packet);
                        try {
                            IReplicationPacketData<?> data = packet.getData();
                            if (inFilterCallback != null && this._processLog.shouldCloneOnFilter()) {
                                data = data.clone();
                            }
                            IDataConsumeResult prevResult = null;
                            while (true) {
                                this._processLog.validateNotClosed();
                                IDataConsumeResult consumeResult = this._processLog.getDataConsumer().consume(this._replicationInContext, data, this._processLog.getReplicationInFacade(), inFilterCallback);
                                if (!consumeResult.isFailed()) {
                                    processedAlready = !packet.setConsumed();
                                    break block1;
                                }
                                AbstractMultiBucketSingleFileTargetProcessLog.throwIfRepetitiveError(prevResult, consumeResult);
                                if (this._replicationInContext.getContextLogger().isLoggable(Level.FINER)) {
                                    this._replicationInContext.getContextLogger().log(Level.FINER, "Encountered error while consuming packet [" + packet + "], trying to resolve issue", consumeResult.toException());
                                }
                                IDataConsumeFix fix = this._processLog.getExceptionHandler().handleException(consumeResult, packet);
                                data = this._processLog.getDataConsumer().applyFix(this._replicationInContext, data, fix);
                                if (this._replicationInContext.getContextLogger().isLoggable(Level.FINER)) {
                                    this._replicationInContext.getContextLogger().log(Level.FINER, "Fix applied - retrying the operation [" + fix + "]");
                                }
                                prevResult = consumeResult;
                            }
                        }
                        finally {
                            this._replicationInContext.setContextPacket(null);
                        }
                    }
                    case PENDING: {
                        if (lastProcessedKey >= myLastKey) {
                            return ProcessResult.CONSUMED;
                        }
                        if (packetBucketKey < myLastKey) {
                            return ProcessResult.MISSING_PACKET;
                        }
                        return ProcessResult.PENDING_CONSUMPTION;
                    }
                    case CONSUMED: {
                        processedAlready = true;
                    }
                }
                this._processLog.getLastProcessedKeys()[this._bucketIndex] = lastProcessedKey + 1L;
                this._processLog.getLastGlobalProcessedKeys()[this._bucketIndex] = packet.getKey();
            }
            if (this.wasConsumedByThisIteartion(packet, wasPreprocessed, processedAlready)) {
                this._processLog.afterSuccessfulConsumption(sourceLookupName, packet);
            }
            iterator.remove();
            ExchangeCountDownLatch<ProcessExchangeObject> latch = this._pendingPackets.remove(this._processLog.getLastProcessedKeys()[this._bucketIndex]);
            if (latch == null) continue;
            ProcessExchangeObject processExchangeObject = latch.get();
            if (processExchangeObject != null) {
                ParallelBatchProcessingContext batchContext = processExchangeObject.getBatchContext();
                int segmentIndex = processExchangeObject.getSegmentIndex();
                this._processLog.createBatchParallelProcessingContinuationTask(sourceLookupName, inFilterCallback, batchContext, batchContext.getSegment(segmentIndex), segmentIndex);
                continue;
            }
            latch.countDown(null);
        }
        return ProcessResult.CONSUMED;
    }

    private boolean wasConsumedByThisIteartion(IMultiBucketSingleFileReplicationOrderedPacket packet, boolean wasPreprocessed, boolean processedAlready) {
        if (wasPreprocessed) {
            return packet.setConsumed();
        }
        return !processedAlready;
    }

    public MultiBucketSingleFileProcessResult addAndProcess(String sourceLookupName, IMultiBucketSingleFileReplicationOrderedPacket packet, IReplicationInFilterCallback inFilterCallback, ParallelBatchProcessingContext batchContext, int segmentIndex) throws Throwable {
        ProcessResult processResult;
        ExchangeCountDownLatch<ProcessExchangeObject> latch = null;
        long myPacketKey = packet.getBucketKey(this._bucketIndex);
        boolean isSingleBucket = packet.bucketCount() == 1;
        this._lock.lock();
        try {
            this._processLog.validateNotClosed();
            if (this.filterDuplicate(packet)) {
                MultiBucketSingleFileProcessResult multiBucketSingleFileProcessResult = MultiBucketSingleFileProcessResult.OK;
                return multiBucketSingleFileProcessResult;
            }
            this._packetsQueue.add(packet);
            processResult = this.processPackets(sourceLookupName, inFilterCallback, myPacketKey);
            if (processResult != ProcessResult.CONSUMED && this.shouldWaitForConsumption(processResult, isSingleBucket)) {
                latch = this.addPendingPacketLock(myPacketKey - 1L, batchContext, segmentIndex);
            }
        }
        catch (Throwable t) {
            throw t;
        }
        finally {
            this._lock.unlock();
        }
        if (latch == null) {
            return MultiBucketSingleFileProcessResult.OK;
        }
        if (batchContext != null) {
            return MultiBucketSingleFileProcessResult.PENDING;
        }
        ProcessExchangeObject prevPacketConsumeResult = this.waitForPacketConsumption(latch, myPacketKey - 1L);
        if (prevPacketConsumeResult != null) {
            return new MultiBucketSingleFileProcessResult(prevPacketConsumeResult.getError());
        }
        this._lock.lock();
        try {
            this._processLog.validateNotClosed();
            if (this._processLog.getLastProcessedKeys()[this._bucketIndex] >= myPacketKey) {
                MultiBucketSingleFileProcessResult multiBucketSingleFileProcessResult = MultiBucketSingleFileProcessResult.OK;
                return multiBucketSingleFileProcessResult;
            }
            processResult = this.processPackets(sourceLookupName, inFilterCallback, myPacketKey);
            if (processResult == ProcessResult.MISSING_PACKET) {
                throw new IllegalStateException();
            }
            MultiBucketSingleFileProcessResult multiBucketSingleFileProcessResult = MultiBucketSingleFileProcessResult.OK;
            return multiBucketSingleFileProcessResult;
        }
        catch (Throwable t) {
            throw t;
        }
        finally {
            this._lock.unlock();
        }
    }

    private boolean shouldWaitForConsumption(ProcessResult processedPacket, boolean isSingleBucket) {
        return isSingleBucket || processedPacket == ProcessResult.MISSING_PACKET;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void signalDoneProcessing(String sourceLookupName, MultipleBucketOrderedPacket packet, IReplicationInFilterCallback inFilterCallback) {
        this._lock.lock();
        try {
            ExchangeCountDownLatch<ProcessExchangeObject> latch = this._pendingPackets.remove(packet.getBucketKey(this._bucketIndex));
            if (latch != null) {
                ProcessExchangeObject processExchangeObject = latch.get();
                if (processExchangeObject != null) {
                    ParallelBatchProcessingContext batchContext = processExchangeObject.getBatchContext();
                    int segmentIndex = processExchangeObject.getSegmentIndex();
                    this._processLog.createBatchParallelProcessingContinuationTask(sourceLookupName, inFilterCallback, batchContext, batchContext.getSegment(segmentIndex), segmentIndex);
                } else {
                    latch.countDown(null);
                }
            }
        }
        finally {
            this._lock.unlock();
        }
    }

    public void add(List<IMultiBucketSingleFileReplicationOrderedPacket> packets) {
        this._lock.lock();
        try {
            this._processLog.validateNotClosed();
            this.filterDuplicates(packets);
            if (packets.isEmpty()) {
                return;
            }
            this._packetsQueue.addAll(packets);
        }
        finally {
            this._lock.unlock();
        }
    }

    public Throwable process(String sourceLookupName, List<IMultiBucketSingleFileReplicationOrderedPacket> bucketPackets, IReplicationInFilterCallback inFilterCallback) throws Throwable {
        this._lock.lock();
        boolean releaseLock = true;
        try {
            this._processLog.validateNotClosed();
            Iterator<IMultiBucketSingleFileReplicationOrderedPacket> iterator = bucketPackets.iterator();
            while (iterator.hasNext()) {
                IMultiBucketSingleFileReplicationOrderedPacket packet = iterator.next();
                boolean isSingleBucket = packet.bucketCount() == 1;
                long myPacketKey = packet.getBucketKey(this._bucketIndex);
                ProcessResult processResult = this.processPackets(sourceLookupName, inFilterCallback, myPacketKey);
                if (processResult != ProcessResult.CONSUMED) {
                    if (this.shouldWaitForConsumption(processResult, isSingleBucket)) {
                        ExchangeCountDownLatch<ProcessExchangeObject> latch = this.addPendingPacketLock(myPacketKey - 1L);
                        this._lock.unlock();
                        releaseLock = false;
                        ProcessExchangeObject prevPacketConsumeError = this.waitForPacketConsumption(latch, myPacketKey - 1L);
                        this._lock.lock();
                        releaseLock = true;
                        if (prevPacketConsumeError != null) {
                            Throwable throwable = prevPacketConsumeError.getError();
                            return throwable;
                        }
                        this._processLog.validateNotClosed();
                        if (this._processLog.getLastProcessedKeys()[this._bucketIndex] >= myPacketKey) {
                            iterator.remove();
                            continue;
                        }
                        processResult = this.processPackets(sourceLookupName, inFilterCallback, myPacketKey);
                        switch (processResult) {
                            case CONSUMED: {
                                iterator.remove();
                                break;
                            }
                            case PENDING_CONSUMPTION: {
                                if (isSingleBucket) {
                                    throw new IllegalStateException();
                                }
                                Throwable throwable = null;
                                return throwable;
                            }
                            case MISSING_PACKET: {
                                throw new IllegalStateException();
                            }
                        }
                        continue;
                    }
                    Throwable throwable = null;
                    return throwable;
                }
                iterator.remove();
            }
            iterator = null;
            return iterator;
        }
        catch (Throwable t) {
            throw t;
        }
        finally {
            if (releaseLock) {
                this._lock.unlock();
            }
        }
    }

    private ProcessExchangeObject waitForPacketConsumption(ExchangeCountDownLatch<ProcessExchangeObject> latch, long keyWaitingFor) throws InterruptedException {
        if (!latch.await(this._processLog.getConsumeTimeout(), TimeUnit.MILLISECONDS)) {
            throw new ReplicationConsumeTimeoutException("Timeout exceeded [" + this._processLog.getConsumeTimeout() + "ms] while waiting for packet of bucket [" + this._bucketIndex + "] with bucket key [" + keyWaitingFor + "] to be consumed");
        }
        return latch.get();
    }

    private boolean preprocess(IMultiBucketSingleFileReplicationOrderedPacket packet) {
        if (packet.isDataPacket()) {
            return true;
        }
        if (packet instanceof DiscardedSingleBucketOrderedPacket || packet instanceof DiscardedMultiBucketOrderedPacket) {
            this._processLog.getLastProcessedKeys()[this._bucketIndex] = packet.getBucketKey(this._bucketIndex);
            this._processLog.getLastGlobalProcessedKeys()[this._bucketIndex] = packet.getKey();
        }
        if (packet instanceof DeletedMultiBucketOrderedPacket) {
            this._processLog.getLastProcessedKeys()[this._bucketIndex] = ((DeletedMultiBucketOrderedPacket)packet).getBucketEndKey(this._bucketIndex);
            this._processLog.getLastGlobalProcessedKeys()[this._bucketIndex] = ((DeletedMultiBucketOrderedPacket)packet).getEndKey();
        }
        return false;
    }

    public String printPendingState() {
        this._lock.lock();
        try {
            if (this._packetsQueue.isEmpty()) {
                String string = "EMPTY";
                return string;
            }
            IMultiBucketSingleFileReplicationOrderedPacket first = this._packetsQueue.first();
            String string = "pending packets [" + this._packetsQueue.size() + "], first packet [" + first.toString() + "]";
            return string;
        }
        finally {
            this._lock.unlock();
        }
    }

    protected boolean filterDuplicate(IMultiBucketSingleFileReplicationOrderedPacket packet) {
        return packet.getBucketKey(this._bucketIndex) <= this._processLog.getLastProcessedKeys()[this._bucketIndex];
    }

    private void filterDuplicates(List<IMultiBucketSingleFileReplicationOrderedPacket> packets) {
        Iterator<IMultiBucketSingleFileReplicationOrderedPacket> iterator = packets.iterator();
        while (iterator.hasNext()) {
            IMultiBucketSingleFileReplicationOrderedPacket packet = iterator.next();
            if (!this.filterDuplicate(packet)) continue;
            iterator.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean close(long time, TimeUnit unit) throws InterruptedException {
        if (time > 0L && !this._lock.tryLock(time, unit) || time <= 0L && !this._lock.tryLock()) {
            return false;
        }
        try {
            this.releaseOnErrorResult(new ClosedResourceException("Process log is closed"));
            boolean bl = true;
            return bl;
        }
        finally {
            this._lock.unlock();
        }
    }

    public static class MultiBucketSingleFileOrderedPacketComperator
    implements Comparator<IMultiBucketSingleFileReplicationOrderedPacket> {
        private final short _bucketIndex;

        public MultiBucketSingleFileOrderedPacketComperator(short bucketIndex) {
            this._bucketIndex = bucketIndex;
        }

        @Override
        public int compare(IMultiBucketSingleFileReplicationOrderedPacket o1, IMultiBucketSingleFileReplicationOrderedPacket o2) {
            return o1.getBucketKey(this._bucketIndex) < o2.getBucketKey(this._bucketIndex) ? -1 : (o1.getBucketKey(this._bucketIndex) == o2.getBucketKey(this._bucketIndex) ? 0 : 1);
        }
    }

    private static enum ProcessResult {
        CONSUMED,
        MISSING_PACKET,
        PENDING_CONSUMPTION;

    }
}

