/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.processlog.multisourcesinglefile;

import com.gigaspaces.api.InternalApi;

@InternalApi
public class DistributedTransactionProcessingConfiguration {
    private long _timeoutBeforePartialCommit;
    private long _waitForOperationsBeforePartialCommit;
    private boolean _monitorPendingOperationsMemory = true;
    protected boolean _overriden;

    public DistributedTransactionProcessingConfiguration(long distributedTransactionWaitTimeout, long distributedTransactionWaitForOperations) {
        this._timeoutBeforePartialCommit = distributedTransactionWaitTimeout;
        this.setWaitForOperationsBeforePartialCommit(distributedTransactionWaitForOperations);
        this._overriden = false;
    }

    public void setTimeoutBeforePartialCommit(long timeoutBeforePartialCommit) {
        if (timeoutBeforePartialCommit < 0L) {
            throw new IllegalArgumentException("timeoutBeforePartialCommit was set to " + timeoutBeforePartialCommit + " but should be greater than 0");
        }
        this._timeoutBeforePartialCommit = timeoutBeforePartialCommit;
        this._overriden = true;
    }

    public void setWaitForOperationsBeforePartialCommit(long waitForOperationsBeforePartialCommit) {
        if (waitForOperationsBeforePartialCommit < -1L) {
            throw new IllegalArgumentException("waitForOperationsBeforePartialCommit was set to " + waitForOperationsBeforePartialCommit + " but should be -1 or greater than 0");
        }
        this._waitForOperationsBeforePartialCommit = waitForOperationsBeforePartialCommit == -1L ? Long.MAX_VALUE : waitForOperationsBeforePartialCommit;
        this._overriden = true;
    }

    public long getTimeoutBeforePartialCommit() {
        return this._timeoutBeforePartialCommit;
    }

    public long getWaitForOperationsBeforePartialCommit() {
        return this._waitForOperationsBeforePartialCommit;
    }

    public boolean isOverriden() {
        return this._overriden;
    }

    public boolean isMonitorPendingOperationsMemory() {
        return this._monitorPendingOperationsMemory;
    }

    public void setMonitorPendingOperationsMemory(boolean monitorPendingOperationsMemory) {
        this._monitorPendingOperationsMemory = monitorPendingOperationsMemory;
        this._overriden = true;
    }

    public String toString() {
        return "DistributedTransactionProcessingConfiguration [getTimeoutBeforePartialCommit()=" + this.getTimeoutBeforePartialCommit() + ", getWaitForOperationsBeforePartialCommit()=" + this.getWaitForOperationsBeforePartialCommit() + ", monitorPendingOperationsMemory=" + this._monitorPendingOperationsMemory + "]";
    }
}

