/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.processlog.multisourcesinglefile;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.cluster.node.impl.packets.IReplicationOrderedPacket;
import com.gigaspaces.internal.cluster.node.impl.packets.data.IReplicationPacketData;
import com.gigaspaces.internal.cluster.node.impl.packets.data.IReplicationParticipantsMetadata;
import com.gigaspaces.internal.cluster.node.impl.processlog.multisourcesinglefile.IReplicationParticipantsMediator;
import com.gigaspaces.internal.cluster.node.impl.processlog.multisourcesinglefile.MultiSourceProcessLogPacket;
import com.gigaspaces.time.SystemTime;

@InternalApi
public class MultiSourceProcessLogMultiParticipantPacket
extends MultiSourceProcessLogPacket {
    private final IReplicationParticipantsMediator _mediator;
    private IReplicationPacketData<?> _mergedData;
    private IReplicationParticipantsMetadata _participantsMetadata;
    private boolean _registeredInMediator;
    private long _creationTime;

    public MultiSourceProcessLogMultiParticipantPacket(IReplicationOrderedPacket packet, IReplicationParticipantsMediator participantsMediator, IReplicationParticipantsMetadata participantsMetadata) {
        super(packet);
        this._mediator = participantsMediator;
        this._participantsMetadata = participantsMetadata;
        this._creationTime = SystemTime.timeMillis();
    }

    @Override
    public void setData(IReplicationPacketData<?> mergedData) {
        this._mergedData = mergedData;
    }

    @Override
    public IReplicationPacketData<?> getData() {
        return this._mergedData != null ? this._mergedData : this._packet.getData();
    }

    @Override
    public boolean hasDependencies() {
        if (this._dependencies != null) {
            for (MultiSourceProcessLogPacket dependency : this._dependencies) {
                if (!(this.isConsolidatedByThisParticipant() ? dependency._state == MultiSourceProcessLogPacket.MultiSourcePacketState.UNCONSUMED : dependency._state != MultiSourceProcessLogPacket.MultiSourcePacketState.CONSUMED)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isConsolidatedByThisParticipant() {
        return this._mergedData != null;
    }

    @Override
    public boolean isMultiParticipant() {
        return true;
    }

    @Override
    public boolean isRegisteredInMediator() {
        return this._registeredInMediator;
    }

    @Override
    public void setRegisteredInMediator() {
        this._registeredInMediator = true;
    }

    @Override
    public IReplicationParticipantsMetadata getParticipantsMetadata() {
        return this._participantsMetadata;
    }

    @Override
    public long getCreationTime() {
        return this._creationTime;
    }

    @Override
    public boolean isConsumedByOtherParticipant() {
        return !this.isConsolidatedByThisParticipant() && this._mediator.isConsumed(this._participantsMetadata.getContextId());
    }
}

