/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.processlog.multisourcesinglefile;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.cluster.node.impl.packets.IReplicationOrderedPacket;
import com.gigaspaces.internal.cluster.node.impl.packets.data.IReplicationPacketData;
import com.gigaspaces.internal.cluster.node.impl.packets.data.IReplicationParticipantsMetadata;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

@InternalApi
public class MultiSourceProcessLogPacket {
    protected final IReplicationOrderedPacket _packet;
    protected List<MultiSourceProcessLogPacket> _dependencies;
    protected MultiSourcePacketState _state;

    public MultiSourceProcessLogPacket(IReplicationOrderedPacket packet) {
        this._packet = packet;
        this._state = MultiSourcePacketState.UNCONSUMED;
    }

    public void setUnconsumed() {
        this._state = MultiSourcePacketState.UNCONSUMED;
    }

    public void setBeingConsumed() {
        this._state = MultiSourcePacketState.BEING_CONSUMED;
    }

    public boolean isMultiParticipant() {
        return false;
    }

    public IReplicationPacketData<?> getData() {
        return this._packet.getData();
    }

    public boolean isConsolidatedByThisParticipant() {
        return false;
    }

    public boolean isConsumed() {
        return this._state == MultiSourcePacketState.CONSUMED;
    }

    public IReplicationOrderedPacket getReplicationPacket() {
        return this._packet;
    }

    public long getKey() {
        return this._packet.getKey();
    }

    public boolean hasDependencies() {
        if (this._dependencies != null) {
            for (MultiSourceProcessLogPacket dependency : this._dependencies) {
                if (dependency._state != MultiSourcePacketState.UNCONSUMED) continue;
                return true;
            }
        }
        return false;
    }

    public void addDependency(MultiSourceProcessLogPacket dependencyPacket) {
        if (this._dependencies == null) {
            this._dependencies = new LinkedList<MultiSourceProcessLogPacket>();
        }
        this._dependencies.add(dependencyPacket);
    }

    public boolean isBeingConsumed() {
        return this._state == MultiSourcePacketState.BEING_CONSUMED;
    }

    public void setConsumed() {
        this._state = MultiSourcePacketState.CONSUMED;
    }

    public String toString() {
        ArrayList<Long> keys = new ArrayList<Long>(this._dependencies == null ? 0 : this._dependencies.size());
        if (this._dependencies != null) {
            for (MultiSourceProcessLogPacket dependency : this._dependencies) {
                keys.add(dependency.getKey());
            }
        }
        return "MultiSourceProcessLogPacket [state=" + (Object)((Object)this._state) + ", packet = " + this._packet.toString() + ", dependencies=" + keys + "]";
    }

    public boolean isConsumedByOtherParticipant() {
        return false;
    }

    public IReplicationParticipantsMetadata getParticipantsMetadata() {
        throw new UnsupportedOperationException();
    }

    public void setRegisteredInMediator() {
        throw new UnsupportedOperationException();
    }

    public void setData(IReplicationPacketData<?> mergedData) {
        throw new UnsupportedOperationException();
    }

    public boolean isRegisteredInMediator() {
        throw new UnsupportedOperationException();
    }

    public long getCreationTime() {
        throw new UnsupportedOperationException();
    }

    protected static enum MultiSourcePacketState {
        UNCONSUMED,
        BEING_CONSUMED,
        CONSUMED;

    }
}

