/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.processlog.multisourcesinglefile;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.cluster.replication.IncomingReplicationOutOfSyncException;
import com.gigaspaces.internal.cluster.node.handlers.IReplicationInFacade;
import com.gigaspaces.internal.cluster.node.impl.backlog.IBacklogHandshakeRequest;
import com.gigaspaces.internal.cluster.node.impl.backlog.IIdleStateData;
import com.gigaspaces.internal.cluster.node.impl.backlog.globalorder.GlobalOrderBacklogHandshakeRequest;
import com.gigaspaces.internal.cluster.node.impl.backlog.globalorder.GlobalOrderDeletedBacklogPacket;
import com.gigaspaces.internal.cluster.node.impl.backlog.globalorder.GlobalOrderDiscardedReplicationPacket;
import com.gigaspaces.internal.cluster.node.impl.filters.IReplicationInFilterCallback;
import com.gigaspaces.internal.cluster.node.impl.groups.IReplicationGroupHistory;
import com.gigaspaces.internal.cluster.node.impl.groups.handshake.IHandshakeIteration;
import com.gigaspaces.internal.cluster.node.impl.packets.IReplicationOrderedPacket;
import com.gigaspaces.internal.cluster.node.impl.packets.data.IDataConsumeFix;
import com.gigaspaces.internal.cluster.node.impl.packets.data.IDataConsumeResult;
import com.gigaspaces.internal.cluster.node.impl.packets.data.IReplicationPacketData;
import com.gigaspaces.internal.cluster.node.impl.packets.data.IReplicationPacketDataBatchConsumer;
import com.gigaspaces.internal.cluster.node.impl.packets.data.IReplicationPacketEntryData;
import com.gigaspaces.internal.cluster.node.impl.packets.data.IReplicationParticipantsMetadata;
import com.gigaspaces.internal.cluster.node.impl.processlog.AbstractSingleFileTargetProcessLog;
import com.gigaspaces.internal.cluster.node.impl.processlog.IProcessLogHandshakeResponse;
import com.gigaspaces.internal.cluster.node.impl.processlog.IProcessResult;
import com.gigaspaces.internal.cluster.node.impl.processlog.IReplicationProcessLogExceptionHandler;
import com.gigaspaces.internal.cluster.node.impl.processlog.ProcessLogState;
import com.gigaspaces.internal.cluster.node.impl.processlog.globalorder.GlobalOrderProcessLogHandshakeResponse;
import com.gigaspaces.internal.cluster.node.impl.processlog.globalorder.GlobalOrderProcessResult;
import com.gigaspaces.internal.cluster.node.impl.processlog.multisourcesinglefile.IPacketConsumedCallback;
import com.gigaspaces.internal.cluster.node.impl.processlog.multisourcesinglefile.IReplicationParticipantsMediator;
import com.gigaspaces.internal.cluster.node.impl.processlog.multisourcesinglefile.MultiSourceProcessLogMultiParticipantPacket;
import com.gigaspaces.internal.cluster.node.impl.processlog.multisourcesinglefile.MultiSourceProcessLogPacket;
import com.gigaspaces.internal.cluster.node.impl.processlog.multisourcesinglefile.MultiSourceSingleFileProcessLogConfig;
import com.gigaspaces.internal.cluster.node.impl.processlog.multisourcesinglefile.MultiSourceSingleFileReplicationInBatchContext;
import com.gigaspaces.internal.cluster.node.impl.processlog.reliableasync.IReplicationReliableAsyncTargetProcessLog;
import com.gigaspaces.start.SystemInfo;
import com.gigaspaces.time.SystemTime;
import com.j_spaces.core.IProcessMemoryManager;
import com.j_spaces.core.MemoryShortageException;
import com.j_spaces.core.exception.ClosedResourceException;
import com.j_spaces.core.exception.internal.ReplicationInternalSpaceException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;

@InternalApi
public class MultiSourceSingleFileReliableAsyncTargetProcessLog
extends AbstractSingleFileTargetProcessLog
implements IReplicationReliableAsyncTargetProcessLog,
IPacketConsumedCallback {
    private final Object _lifeCycleLock = new Object();
    private final Lock _lock = new ReentrantLock();
    private final IReplicationParticipantsMediator _participantsMediator;
    private final MultiSourceSingleFileProcessLogConfig _processLogConfig;
    private final IReplicationPacketDataBatchConsumer<?> _batchDataConsumer;
    private final LinkedList<Long> _batchConsumedPacketsKeys;
    private final HashMap<String, MultiSourceProcessLogPacket> _packetsByUidHelperMap;
    private final IProcessMemoryManager _processMemoryManager;
    private long _lastProcessedKey;
    private long _firstUnprocessedKey;
    private ProcessLogState _state = ProcessLogState.OPEN;
    private boolean _firstHandshakeForTarget;
    private LinkedList<MultiSourceProcessLogPacket> _pendingPacketsQueue;

    public MultiSourceSingleFileReliableAsyncTargetProcessLog(MultiSourceSingleFileProcessLogConfig processLogConfig, IReplicationPacketDataBatchConsumer<?> dataConsumer, IReplicationProcessLogExceptionHandler exceptionHandler, IReplicationInFacade replicationInFacade, String name, String groupName, String sourceLookupName, boolean firstHandshakeForTarget, IReplicationGroupHistory groupHistory, IReplicationParticipantsMediator participantsMediator, IProcessMemoryManager processMemoryManager) {
        this(processLogConfig, dataConsumer, exceptionHandler, replicationInFacade, name, groupName, sourceLookupName, firstHandshakeForTarget, groupHistory, participantsMediator, new LinkedList<MultiSourceProcessLogPacket>(), new HashMap<String, MultiSourceProcessLogPacket>(), processMemoryManager);
    }

    public MultiSourceSingleFileReliableAsyncTargetProcessLog(MultiSourceSingleFileProcessLogConfig processLogConfig, IReplicationPacketDataBatchConsumer<?> dataConsumer, IReplicationProcessLogExceptionHandler exceptionHandler, IReplicationInFacade replicationInFacade, String myLookupName, String groupName, String sourceLookupName, boolean firstHandshakeForTarget, IReplicationGroupHistory groupHistory, IReplicationParticipantsMediator participantsMediator, long lastProcessedKey, long firstUnprocessedKey, LinkedList<MultiSourceProcessLogPacket> pendingPacketsQueue, HashMap<String, MultiSourceProcessLogPacket> packetsByUidHelperMap, IProcessMemoryManager processMemoryManager) {
        this(processLogConfig, dataConsumer, exceptionHandler, replicationInFacade, myLookupName, groupName, sourceLookupName, firstHandshakeForTarget, groupHistory, participantsMediator, pendingPacketsQueue, packetsByUidHelperMap, processMemoryManager);
        this._lastProcessedKey = lastProcessedKey;
        this._firstUnprocessedKey = firstUnprocessedKey;
    }

    private MultiSourceSingleFileReliableAsyncTargetProcessLog(MultiSourceSingleFileProcessLogConfig processLogConfig, IReplicationPacketDataBatchConsumer<?> dataConsumer, IReplicationProcessLogExceptionHandler exceptionHandler, IReplicationInFacade replicationInFacade, String name, String groupName, String sourceLookupName, boolean firstHandshakeForTarget, IReplicationGroupHistory groupHistory, IReplicationParticipantsMediator participantsMediator, LinkedList<MultiSourceProcessLogPacket> pendingPacketsQueue, HashMap<String, MultiSourceProcessLogPacket> packetsByUidHelperMap, IProcessMemoryManager processMemoryManager) {
        super(dataConsumer, exceptionHandler, replicationInFacade, name, groupName, sourceLookupName, groupHistory);
        this._processLogConfig = processLogConfig;
        this._firstHandshakeForTarget = firstHandshakeForTarget;
        this._participantsMediator = participantsMediator;
        this._pendingPacketsQueue = pendingPacketsQueue;
        this._batchDataConsumer = dataConsumer;
        this._packetsByUidHelperMap = packetsByUidHelperMap;
        this._batchConsumedPacketsKeys = new LinkedList();
        this._processMemoryManager = processMemoryManager;
    }

    @Override
    protected boolean contentRequiredWhileProcessing() {
        return false;
    }

    @Override
    public GlobalOrderProcessLogHandshakeResponse performHandshake(String memberName, IBacklogHandshakeRequest handshakeRequest) throws IncomingReplicationOutOfSyncException {
        Object object = this._lifeCycleLock;
        synchronized (object) {
            if (!this.isOpen()) {
                throw new ClosedResourceException("Process log is closed");
            }
            GlobalOrderBacklogHandshakeRequest typedHandshakeRequest = (GlobalOrderBacklogHandshakeRequest)handshakeRequest;
            if (this._firstHandshakeForTarget) {
                this._firstHandshakeForTarget = false;
                this._lastProcessedKey = typedHandshakeRequest.getLastConfirmedKey();
                this._firstUnprocessedKey = this._lastProcessedKey + 1L;
                return new GlobalOrderProcessLogHandshakeResponse(this._firstUnprocessedKey - 1L);
            }
            if (handshakeRequest.isFirstHandshake()) {
                this._lastProcessedKey = typedHandshakeRequest.getLastConfirmedKey();
                this._firstUnprocessedKey = this._lastProcessedKey + 1L;
                this._pendingPacketsQueue.clear();
                return new GlobalOrderProcessLogHandshakeResponse(this._firstUnprocessedKey - 1L);
            }
            if (typedHandshakeRequest.getLastConfirmedKey() <= this._firstUnprocessedKey - 1L) {
                return new GlobalOrderProcessLogHandshakeResponse(this._firstUnprocessedKey - 1L);
            }
            throw new IncomingReplicationOutOfSyncException("Replication out of sync, received last confirmed key " + typedHandshakeRequest.getLastConfirmedKey() + " while last processed key is " + this._lastProcessedKey + " and first unprocessed key is " + this._firstUnprocessedKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IProcessResult processBatch(String sourceLookupName, List<IReplicationOrderedPacket> packets, IReplicationInFilterCallback inFilterCallback) {
        if (!this.isOpen()) {
            this.throwClosedException();
        }
        this.validateMemoryStatus();
        this._lock.lock();
        try {
            if (this.isClosed()) {
                this.throwClosedException();
            }
            this.filterDuplicate(packets);
            if (packets.isEmpty() && this._pendingPacketsQueue.isEmpty()) {
                GlobalOrderProcessResult globalOrderProcessResult = GlobalOrderProcessResult.OK;
                return globalOrderProcessResult;
            }
            if (packets.isEmpty()) {
                IProcessResult iProcessResult = this.processIdleStateData(sourceLookupName, null, inFilterCallback);
                return iProcessResult;
            }
            long firstKeyInBatch = packets.get(0).getKey();
            if (this._lastProcessedKey + 1L < firstKeyInBatch && (this._pendingPacketsQueue.isEmpty() || this._pendingPacketsQueue.getLast().getKey() + 1L < firstKeyInBatch)) {
                GlobalOrderProcessResult globalOrderProcessResult = new GlobalOrderProcessResult(new ReplicationInternalSpaceException("Incompatible keys, last processed is " + this._lastProcessedKey + " and last key in process queue is " + (this._pendingPacketsQueue.isEmpty() ? "EMPTY" : Long.valueOf(this._pendingPacketsQueue.getLast().getKey())) + " while first packets received is " + firstKeyInBatch), this._lastProcessedKey);
                return globalOrderProcessResult;
            }
            GlobalOrderProcessResult globalOrderProcessResult = this.processPackets(sourceLookupName, packets, inFilterCallback);
            return globalOrderProcessResult;
        }
        finally {
            this._lock.unlock();
        }
    }

    private void validateMemoryStatus() {
        if (!this._processLogConfig.isMonitorPendingOperationsMemory()) {
            return;
        }
        if (this._pendingPacketsQueue.size() >= this._processLogConfig.getPendingPacketsQueueSizeThreshold() && this._processMemoryManager.getMemoryUsagePercentage(false) >= this._processLogConfig.getHighMemoryUsagePercentage()) {
            for (int i = 0; i < 5; ++i) {
                this._processMemoryManager.performGC();
            }
            if (this._processMemoryManager.getMemoryUsagePercentage(false) >= this._processLogConfig.getHighMemoryUsagePercentage()) {
                if (this._specificLogger.isLoggable(Level.WARNING)) {
                    this._specificLogger.warning("Memory shortage in multi source reliable async process log [groupName=" + this.getGroupName() + ", pendingPacketsQueueSize=" + this._pendingPacketsQueue.size() + ", memoryUsage=" + this._processMemoryManager.getMemoryUsage() + ", memoryUsagePercentage=" + this._processMemoryManager.getMemoryUsagePercentage(true) + ", maximumMemory=" + this._processMemoryManager.getMaximumMemory() + "]");
                }
                throw new MemoryShortageException(this.getGroupName(), "", SystemInfo.singleton().network().getHostId(), this._processMemoryManager.getMemoryUsage(), this._processMemoryManager.getMaximumMemory());
            }
        }
    }

    private void clearUidsDependencyHelperMap() {
        Iterator<Map.Entry<String, MultiSourceProcessLogPacket>> iterator = this._packetsByUidHelperMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, MultiSourceProcessLogPacket> entry = iterator.next();
            if (!entry.getValue().isConsumed()) continue;
            iterator.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GlobalOrderProcessResult processPackets(String sourceLookupName, List<IReplicationOrderedPacket> packets, IReplicationInFilterCallback inFilterCallback) throws Throwable {
        GlobalOrderProcessResult result;
        Object packet;
        MultiSourceSingleFileReplicationInBatchContext context = new MultiSourceSingleFileReplicationInBatchContext(this, this._specificLogger, packets.size(), this._participantsMediator, sourceLookupName, this.getGroupName());
        int lastDataPacketIndex = this.locateLastDataPacketIndex(packets);
        long lastKeyInBatch = lastDataPacketIndex != -1 ? packets.get(lastDataPacketIndex).getKey() : -1L;
        long firstKeyInBatch = packets.size() > 0 ? packets.get(0).getKey() : this._pendingPacketsQueue.getLast().getKey() + 1L;
        this.generatePacketsWithDependencies(packets);
        boolean packetsConsumed = true;
        while (packetsConsumed) {
            try {
                packetsConsumed = false;
                Iterator pendingPacketsIterator = this._pendingPacketsQueue.iterator();
                while (pendingPacketsIterator.hasNext()) {
                    packet = (MultiSourceProcessLogPacket)pendingPacketsIterator.next();
                    if (((MultiSourceProcessLogPacket)packet).isMultiParticipant() && !((MultiSourceProcessLogPacket)packet).isConsolidatedByThisParticipant() && ((MultiSourceProcessLogPacket)packet).isConsumedByOtherParticipant()) {
                        this._participantsMediator.remove(((MultiSourceProcessLogPacket)packet).getParticipantsMetadata());
                        this._lastProcessedKey = Math.max(this._lastProcessedKey, ((MultiSourceProcessLogPacket)packet).getKey());
                        ((MultiSourceProcessLogPacket)packet).setConsumed();
                        pendingPacketsIterator.remove();
                        continue;
                    }
                    if (((MultiSourceProcessLogPacket)packet).hasDependencies()) continue;
                    if (((MultiSourceProcessLogPacket)packet).isMultiParticipant()) {
                        if (!((MultiSourceProcessLogPacket)packet).isRegisteredInMediator()) {
                            this.registerPacketInMediator((MultiSourceProcessLogPacket)packet);
                        }
                        if (!((MultiSourceProcessLogPacket)packet).isConsolidatedByThisParticipant() && !this.pendingPacketConsolidationThresholdBreached((MultiSourceProcessLogPacket)packet, firstKeyInBatch, lastKeyInBatch)) continue;
                    }
                    this.consumePacket(inFilterCallback, context, (MultiSourceProcessLogPacket)packet);
                    packetsConsumed = true;
                }
                if (!packetsConsumed) continue;
                this.consumePendingPacketsInBatch(context);
            }
            finally {
                this.removeConsumedPacketsFromPendingPacketsQueue();
            }
        }
        int batchSize = packets.size();
        if (batchSize > 0 && lastDataPacketIndex < batchSize - 1) {
            packet = packets.get(batchSize - 1);
            this._lastProcessedKey = packet.getEndKey();
        }
        if (this._pendingPacketsQueue.isEmpty()) {
            this._firstUnprocessedKey = this._lastProcessedKey + 1L;
            result = GlobalOrderProcessResult.OK;
        } else {
            this._firstUnprocessedKey = this._pendingPacketsQueue.getFirst().getKey();
            result = new GlobalOrderProcessResult(null, this._firstUnprocessedKey - 1L);
        }
        this.clearUidsDependencyHelperMap();
        return result;
    }

    private void removeConsumedPacketsFromPendingPacketsQueue() {
        if (this._batchConsumedPacketsKeys.isEmpty()) {
            return;
        }
        Iterator pendingPacketsIterator = this._pendingPacketsQueue.iterator();
        for (Long consumedPacketKey : this._batchConsumedPacketsKeys) {
            if (!pendingPacketsIterator.hasNext()) {
                if (this._pendingPacketsQueue.size() < 100 && this._batchConsumedPacketsKeys.size() < 100) {
                    throw new IllegalStateException("Packets were consumed but are missing from pending packets queue [batchConsumedPacketsKeys=" + this._batchConsumedPacketsKeys + ", pendingPacketsQueue=" + this._pendingPacketsQueue + "].");
                }
                throw new IllegalStateException("Packets were consumed but are missing from pending packets queue [batchConsumedPacketsKeys size=" + this._batchConsumedPacketsKeys.size() + ", pendingPacketsQueue size=" + this._pendingPacketsQueue.size() + "].");
            }
            boolean packetFound = false;
            while (pendingPacketsIterator.hasNext()) {
                if (((MultiSourceProcessLogPacket)pendingPacketsIterator.next()).getKey() != consumedPacketKey.longValue()) continue;
                pendingPacketsIterator.remove();
                packetFound = true;
                break;
            }
            if (packetFound) continue;
            if (this._pendingPacketsQueue.size() < 100 && this._batchConsumedPacketsKeys.size() < 100) {
                throw new IllegalStateException("Consumed packet [key=" + consumedPacketKey + "] was not found in pendingPacketsQueue [batchConsumedPacketsKeys=" + this._batchConsumedPacketsKeys + ", pendingPacketsQueue=" + this._pendingPacketsQueue + "].");
            }
            throw new IllegalStateException("Consumed packet [key=" + consumedPacketKey + "] was not found in pendingPacketsQueue [batchConsumedPacketsKeys size=" + this._batchConsumedPacketsKeys.size() + ", pendingPacketsQueue size=" + this._pendingPacketsQueue.size() + "].");
        }
        this._batchConsumedPacketsKeys.clear();
    }

    private boolean pendingPacketConsolidationThresholdBreached(MultiSourceProcessLogPacket packet, long firstKeyInBatch, long lastKeyInBatch) {
        boolean consolidationBreached = false;
        if (firstKeyInBatch == -1L || packet.getKey() < firstKeyInBatch) {
            boolean abortSizeBased;
            long packetPendingTime = SystemTime.timeMillis() - packet.getCreationTime();
            boolean abortTimeBased = packetPendingTime >= this._processLogConfig.getConsumeTimeout();
            long packetRetainedBacklogSize = lastKeyInBatch - packet.getKey();
            boolean bl = abortSizeBased = lastKeyInBatch != -1L && this._processLogConfig.getPendingPacketPacketsIntervalBeforeConsumption() != -1L && packetRetainedBacklogSize >= this._processLogConfig.getPendingPacketPacketsIntervalBeforeConsumption();
            if ((abortTimeBased || abortSizeBased) && this._participantsMediator.abortConsolidation(packet.getParticipantsMetadata())) {
                this.logConsolidationAbortedWarningMessage(packet.getParticipantsMetadata(), abortTimeBased, abortTimeBased ? packetPendingTime : packetRetainedBacklogSize);
                consolidationBreached = true;
            }
        }
        return consolidationBreached;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void consumePacket(IReplicationInFilterCallback inFilterCallback, MultiSourceSingleFileReplicationInBatchContext context, MultiSourceProcessLogPacket packet) throws Throwable {
        if (this.preprocess(packet.getReplicationPacket())) {
            context.setContextPacket(packet.getReplicationPacket());
            try {
                IReplicationPacketData<?> data = packet.getData();
                context.setCurrentKey(packet.getKey());
                IDataConsumeResult prevResult = null;
                while (true) {
                    if (this.isClosed()) {
                        throw new ClosedResourceException("Process log is closed");
                    }
                    context.snapshot();
                    packet.setBeingConsumed();
                    context.addBeingConsumedPacket(packet);
                    IDataConsumeResult consumeResult = this.getDataConsumer().consume(context, data, this.getReplicationInFacade(), inFilterCallback);
                    if (!consumeResult.isFailed()) {
                        break;
                    }
                    context.rollback();
                    MultiSourceSingleFileReliableAsyncTargetProcessLog.throwIfRepetitiveError(prevResult, consumeResult);
                    if (this._specificLogger.isLoggable(Level.FINER)) {
                        this._specificLogger.log(Level.FINER, "Encountered error while consuming packet [" + packet.getReplicationPacket() + "], trying to resolve issue", consumeResult.toException());
                    }
                    IDataConsumeFix fix = this.getExceptionHandler().handleException(consumeResult, null);
                    data = this.getDataConsumer().applyFix(context, data, fix);
                    if (this._specificLogger.isLoggable(Level.FINER)) {
                        this._specificLogger.log(Level.FINER, "Fix applied - retrying the operation [" + fix + "]");
                    }
                    prevResult = consumeResult;
                }
            }
            finally {
                context.setContextPacket(null);
            }
        }
    }

    private void generatePacketsWithDependencies(List<IReplicationOrderedPacket> packets) {
        for (IReplicationOrderedPacket packet : packets) {
            if (!this.preprocess(packet)) continue;
            IReplicationPacketData<?> data = packet.getData();
            IReplicationParticipantsMetadata participantsMetadata = this.getDataConsumer().extractParticipantsMetadata(data);
            MultiSourceProcessLogPacket replicationPacket = participantsMetadata.getTransactionParticipantsCount() > 1 ? new MultiSourceProcessLogMultiParticipantPacket(packet, this._participantsMediator, participantsMetadata) : new MultiSourceProcessLogPacket(packet);
            if (packet.getData().isSingleEntryData()) {
                String uid = packet.getData().getSingleEntryData().getUid();
                this.checkAndAddDependencyIfNecessary(replicationPacket, uid);
            } else {
                for (IReplicationPacketEntryData entryData : packet.getData()) {
                    this.checkAndAddDependencyIfNecessary(replicationPacket, entryData.getUid());
                }
            }
            if (participantsMetadata.getTransactionParticipantsCount() > 1 && !replicationPacket.hasDependencies()) {
                this.registerPacketInMediator(replicationPacket);
            }
            this._pendingPacketsQueue.add(replicationPacket);
        }
    }

    private void checkAndAddDependencyIfNecessary(MultiSourceProcessLogPacket replicationPacket, String uid) {
        MultiSourceProcessLogPacket dependsOnPacket = this._packetsByUidHelperMap.put(uid, replicationPacket);
        if (dependsOnPacket != null && !dependsOnPacket.isConsumed() && dependsOnPacket.getKey() < replicationPacket.getKey()) {
            replicationPacket.addDependency(dependsOnPacket);
        }
    }

    private void registerPacketInMediator(MultiSourceProcessLogPacket packet) {
        IReplicationPacketData<?>[] allParticipantsData = this._participantsMediator.getAllParticipantsData(packet);
        packet.setRegisteredInMediator();
        if (allParticipantsData != null) {
            IReplicationPacketData<?> mergedData = this.getDataConsumer().merge(allParticipantsData, packet.getParticipantsMetadata());
            packet.setData(mergedData);
        }
    }

    private void consumePendingPacketsInBatch(MultiSourceSingleFileReplicationInBatchContext context) throws Exception {
        if (this.isClosed()) {
            throw new ClosedResourceException("Process log is closed");
        }
        IDataConsumeResult result = this._batchDataConsumer.consumePendingPackets(context, this.getReplicationInFacade());
        if (result.isFailed()) {
            throw result.toException();
        }
    }

    private void logConsolidationAbortedWarningMessage(IReplicationParticipantsMetadata participantsMetadata, boolean timeBased, long breachingThreshold) {
        if (this._specificLogger.isLoggable(Level.WARNING)) {
            if (timeBased) {
                this._specificLogger.log(Level.WARNING, "Timeout exceeded [" + breachingThreshold + "/" + this._processLogConfig.getConsumeTimeout() + "ms] while waiting for all participants [contextId=" + participantsMetadata.getContextId() + ", participantsCount=" + participantsMetadata.getTransactionParticipantsCount() + "] - current participant [participantId=" + participantsMetadata.getParticipantId() + "] will be processed independently");
            } else {
                this._specificLogger.log(Level.WARNING, "Pending operations threshold exceeded [" + breachingThreshold + "/" + this._processLogConfig.getPendingPacketPacketsIntervalBeforeConsumption() + "] while waiting for all participants [contextId=" + participantsMetadata.getContextId() + ", participantsCount=" + participantsMetadata.getTransactionParticipantsCount() + "] - current participant [participantId=" + participantsMetadata.getParticipantId() + "] will be processed independently");
            }
        }
    }

    private int locateLastDataPacketIndex(List<IReplicationOrderedPacket> packets) {
        int lastDataPacketIndex = -1;
        int index = -1;
        for (IReplicationOrderedPacket packet : packets) {
            ++index;
            if (!packet.isDataPacket()) continue;
            lastDataPacketIndex = index;
        }
        return lastDataPacketIndex;
    }

    private boolean preprocess(IReplicationOrderedPacket packet) {
        if (packet.isDataPacket()) {
            return true;
        }
        if (packet instanceof GlobalOrderDiscardedReplicationPacket) {
            return false;
        }
        if (packet instanceof GlobalOrderDeletedBacklogPacket) {
            this.logDeletion((GlobalOrderDeletedBacklogPacket)packet);
            return false;
        }
        return true;
    }

    protected void logDeletion(GlobalOrderDeletedBacklogPacket deletedBacklogPacket) {
        String deletionMessage = "packets [" + deletedBacklogPacket.getKey() + "-" + deletedBacklogPacket.getEndKey() + "] are lost due to backlog deletion at the source";
        this.getGroupHistory().logEvent(this.getSourceLookupName(), deletionMessage);
        if (this._specificLogger.isLoggable(Level.WARNING)) {
            this._specificLogger.warning(deletionMessage);
        }
    }

    protected void filterDuplicate(List<IReplicationOrderedPacket> packets) {
        Iterator<IReplicationOrderedPacket> iterator = packets.iterator();
        while (iterator.hasNext()) {
            IReplicationOrderedPacket packet = iterator.next();
            if (!this.filterDuplicate(packet)) continue;
            iterator.remove();
        }
    }

    protected boolean filterDuplicate(IReplicationOrderedPacket packet) {
        return this._pendingPacketsQueue.isEmpty() ? packet.getEndKey() <= this._lastProcessedKey : packet.getEndKey() <= Math.max(this._lastProcessedKey, this._pendingPacketsQueue.getLast().getReplicationPacket().getEndKey());
    }

    protected void throwClosedException() {
        throw new ClosedResourceException("Process log is closed");
    }

    @Override
    public IProcessResult process(String sourceLookupName, IReplicationOrderedPacket packet, IReplicationInFilterCallback inFilterCallback) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean close(long time, TimeUnit unit) throws InterruptedException {
        Object object = this._lifeCycleLock;
        synchronized (object) {
            this._state = ProcessLogState.CLOSING;
        }
        if (!this._lock.tryLock(time, unit)) {
            object = this._lifeCycleLock;
            synchronized (object) {
                this._state = ProcessLogState.CLOSED;
            }
            return false;
        }
        try {
            this._state = ProcessLogState.CLOSED;
            boolean bl = true;
            return bl;
        }
        finally {
            this.getExceptionHandler().close();
            this._lock.unlock();
        }
    }

    @Override
    public void processHandshakeIteration(String sourceMemberName, IHandshakeIteration handshakeIteration) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IProcessLogHandshakeResponse resync(IBacklogHandshakeRequest handshakeRequest) {
        this._lock.lock();
        try {
            if (!this.isOpen()) {
                throw new ClosedResourceException("Process log is closed");
            }
            GlobalOrderBacklogHandshakeRequest typedHandshakeRequest = (GlobalOrderBacklogHandshakeRequest)handshakeRequest;
            this._firstHandshakeForTarget = false;
            this._firstUnprocessedKey = typedHandshakeRequest.getLastConfirmedKey() + 1L;
            this._lastProcessedKey = this._firstUnprocessedKey - 1L;
            this._pendingPacketsQueue.clear();
            GlobalOrderProcessLogHandshakeResponse globalOrderProcessLogHandshakeResponse = new GlobalOrderProcessLogHandshakeResponse(this._firstUnprocessedKey - 1L);
            return globalOrderProcessLogHandshakeResponse;
        }
        finally {
            this._lock.unlock();
        }
    }

    @Override
    public Object toWireForm(IProcessResult processResult) {
        if (processResult == GlobalOrderProcessResult.OK) {
            return null;
        }
        return processResult;
    }

    protected boolean isOpen() {
        return this._state == ProcessLogState.OPEN;
    }

    protected boolean isClosed() {
        return this._state == ProcessLogState.CLOSED;
    }

    @Override
    public void packetConsumed(long key) {
        if (key == this._firstUnprocessedKey) {
            this._firstUnprocessedKey = key + 1L;
        }
        if (key > this._lastProcessedKey) {
            this._lastProcessedKey = key;
        }
        this._batchConsumedPacketsKeys.add(key);
    }

    @Override
    public String dumpState() {
        return "State [" + (Object)((Object)this._state) + "] had any handshake [" + !this._firstHandshakeForTarget + "] last process key [" + this._lastProcessedKey + "] first unprocessed key [" + this._firstUnprocessedKey + "] " + this.dumpStateExtra();
    }

    private String dumpStateExtra() {
        this._lock.lock();
        try {
            StringBuilder dumpState = new StringBuilder("pending packets queue [");
            if (this._pendingPacketsQueue == null || this._pendingPacketsQueue.isEmpty()) {
                dumpState.append("EMPTY");
            } else {
                dumpState.append("size=").append(this._pendingPacketsQueue.size());
                dumpState.append("firstPacket=").append(this._pendingPacketsQueue.getFirst().toString());
                dumpState.append(", lastPacket=").append(this._pendingPacketsQueue.getLast().toString());
                dumpState.append("\n]");
            }
            String string = dumpState.toString();
            return string;
        }
        finally {
            this._lock.unlock();
        }
    }

    public MultiSourceSingleFileProcessLogConfig getProcessLogConfig() {
        return this._processLogConfig;
    }

    protected boolean isFirstHandshakeForTarget() {
        this._lock.lock();
        try {
            boolean bl = this._firstHandshakeForTarget;
            return bl;
        }
        finally {
            this._lock.unlock();
        }
    }

    public long getLastProcessedKey() {
        this._lock.lock();
        try {
            long l = this._lastProcessedKey;
            return l;
        }
        finally {
            this._lock.unlock();
        }
    }

    public long getFirstUnprocessedKey() {
        this._lock.lock();
        try {
            long l = this._firstUnprocessedKey;
            return l;
        }
        finally {
            this._lock.unlock();
        }
    }

    public LinkedList<MultiSourceProcessLogPacket> getPendingPacketsQueue() {
        this._lock.lock();
        try {
            LinkedList<MultiSourceProcessLogPacket> linkedList = this._pendingPacketsQueue;
            return linkedList;
        }
        finally {
            this._lock.unlock();
        }
    }

    public HashMap<String, MultiSourceProcessLogPacket> getPacketsByUidHelperMap() {
        this._lock.lock();
        try {
            HashMap<String, MultiSourceProcessLogPacket> hashMap = this._packetsByUidHelperMap;
            return hashMap;
        }
        finally {
            this._lock.unlock();
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public IProcessResult processIdleStateData(String sourceLookupName, IIdleStateData idleStateData, IReplicationInFilterCallback inFilterCallback) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void clearStateAfterException() {
        if (this._pendingPacketsQueue != null && !this._pendingPacketsQueue.isEmpty()) {
            for (MultiSourceProcessLogPacket packet : this._pendingPacketsQueue) {
                if (!packet.isBeingConsumed()) continue;
                packet.setUnconsumed();
            }
        }
        this.clearUidsDependencyHelperMap();
        this._batchConsumedPacketsKeys.clear();
    }
}

