/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.processlog.multisourcesinglefile;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.cluster.node.impl.AbstractReplicationInBatchContext;
import com.gigaspaces.internal.cluster.node.impl.processlog.multisourcesinglefile.IPacketConsumedCallback;
import com.gigaspaces.internal.cluster.node.impl.processlog.multisourcesinglefile.IReplicationParticipantsMediator;
import com.gigaspaces.internal.cluster.node.impl.processlog.multisourcesinglefile.MultiSourceProcessLogPacket;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;

@InternalApi
public class MultiSourceSingleFileReplicationInBatchContext
extends AbstractReplicationInBatchContext {
    private final IReplicationParticipantsMediator _participantsMediator;
    private final IPacketConsumedCallback _packetConsumedCallback;
    private List<MultiSourceProcessLogPacket> _beingConsumedPackets;

    public MultiSourceSingleFileReplicationInBatchContext(IPacketConsumedCallback packetConsumedCallback, Logger contextLogger, int entireBatchSize, IReplicationParticipantsMediator participantsMediator, String sourceLookupName, String groupName) {
        super(contextLogger, entireBatchSize, sourceLookupName, groupName, true);
        this._packetConsumedCallback = packetConsumedCallback;
        this._participantsMediator = participantsMediator;
        this._beingConsumedPackets = new LinkedList<MultiSourceProcessLogPacket>();
    }

    public void addBeingConsumedPacket(MultiSourceProcessLogPacket packet) {
        if (this._beingConsumedPackets == null) {
            this._beingConsumedPackets = new LinkedList<MultiSourceProcessLogPacket>();
        }
        this._beingConsumedPackets.add(packet);
    }

    private MultiSourceProcessLogPacket removeLastConsumedPacket() {
        if (!this._beingConsumedPackets.isEmpty()) {
            return this._beingConsumedPackets.remove(this._beingConsumedPackets.size() - 1);
        }
        return null;
    }

    @Override
    protected void afterBatchConsumed(long lastProcessedKeyInBatch) {
        if (this._beingConsumedPackets != null && !this._beingConsumedPackets.isEmpty()) {
            Iterator<MultiSourceProcessLogPacket> iterator = this._beingConsumedPackets.iterator();
            while (iterator.hasNext()) {
                MultiSourceProcessLogPacket consumedPacket = iterator.next();
                if (consumedPacket.getKey() > lastProcessedKeyInBatch) continue;
                if (consumedPacket.isMultiParticipant()) {
                    if (consumedPacket.isConsolidatedByThisParticipant()) {
                        this._participantsMediator.setConsumed(consumedPacket.getParticipantsMetadata());
                    } else {
                        this._participantsMediator.remove(consumedPacket.getParticipantsMetadata());
                    }
                }
                consumedPacket.setConsumed();
                this._packetConsumedCallback.packetConsumed(consumedPacket.getKey());
                iterator.remove();
            }
        }
    }

    @Override
    public void rollback() {
        MultiSourceProcessLogPacket packet = this.removeLastConsumedPacket();
        if (packet != null) {
            packet.setUnconsumed();
        }
        super.rollback();
    }

    @Override
    public boolean isBatchContext() {
        return true;
    }

    public List<MultiSourceProcessLogPacket> getBeingConsumedPackets() {
        return this._beingConsumedPackets;
    }
}

