/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.processlog.multisourcesinglefile;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.cluster.node.impl.packets.data.IReplicationPacketData;
import com.gigaspaces.internal.cluster.node.impl.packets.data.IReplicationParticipantsMetadata;
import com.gigaspaces.internal.cluster.node.impl.processlog.multisourcesinglefile.IReplicationParticipantsMediator;
import com.gigaspaces.internal.cluster.node.impl.processlog.multisourcesinglefile.MultiSourceProcessLogPacket;
import com.gigaspaces.internal.collections.CollectionsFactory;
import com.gigaspaces.internal.collections.IntegerObjectMap;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;

@InternalApi
public class ReplicationParticipantsMediator
implements IReplicationParticipantsMediator {
    private final Map<Object, ReplicationParticipantsData> _contextData = new HashMap<Object, ReplicationParticipantsData>();
    private final ReentrantLock _lock = new ReentrantLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IReplicationPacketData<?>[] getAllParticipantsData(MultiSourceProcessLogPacket packet) {
        IReplicationParticipantsMetadata participantsMetadata = packet.getParticipantsMetadata();
        if (participantsMetadata.getTransactionParticipantsCount() == 1) {
            return new IReplicationPacketData[]{packet.getData()};
        }
        this._lock.lock();
        try {
            if (this._contextData.containsKey(participantsMetadata.getContextId())) {
                ReplicationParticipantsData participantsData = this._contextData.get(participantsMetadata.getContextId());
                participantsData.addParticipantData(packet.getReplicationPacket().getData(), participantsMetadata);
                if (participantsData.shouldBeConsolidatedByThisParticipant(participantsMetadata)) {
                    participantsData.setConsolidationState(ConsolidationState.CONSOLIDATED);
                    IReplicationPacketData<?>[] iReplicationPacketDataArray = participantsData.getParticipantsData();
                    return iReplicationPacketDataArray;
                }
            } else {
                this._contextData.put(participantsMetadata.getContextId(), new ReplicationParticipantsData(packet.getReplicationPacket().getData(), participantsMetadata));
            }
        }
        finally {
            this._lock.unlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isConsumed(Object contextId) {
        this._lock.lock();
        try {
            ReplicationParticipantsData data = this.getReplicationParticipantsData(contextId);
            boolean bl = data != null ? data.isConsumed() : false;
            return bl;
        }
        finally {
            this._lock.unlock();
        }
    }

    @Override
    public void setConsumed(IReplicationParticipantsMetadata participantsMetadata) {
        this._lock.lock();
        try {
            ReplicationParticipantsData data = this.getReplicationParticipantsData(participantsMetadata.getContextId());
            if (data == null) {
                throw new IllegalStateException("Attempted to get participants data for an unknown context id: " + participantsMetadata.getContextId());
            }
            data.setConsumed();
            data.remove(participantsMetadata);
        }
        finally {
            this._lock.unlock();
        }
    }

    @Override
    public void remove(IReplicationParticipantsMetadata participantsMetadata) {
        this._lock.lock();
        try {
            ReplicationParticipantsData data = this.getReplicationParticipantsData(participantsMetadata.getContextId());
            if (data != null && data.remove(participantsMetadata)) {
                this._contextData.remove(participantsMetadata.getContextId());
            }
        }
        finally {
            this._lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean abortConsolidation(IReplicationParticipantsMetadata participantsMetadata) {
        this._lock.lock();
        try {
            ReplicationParticipantsData data = this.getReplicationParticipantsData(participantsMetadata.getContextId());
            if (data == null) {
                throw new IllegalStateException("Attempted to get participants data for an unknown context id: " + participantsMetadata.getContextId());
            }
            if (data.getConsolidationState() == ConsolidationState.WAITING_FOR_PARTICIPANTS || data.getConsolidationState() == ConsolidationState.ABORTED) {
                data.setConsolidationState(ConsolidationState.ABORTED);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this._lock.unlock();
        }
    }

    private ReplicationParticipantsData getReplicationParticipantsData(Object contextId) {
        return this._contextData.get(contextId);
    }

    private class ReplicationParticipantsData {
        private final IntegerObjectMap<IReplicationPacketData<?>> _participantsData = CollectionsFactory.getInstance().createIntegerObjectMap();
        private ConsolidationState _consolidationState = ConsolidationState.WAITING_FOR_PARTICIPANTS;
        private int _consolidatorParticipantId = -1;

        public ReplicationParticipantsData(IReplicationPacketData<?> data, IReplicationParticipantsMetadata participantsMetadata) {
            this.addParticipantData(data, participantsMetadata);
        }

        public void setConsolidationState(ConsolidationState consolidationState) {
            this._consolidationState = consolidationState;
        }

        public ConsolidationState getConsolidationState() {
            return this._consolidationState;
        }

        public boolean shouldBeConsolidatedByThisParticipant(IReplicationParticipantsMetadata participantsMetadata) {
            if (this._consolidationState == ConsolidationState.ABORTED || this._participantsData.size() != participantsMetadata.getTransactionParticipantsCount()) {
                return false;
            }
            if (this._consolidatorParticipantId == -1) {
                this._consolidatorParticipantId = participantsMetadata.getParticipantId();
                return true;
            }
            return this._consolidatorParticipantId == participantsMetadata.getParticipantId();
        }

        public boolean remove(IReplicationParticipantsMetadata participantsMetadata) {
            this._participantsData.remove(participantsMetadata.getParticipantId());
            return this._participantsData.isEmpty();
        }

        public boolean isConsumed() {
            return this._consolidationState == ConsolidationState.CONSUMED;
        }

        public void setConsumed() {
            this._consolidationState = ConsolidationState.CONSUMED;
        }

        public void addParticipantData(IReplicationPacketData<?> data, IReplicationParticipantsMetadata participantsMetadata) {
            this._participantsData.put(participantsMetadata.getParticipantId(), data);
        }

        public IReplicationPacketData<?>[] getParticipantsData() {
            return this._participantsData.getValues(new IReplicationPacketData[this._participantsData.size()]);
        }
    }

    private static enum ConsolidationState {
        WAITING_FOR_PARTICIPANTS,
        ABORTED,
        CONSOLIDATED,
        CONSUMED;

    }
}

