/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.replica;

import com.gigaspaces.internal.cluster.node.impl.replica.CurrentStageInfo;
import com.gigaspaces.internal.cluster.node.impl.replica.IExecutableSpaceReplicaData;
import com.gigaspaces.internal.cluster.node.impl.replica.ISingleStageReplicaDataProducer;
import com.gigaspaces.internal.cluster.node.impl.replica.ISpaceReplicaDataProducer;
import com.gigaspaces.internal.cluster.node.impl.replica.ISynchronizationCallback;
import com.gigaspaces.internal.cluster.node.replica.SpaceCopyReplicaParameters;
import com.gigaspaces.internal.server.space.SpaceEngine;
import com.gigaspaces.internal.utils.StringUtils;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;

public abstract class AbstractMultiSpaceReplicaDataProducer
implements ISpaceReplicaDataProducer<IExecutableSpaceReplicaData> {
    protected static final Logger _logger = Logger.getLogger("com.gigaspaces.replication.replica");
    private final List<ISingleStageReplicaDataProducer<? extends IExecutableSpaceReplicaData>> _dataProducers;
    protected final Object _requestContext;
    protected final SpaceEngine _engine;
    private volatile boolean _closed;
    private volatile int _currentProducer;
    private AtomicBoolean _closing;

    public AbstractMultiSpaceReplicaDataProducer(SpaceEngine engine, SpaceCopyReplicaParameters parameters, Object requestContext) {
        this._engine = engine;
        this._requestContext = requestContext;
        this._dataProducers = this.buildDataProducers(parameters);
        this._closing = new AtomicBoolean(false);
    }

    protected abstract List<ISingleStageReplicaDataProducer<? extends IExecutableSpaceReplicaData>> buildDataProducers(SpaceCopyReplicaParameters var1);

    @Override
    public IExecutableSpaceReplicaData produceNextData(ISynchronizationCallback synchCallback) {
        if (this._closed) {
            return null;
        }
        if (this._currentProducer >= this._dataProducers.size()) {
            return null;
        }
        IExecutableSpaceReplicaData replicaData = this._dataProducers.get(this._currentProducer).produceNextData(synchCallback);
        return replicaData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ISingleStageReplicaDataProducer.CloseStatus close(boolean forced) {
        if (!this._closing.compareAndSet(false, true) && this._engine.getLeaseManager().isCurrentLeaseReaperThread()) {
            return ISingleStageReplicaDataProducer.CloseStatus.CLOSING;
        }
        AbstractMultiSpaceReplicaDataProducer abstractMultiSpaceReplicaDataProducer = this;
        synchronized (abstractMultiSpaceReplicaDataProducer) {
            if (this._closed) {
                return ISingleStageReplicaDataProducer.CloseStatus.CLOSED;
            }
            this._closed = true;
            for (ISingleStageReplicaDataProducer<? extends IExecutableSpaceReplicaData> dataProducer : this._dataProducers) {
                dataProducer.close(forced);
            }
            this.onClose();
        }
        this._closing.set(false);
        return ISingleStageReplicaDataProducer.CloseStatus.CLOSED;
    }

    protected void onClose() {
    }

    @Override
    public CurrentStageInfo nextReplicaStage() {
        boolean isLast = this._currentProducer == this._dataProducers.size() - 1;
        String currentProducerName = this._dataProducers.get(this._currentProducer).getName();
        if (!isLast) {
            ++this._currentProducer;
        }
        String nextProducerName = isLast ? null : this._dataProducers.get(this._currentProducer).getName();
        return new CurrentStageInfo(currentProducerName, nextProducerName, isLast);
    }

    protected String getLogPrefix() {
        return this._engine.getReplicationNode() + "context [" + this._requestContext + "] ";
    }

    @Override
    public String dumpState() {
        StringBuilder dump = new StringBuilder("Stages: ");
        dump.append(StringUtils.NEW_LINE);
        for (ISingleStageReplicaDataProducer<? extends IExecutableSpaceReplicaData> stage : this._dataProducers) {
            dump.append(stage.dumpState());
            dump.append(StringUtils.NEW_LINE);
        }
        return dump.toString();
    }
}

