/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.replica;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.cluster.node.impl.replica.NotifyTemplateReplicaProducer;
import com.gigaspaces.internal.server.space.SpaceEngine;
import com.gigaspaces.internal.server.storage.NotifyTemplateHolder;
import java.util.logging.Level;

@InternalApi
public class BroadcastNotifyTemplateReplicaProducer
extends NotifyTemplateReplicaProducer {
    public BroadcastNotifyTemplateReplicaProducer(SpaceEngine engine, Object requestContext) {
        super(engine, requestContext);
    }

    @Override
    protected boolean isRelevant(NotifyTemplateHolder notifyTemplate) {
        if (!notifyTemplate.isBroadcast()) {
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest(this.getLogPrefix() + "filtered notify template " + notifyTemplate.getClassName() + " Uid=" + notifyTemplate.getUID() + " since it is not a broadcast template");
            }
            return false;
        }
        if (notifyTemplate.getXidOriginatedTransaction() != null) {
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest(this.getLogPrefix() + "filtered notify template " + notifyTemplate.getClassName() + " Uid=" + notifyTemplate.getUID() + " since it is under transaction");
            }
            return false;
        }
        return true;
    }

    @Override
    protected String getDumpName() {
        return "Broadcast notify template replica";
    }

    @Override
    public String getName() {
        return "BroadcastNotifyTemplateReplicaProducer";
    }
}

