/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.replica;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.cluster.node.impl.ReplicationNode;
import com.gigaspaces.internal.cluster.node.impl.backlog.IReplicationGroupBacklog;
import com.gigaspaces.internal.cluster.node.impl.replica.EntryReplicaProducer;
import com.gigaspaces.internal.cluster.node.impl.replica.ISynchronizationCallback;
import com.gigaspaces.internal.cluster.node.impl.replica.data.AbstractEntryReplicaData;
import com.gigaspaces.internal.cluster.node.impl.replica.data.DirectPersistencyEntryReplicaData;
import com.gigaspaces.internal.cluster.node.replica.SpaceCopyReplicaParameters;
import com.gigaspaces.internal.server.space.SpaceEngine;
import com.gigaspaces.internal.server.storage.IEntryHolder;
import com.gigaspaces.internal.transport.ITemplatePacket;
import com.j_spaces.core.exception.internal.ReplicationInternalSpaceException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

@InternalApi
public class DirectPersisntecyEntryReplicaProducer
extends EntryReplicaProducer {
    protected static final Logger _logger = Logger.getLogger("com.gigaspaces.replication.replica");
    private Set<String> _unitedSyncList = new HashSet<String>();
    private Iterator<String> _iterator;

    public DirectPersisntecyEntryReplicaProducer(SpaceEngine engine, SpaceCopyReplicaParameters parameters, ITemplatePacket templatePacket, Object requestContext) {
        super(engine, parameters, templatePacket, requestContext);
        this.mergeSyncLists(parameters.getSyncList());
        this._iterator = this._unitedSyncList.iterator();
    }

    private void mergeSyncLists(List<String> remoteSyncList) {
        if (remoteSyncList != null) {
            this._unitedSyncList.addAll(remoteSyncList);
            if (_logger.isLoggable(Level.INFO)) {
                _logger.info("[" + this.getEngine().getFullSpaceName() + "] received sync list with size " + remoteSyncList.size() + " from backup remote space");
            }
        }
        Iterator<String> entriesForRecovery = this.getEngine().getReplicationManager().getReplicationNode().getDirectPesistencySyncHandler().getEntriesForRecovery();
        int localSyncListSize = 0;
        while (entriesForRecovery.hasNext()) {
            ++localSyncListSize;
            this._unitedSyncList.add(entriesForRecovery.next());
        }
        if (_logger.isLoggable(Level.INFO)) {
            _logger.info("[" + this.getEngine().getFullSpaceName() + "] local sync list size is " + localSyncListSize);
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("[" + this.getEngine().getFullSpaceName() + "] united sync list size is " + this._unitedSyncList.size());
        }
        if (_logger.isLoggable(Level.FINER)) {
            for (String entry : this._unitedSyncList) {
                _logger.fine("[" + this.getEngine().getFullSpaceName() + "] merging sync list, uid=" + entry);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized AbstractEntryReplicaData produceNextData(ISynchronizationCallback syncCallback) {
        if (this.isForcedClose()) {
            throw new RuntimeException("space=" + this._engine.getFullSpaceName() + " replica forced closing");
        }
        if (this.isClosed()) {
            return null;
        }
        try {
            AbstractEntryReplicaData replicaData;
            block6: do {
                if (this.isForcedClose()) {
                    this.notifyAll();
                    throw new RuntimeException("space=" + this._engine.getFullSpaceName() + " replica forced closing");
                }
                if (!this._iterator.hasNext()) {
                    this.close(false);
                    return null;
                }
                String uid = this._iterator.next();
                replicaData = null;
                do {
                    IEntryHolder entry;
                    IEntryHolder base = entry = this.getEngine().getCacheManager().getEntryByUidFromPureCache(uid);
                    if (entry != null && (replicaData = this.produceDataFromEntry(syncCallback, entry)) != null) continue block6;
                    ReplicationNode replicationNode = (ReplicationNode)this._engine.getReplicationNode();
                    IReplicationGroupBacklog groupBacklog = replicationNode.getGroupBacklogByRequestContext(this.getRequestContext());
                    groupBacklog.writeLock();
                    try {
                        entry = this.getEngine().getCacheManager().getEntryByUidFromPureCache(uid);
                        if (entry != null && entry != base) continue;
                        replicaData = new DirectPersistencyEntryReplicaData(uid);
                        boolean duplicateUid = syncCallback.synchronizationDataGenerated(replicaData);
                        if (duplicateUid) {
                            replicaData = null;
                            continue block6;
                        }
                        this.increaseGeneratedDataCount();
                        continue block6;
                    }
                    finally {
                        groupBacklog.freeWriteLock();
                    }
                } while (!this.isClosed());
                return null;
            } while (replicaData == null);
            return replicaData;
        }
        catch (Exception ex) {
            throw new ReplicationInternalSpaceException("Failure in .", ex);
        }
    }

    @Override
    public String getName() {
        return "DirectPersistencyEntryReplicaProducer";
    }
}

