/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.replica;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.cluster.node.impl.backlog.sync.IMarker;
import com.gigaspaces.internal.cluster.node.impl.replica.ISingleStageReplicaDataProducer;
import com.gigaspaces.internal.cluster.node.impl.replica.ISynchronizationCallback;
import com.gigaspaces.internal.cluster.node.impl.replica.data.AbstractEntryReplicaData;
import com.gigaspaces.internal.cluster.node.impl.replica.data.DirectPersistencyEntryReplicaData;
import com.gigaspaces.internal.cluster.node.impl.replica.data.EntryCopyReplicaData;
import com.gigaspaces.internal.cluster.node.impl.replica.data.EntrySynchronizeReplicaData;
import com.gigaspaces.internal.cluster.node.replica.SpaceCopyReplicaParameters;
import com.gigaspaces.internal.metadata.ITypeDesc;
import com.gigaspaces.internal.server.metadata.IServerTypeDesc;
import com.gigaspaces.internal.server.space.MatchResult;
import com.gigaspaces.internal.server.space.SpaceEngine;
import com.gigaspaces.internal.server.storage.IEntryHolder;
import com.gigaspaces.internal.server.storage.ITemplateHolder;
import com.gigaspaces.internal.server.storage.TemplateHolderFactory;
import com.gigaspaces.internal.transport.EntryPacketFactory;
import com.gigaspaces.internal.transport.IEntryPacket;
import com.gigaspaces.internal.transport.ITemplatePacket;
import com.gigaspaces.internal.transport.TemplatePacket;
import com.gigaspaces.time.SystemTime;
import com.j_spaces.core.TransactionConflictException;
import com.j_spaces.core.XtnEntry;
import com.j_spaces.core.XtnStatus;
import com.j_spaces.core.cache.context.Context;
import com.j_spaces.core.cluster.IReplicationFilterEntry;
import com.j_spaces.core.cluster.ReplicationPolicy;
import com.j_spaces.core.exception.internal.ReplicationInternalSpaceException;
import com.j_spaces.core.sadapter.ISAdapterIterator;
import com.j_spaces.core.sadapter.SAException;
import com.j_spaces.kernel.locks.ILockObject;
import java.util.logging.Logger;
import net.jini.space.InternalSpaceException;

@InternalApi
public class EntryReplicaProducer
implements ISingleStageReplicaDataProducer<AbstractEntryReplicaData> {
    protected static final Logger _logger = Logger.getLogger("com.gigaspaces.replication.replica");
    protected final SpaceEngine _engine;
    private final boolean _isFullReplication;
    private final Context _context;
    private final ISAdapterIterator<IEntryHolder> _entriesIterSA;
    private final ITemplateHolder _templateHolder;
    private final SpaceCopyReplicaParameters _parameters;
    private final Object _requestContext;
    private int _generatedDataCount;
    private boolean _isClosed;
    private boolean _forcedClose;

    public EntryReplicaProducer(SpaceEngine engine, SpaceCopyReplicaParameters parameters, ITemplatePacket templatePacket, Object requestContext) {
        this._engine = engine;
        this._parameters = parameters;
        this._requestContext = requestContext;
        ReplicationPolicy replicationPolicy = this._engine.getClusterPolicy() == null ? null : this._engine.getClusterPolicy().getReplicationPolicy();
        this._isFullReplication = replicationPolicy == null || replicationPolicy.isFullReplication();
        this._context = this._engine.getCacheManager().getCacheContext();
        this._context.setInMemoryRecovery(true);
        if (templatePacket == null) {
            templatePacket = new TemplatePacket();
            templatePacket.setFieldsValues(new Object[0]);
        }
        try {
            IServerTypeDesc typeDesc = this._engine.getTypeManager().loadServerTypeDesc(templatePacket);
            this._templateHolder = TemplateHolderFactory.createTemplateHolder(typeDesc, templatePacket, this._engine.generateUid(), Long.MAX_VALUE);
            this._entriesIterSA = this._engine.getCacheManager().makeEntriesIter(this._context, this._templateHolder, typeDesc, 0L, SystemTime.timeMillis(), parameters.isMemoryOnly(), parameters.isTransient());
        }
        catch (Exception ex) {
            throw new ReplicationInternalSpaceException("", ex);
        }
    }

    public Object getRequestContext() {
        return this._requestContext;
    }

    @Override
    public synchronized AbstractEntryReplicaData produceNextData(ISynchronizationCallback syncCallback) {
        if (this.isForcedClose()) {
            throw new RuntimeException("space=" + this._engine.getFullSpaceName() + " replica forced closing");
        }
        if (this._isClosed) {
            return null;
        }
        try {
            IEntryHolder entry;
            AbstractEntryReplicaData replicaData;
            do {
                if (!this.isForcedClose()) continue;
                this.notifyAll();
                throw new RuntimeException("space=" + this._engine.getFullSpaceName() + " replica forced closing");
            } while ((replicaData = this.produceDataFromEntry(syncCallback, entry = this._entriesIterSA.next())) == null && !this._isClosed);
            if (replicaData == null && this._isClosed) {
                return null;
            }
            return replicaData;
        }
        catch (Exception ex) {
            throw new ReplicationInternalSpaceException("Failure in .", ex);
        }
    }

    protected AbstractEntryReplicaData produceDataFromEntry(ISynchronizationCallback syncCallback, IEntryHolder entry) {
        if (entry == null) {
            this.close(false);
            return null;
        }
        ITypeDesc typeDesc = this._engine.getTypeManager().getTypeDesc(entry.getClassName());
        if (!this.isRelevant(entry, typeDesc)) {
            return null;
        }
        AbstractEntryReplicaData replicaData = this.buildEntryReplicaData(entry, syncCallback);
        if (replicaData == null) {
            return null;
        }
        this.increaseGeneratedDataCount();
        return replicaData;
    }

    private boolean isRelevant(IEntryHolder entry, ITypeDesc typeDesc) {
        return this._isFullReplication || typeDesc.isReplicable();
    }

    @Override
    public synchronized ISingleStageReplicaDataProducer.CloseStatus close(boolean forced) {
        if (this._isClosed) {
            return ISingleStageReplicaDataProducer.CloseStatus.CLOSED;
        }
        this._isClosed = true;
        this._forcedClose = forced;
        try {
            if (forced) {
                this.wait(500L);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this._entriesIterSA != null) {
                this._entriesIterSA.close();
            }
        }
        catch (SAException e) {
            throw new ReplicationInternalSpaceException("Failed to close entries iterator.", e);
        }
        finally {
            this._engine.getCacheManager().freeCacheContext(this._context);
        }
        return ISingleStageReplicaDataProducer.CloseStatus.CLOSED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private AbstractEntryReplicaData buildEntryReplicaData(IEntryHolder entry, ISynchronizationCallback syncCallback) {
        while (entry != null) {
            AbstractEntryReplicaData abstractEntryReplicaData;
            XtnEntry wlXtn = entry.getWriteLockOwner();
            boolean locked = this.acquireTransactionLock(entry, wlXtn);
            ILockObject entryLock = this._engine.getCacheManager().getLockManager().getLockObject(entry);
            ILockObject iLockObject = entryLock;
            synchronized (iLockObject) {
                IEntryPacket entryPacket = this.getEntryPacketSafely(entry, wlXtn, locked);
                if (entryPacket == null) {
                    AbstractEntryReplicaData abstractEntryReplicaData2 = null;
                    // MONITOREXIT @DISABLED, blocks:[0, 6, 10, 12] lbl13 : MonitorExitStatement: MONITOREXIT : var6_7
                    this._engine.getCacheManager().getLockManager().freeLockObject(entryLock);
                    this.releaseTransactionLock(wlXtn, locked);
                    return abstractEntryReplicaData2;
                }
                AbstractEntryReplicaData data = this.newEntryReplicaData(entryPacket);
                boolean duplicateUid = syncCallback.synchronizationDataGenerated(data);
                if (duplicateUid) {
                    AbstractEntryReplicaData abstractEntryReplicaData3 = null;
                    // MONITOREXIT @DISABLED, blocks:[0, 6, 10, 11] lbl21 : MonitorExitStatement: MONITOREXIT : var6_7
                    this._engine.getCacheManager().getLockManager().freeLockObject(entryLock);
                    this.releaseTransactionLock(wlXtn, locked);
                    return abstractEntryReplicaData3;
                }
                abstractEntryReplicaData = data;
            }
            this._engine.getCacheManager().getLockManager().freeLockObject(entryLock);
            this.releaseTransactionLock(wlXtn, locked);
            return abstractEntryReplicaData;
            {
                catch (TransactionConflictException e) {
                    entry = this.handleTransactionConflict(entry);
                    continue;
                }
            }
            finally {
                this._engine.getCacheManager().getLockManager().freeLockObject(entryLock);
                this.releaseTransactionLock(wlXtn, locked);
                continue;
            }
            break;
        }
        return null;
    }

    private AbstractEntryReplicaData newEntryReplicaData(IEntryPacket entryPacket) {
        switch (this._parameters.getReplicaType()) {
            case SYNCRONIZE: {
                IMarker marker = null;
                if (this._parameters.isIncludeEvictionReplicationMarkers() && this._engine.getCacheManager().requiresEvictionReplicationProtection()) {
                    marker = this._engine.getCacheManager().getEvictionReplicationsMarkersRepository().getMarker(entryPacket.getUID());
                }
                return this.getParameters().getSynchronizationListFetcher() != null ? new DirectPersistencyEntryReplicaData(entryPacket) : new EntrySynchronizeReplicaData(entryPacket, marker);
            }
            case COPY: {
                return new EntryCopyReplicaData(entryPacket);
            }
        }
        throw new IllegalArgumentException("Illegal ReplicaType " + (Object)((Object)this._parameters.getReplicaType()));
    }

    private IEntryHolder handleTransactionConflict(IEntryHolder entry) {
        if (!this._engine.getCacheManager().isMemorySpace() && this._engine.getCacheManager().isEvictableCachePolicy()) {
            try {
                entry = this._engine.getCacheManager().getEntry(this._context, entry, false, false);
            }
            catch (SAException ex) {
                throw new InternalSpaceException("Recovery operation failed. Reason: Failed to getEntry from the CacheManager of " + this._engine.getFullSpaceName(), ex);
            }
        }
        return entry;
    }

    private void releaseTransactionLock(XtnEntry wlXtn, boolean locked) {
        if (locked) {
            wlXtn.unlock();
        }
    }

    private boolean acquireTransactionLock(IEntryHolder entry, XtnEntry wlXtn) {
        boolean locked;
        boolean bl = locked = wlXtn != null;
        if (locked) {
            wlXtn.lock();
        }
        return locked;
    }

    private IEntryPacket getEntryPacketSafely(IEntryHolder entry, XtnEntry wlXtn, boolean xtnsLocked) throws TransactionConflictException {
        IEntryHolder original = entry;
        if (this._engine.getCacheManager().needReReadAfterEntryLock()) {
            try {
                entry = this._engine.getCacheManager().getEntry(this._context, entry, false, true);
            }
            catch (SAException ex) {
                throw new InternalSpaceException("Recovery operation failed. Reason: Failed to getEntry from the CacheManager of " + this._engine.getFullSpaceName(), ex);
            }
        }
        if (entry == null || entry.isDeleted() || entry.isBlobStoreEntry() && !entry.isSameEntryInstance(original)) {
            return null;
        }
        MatchResult matchResult = this._templateHolder.match(this._engine.getCacheManager(), entry, -1, null, true, this._context, this._engine.getTemplateScanner().getRegexCache());
        if (matchResult == MatchResult.NONE) {
            return null;
        }
        IEntryHolder entryToUse = entry;
        if (wlXtn != entry.getWriteLockOwner()) {
            if (entry.getWriteLockOwner() == null) {
                wlXtn = null;
            } else {
                throw new TransactionConflictException(null, null);
            }
        }
        if (wlXtn != null) {
            XtnEntry xtnEntry = wlXtn;
            switch (entry.getWriteLockOperation()) {
                case 4: 
                case 5: {
                    if (!this.isConsideredInBacklog(xtnEntry)) break;
                    return null;
                }
                case 7: {
                    if (!entry.hasShadow(true)) break;
                    if (this.isConsideredInBacklog(xtnEntry)) {
                        if (matchResult != MatchResult.SHADOW) break;
                        return null;
                    }
                    if (matchResult == MatchResult.MASTER) {
                        return null;
                    }
                    entryToUse = entry.getShadow();
                    break;
                }
                case 1: {
                    if (xtnEntry.getStatus() != XtnStatus.ROLLED && xtnEntry.getStatus() != XtnStatus.ROLLING && xtnEntry.getStatus() != XtnStatus.BEGUN) break;
                    return null;
                }
            }
        }
        if (!(!entry.isExpired() || entry.isEntryUnderWriteLockXtn() && this._engine.getLeaseManager().isNoReapUnderXtnLeases())) {
            return null;
        }
        IEntryPacket entryPacket = this.buildEntryPacket(entryToUse);
        if (this._templateHolder.getProjectionTemplate() != null) {
            this._templateHolder.getProjectionTemplate().filterOutNonProjectionProperties(entryPacket);
        }
        return entryPacket;
    }

    private boolean isConsideredInBacklog(XtnEntry xtnEntry) {
        return xtnEntry.getStatus() == XtnStatus.COMMITED || xtnEntry.getStatus() == XtnStatus.COMMITING || xtnEntry.getStatus() == XtnStatus.PREPARED && xtnEntry.m_SingleParticipant;
    }

    private IEntryPacket buildEntryPacket(IEntryHolder eh) {
        long ttl;
        long exp = eh.getEntryData().getExpirationTime();
        if (eh.hasShadow(true)) {
            exp = Math.max(exp, eh.getShadow().getExpirationTime());
        }
        if ((ttl = this.getTimeTolive(exp)) <= 0L) {
            return null;
        }
        IEntryPacket entryPacket = EntryPacketFactory.createFullPacketForReplication(eh, null, eh.getUID(), ttl);
        entryPacket.setSerializeTypeDesc(true);
        return entryPacket;
    }

    private long getTimeTolive(long ttl) {
        return ttl == Long.MAX_VALUE ? ttl : ttl - SystemTime.timeMillis();
    }

    @Override
    public IReplicationFilterEntry toFilterEntry(AbstractEntryReplicaData data) {
        return data.toFilterEntry(this._engine.getTypeManager());
    }

    private String getLogPrefix() {
        return this._engine.getReplicationNode() + "context [" + this._requestContext + "] ";
    }

    public SpaceEngine getEngine() {
        return this._engine;
    }

    public SpaceCopyReplicaParameters getParameters() {
        return this._parameters;
    }

    public boolean isClosed() {
        return this._isClosed;
    }

    public boolean isForcedClose() {
        return this.isClosed() && this._forcedClose;
    }

    public void increaseGeneratedDataCount() {
        ++this._generatedDataCount;
    }

    @Override
    public String dumpState() {
        return "Entries replica producer: completed [" + this._isClosed + "] generated data count [" + this._generatedDataCount + "]";
    }

    @Override
    public String getName() {
        return "EntryReplicaProducer";
    }
}

