/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.replica;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.cluster.node.impl.replica.ISingleStageReplicaDataProducer;
import com.gigaspaces.internal.cluster.node.impl.replica.ISynchronizationCallback;
import com.gigaspaces.internal.cluster.node.impl.replica.data.NotifyTemplateReplicaData;
import com.gigaspaces.internal.server.space.SpaceEngine;
import com.gigaspaces.internal.server.storage.NotifyTemplateHolder;
import com.gigaspaces.internal.transport.ITemplatePacket;
import com.gigaspaces.internal.transport.TemplatePacketFactory;
import com.gigaspaces.time.SystemTime;
import com.j_spaces.core.cache.TemplateCacheInfo;
import com.j_spaces.core.cluster.IReplicationFilterEntry;
import com.j_spaces.kernel.locks.ILockObject;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;

@InternalApi
public class NotifyTemplateReplicaProducer
implements ISingleStageReplicaDataProducer<NotifyTemplateReplicaData> {
    protected static final Logger _logger = Logger.getLogger("com.gigaspaces.replication.replica");
    private final SpaceEngine _engine;
    protected final Object _requestContext;
    private final Enumeration<String> _allTemplatesSA;
    private int _generatedDataCount;
    private boolean _isClosed;

    public NotifyTemplateReplicaProducer(SpaceEngine engine, Object requestContext) {
        this._engine = engine;
        this._requestContext = requestContext;
        this._allTemplatesSA = this._engine.getCacheManager().getTemplatesManager().getAllTemplatesKeys();
    }

    @Override
    public synchronized NotifyTemplateReplicaData produceNextData(ISynchronizationCallback syncCallback) {
        if (this._isClosed) {
            return null;
        }
        while (this._allTemplatesSA.hasMoreElements()) {
            NotifyTemplateReplicaData replicaData;
            TemplateCacheInfo pt = this._engine.getCacheManager().getTemplatesManager().get(this._allTemplatesSA.nextElement());
            if (!this.isRelevant(pt) || (replicaData = this.buildSpaceReplicaData((NotifyTemplateHolder)pt.m_TemplateHolder, syncCallback)) == null) continue;
            ++this._generatedDataCount;
            return replicaData;
        }
        this.close(false);
        return null;
    }

    @Override
    public ISingleStageReplicaDataProducer.CloseStatus close(boolean forced) {
        this._isClosed = true;
        return ISingleStageReplicaDataProducer.CloseStatus.CLOSED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private NotifyTemplateReplicaData buildSpaceReplicaData(NotifyTemplateHolder notifyTemplate, ISynchronizationCallback syncCallback) {
        NotifyTemplateReplicaData notifyTemplateReplicaData;
        long exp = notifyTemplate.getEntryData().getExpirationTime();
        long ttl = this.getTimeTolive(exp);
        if (ttl <= 0L) {
            return null;
        }
        ILockObject entryLock = this._engine.getCacheManager().getLockManager().getLockObject(notifyTemplate);
        try {
            ILockObject iLockObject = entryLock;
            synchronized (iLockObject) {
                ITemplatePacket templatePacket = this.buildNotifyTemplatePacket(notifyTemplate, ttl);
                NotifyTemplateReplicaData notifyTemplateReplicaData2 = new NotifyTemplateReplicaData(templatePacket, notifyTemplate.getUID(), notifyTemplate.getNotifyInfo(), notifyTemplate.getSpaceItemType());
                boolean duplicateUid = syncCallback.synchronizationDataGenerated(notifyTemplateReplicaData2);
                if (duplicateUid) {
                    NotifyTemplateReplicaData notifyTemplateReplicaData3 = null;
                    // MONITOREXIT @DISABLED, blocks:[0, 4, 6] lbl14 : MonitorExitStatement: MONITOREXIT : var8_6
                    this._engine.getCacheManager().getLockManager().freeLockObject(entryLock);
                    return notifyTemplateReplicaData3;
                }
                notifyTemplateReplicaData = notifyTemplateReplicaData2;
            }
        }
        catch (Throwable throwable) {
            this._engine.getCacheManager().getLockManager().freeLockObject(entryLock);
            throw throwable;
        }
        this._engine.getCacheManager().getLockManager().freeLockObject(entryLock);
        return notifyTemplateReplicaData;
    }

    private boolean isRelevant(TemplateCacheInfo pt) {
        if (pt == null || pt.m_TemplateHolder == null || !pt.m_TemplateHolder.isNotifyTemplate()) {
            return false;
        }
        NotifyTemplateHolder notifyTemplate = (NotifyTemplateHolder)pt.m_TemplateHolder;
        return this.isRelevant(notifyTemplate);
    }

    protected boolean isRelevant(NotifyTemplateHolder notifyTemplate) {
        if (!notifyTemplate.isReplicateNotify()) {
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest(this.getLogPrefix() + "filtered notify template " + notifyTemplate.getClassName() + " Uid=" + notifyTemplate.getUID() + " since it is set not to be replicated");
            }
            return false;
        }
        if (notifyTemplate.getXidOriginatedTransaction() != null) {
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest(this.getLogPrefix() + "filtered notify template " + notifyTemplate.getClassName() + " Uid=" + notifyTemplate.getUID() + " since it is under transaction");
            }
            return false;
        }
        return true;
    }

    protected ITemplatePacket buildNotifyTemplatePacket(NotifyTemplateHolder templateHolder, long ttl) {
        ITemplatePacket templatePacket = TemplatePacketFactory.createFullPacketForReplication(templateHolder, null);
        templatePacket.setTTL(ttl);
        templatePacket.setSerializeTypeDesc(true);
        return templatePacket;
    }

    private long getTimeTolive(long ttl) {
        return ttl == Long.MAX_VALUE ? ttl : ttl - SystemTime.timeMillis();
    }

    @Override
    public IReplicationFilterEntry toFilterEntry(NotifyTemplateReplicaData data) {
        return data.toFilterEntry(this._engine.getTypeManager());
    }

    protected String getLogPrefix() {
        return this._engine.getReplicationNode() + "context [" + this._requestContext + "] ";
    }

    @Override
    public String dumpState() {
        return this.getDumpName() + " producer: completed [" + this._isClosed + "] generated data count [" + this._generatedDataCount + "]";
    }

    protected String getDumpName() {
        return "Notify template replica";
    }

    @Override
    public String getName() {
        return "NotifyTemplateReplicaProducer";
    }
}

