/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.replica;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.cluster.node.impl.ReplicationNode;
import com.gigaspaces.internal.cluster.node.impl.backlog.IReplicationGroupBacklog;
import com.gigaspaces.internal.cluster.node.impl.directPersistency.DirectPersistencyBackupSyncIteratorHandler;
import com.gigaspaces.internal.cluster.node.impl.directPersistency.DirectPersistencySyncListBatch;
import com.gigaspaces.internal.cluster.node.impl.directPersistency.DirectPersistencySyncListFetcher;
import com.gigaspaces.internal.cluster.node.impl.filters.ISpaceCopyReplicaOutFilter;
import com.gigaspaces.internal.cluster.node.impl.groups.IReplicationSourceGroup;
import com.gigaspaces.internal.cluster.node.impl.packets.ReplicaRequestPacket;
import com.gigaspaces.internal.cluster.node.impl.replica.CurrentStageInfo;
import com.gigaspaces.internal.cluster.node.impl.replica.ISingleStageReplicaDataProducer;
import com.gigaspaces.internal.cluster.node.impl.replica.ISpaceReplicaData;
import com.gigaspaces.internal.cluster.node.impl.replica.ISpaceReplicaDataProducer;
import com.gigaspaces.internal.cluster.node.impl.replica.ISpaceReplicaDataProducerBuilder;
import com.gigaspaces.internal.cluster.node.impl.replica.ISynchronizationCallback;
import com.gigaspaces.internal.cluster.node.impl.replica.ReplicaFailFetchingSynchronizationListException;
import com.gigaspaces.internal.cluster.node.impl.replica.SpaceReplicaBatch;
import com.gigaspaces.internal.cluster.node.impl.replica.SpaceReplicaDataProducerBuilder;
import com.gigaspaces.internal.cluster.node.impl.replica.SpaceReplicaFifoBatchesHandler;
import com.gigaspaces.internal.cluster.node.impl.replica.data.AbstractEntryReplicaData;
import com.gigaspaces.internal.cluster.node.replica.SpaceCopyReplicaParameters;
import com.gigaspaces.internal.extension.XapExtensions;
import com.gigaspaces.internal.server.metadata.IServerTypeDesc;
import com.gigaspaces.internal.server.space.SpaceEngine;
import com.gigaspaces.internal.transport.IEntryPacket;
import com.gigaspaces.internal.utils.StringUtils;
import com.gigaspaces.internal.utils.collections.CopyOnUpdateMap;
import com.gigaspaces.time.SystemTime;
import com.j_spaces.core.cache.CacheManager;
import com.j_spaces.core.cache.TypeData;
import com.j_spaces.core.cluster.IReplicationFilterEntry;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;

@InternalApi
public class ReplicationNodeReplicaHandler {
    protected static final Logger _logger = Logger.getLogger("com.gigaspaces.replication.replica");
    private final ReplicationNode _replicationNode;
    private final ISpaceReplicaDataProducerBuilder<? extends ISpaceReplicaData> _replicaDataProducerBuilder;
    private final Map<Object, ReplicaRequestData> _activeReplicaProcesses = new CopyOnUpdateMap<Object, ReplicaRequestData>();
    private final ISpaceCopyReplicaOutFilter _outFilter;
    private final boolean _isFiltered;
    private int _lastContextId;
    private volatile DirectPersistencyBackupSyncIteratorHandler _directPersistencyBackupSyncIteratorHandler;
    private final ReentrantLock _lock;
    private final SpaceEngine _spaceEngine;
    private volatile SpaceReplicaFifoBatchesHandler _fifoBatchesHandler;

    public ReplicationNodeReplicaHandler(ReplicationNode replicationNode, ISpaceReplicaDataProducerBuilder<? extends ISpaceReplicaData> replicaDataProducerBuilder, ISpaceCopyReplicaOutFilter outFilter) {
        this._replicationNode = replicationNode;
        this._replicaDataProducerBuilder = replicaDataProducerBuilder;
        this._outFilter = outFilter;
        this._isFiltered = this._outFilter != null;
        this._lock = new ReentrantLock();
        this._spaceEngine = this._replicaDataProducerBuilder != null && this._replicaDataProducerBuilder instanceof SpaceReplicaDataProducerBuilder ? ((SpaceReplicaDataProducerBuilder)this._replicaDataProducerBuilder).getSpaceEngine() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int newReplicaRequest(String requesterLookupName, ReplicaRequestPacket replicaRequestPacket) {
        this._lock.lock();
        try {
            String channelName = XapExtensions.getInstance().getReplicationUtils().toChannelName(requesterLookupName);
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine(this._replicationNode.getLogPrefix() + "new incoming replica request from " + channelName + ", request details " + replicaRequestPacket);
            }
            String groupName = replicaRequestPacket.getGroupName();
            this._replicationNode.onNewReplicaRequest(groupName, channelName, replicaRequestPacket.isSynchronizeRequest());
            if (replicaRequestPacket.isSynchronizeRequest()) {
                IReplicationSourceGroup sourceGroup = this._replicationNode.getReplicationSourceGroup(groupName);
                Iterator<Map.Entry<Object, ReplicaRequestData>> iterator = this._activeReplicaProcesses.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<Object, ReplicaRequestData> next = iterator.next();
                    ReplicaRequestData requestData = next.getValue();
                    if (!requestData.isSynchronizeReplica() || !requestData.getGroupName().equals(groupName) || !requestData.getOriginLookupName().equals(channelName)) continue;
                    sourceGroup.stopSynchronization(channelName);
                    iterator.remove();
                }
                boolean syncListRecovery = this.isDirectPersistencySyncReplicaRequest(replicaRequestPacket);
                sourceGroup.beginSynchronizing(channelName, replicaRequestPacket.getSourceUniqueId(), syncListRecovery);
                if (syncListRecovery) {
                    this.handleSyncList(replicaRequestPacket);
                }
            }
            int contextId = this._lastContextId++;
            this._activeReplicaProcesses.put(contextId, new ReplicaRequestData(groupName, channelName, this._replicaDataProducerBuilder.createProducer(replicaRequestPacket.getParameters(), contextId), replicaRequestPacket.isSynchronizeRequest()));
            if (_logger.isLoggable(Level.FINER)) {
                _logger.finer(this._replicationNode.getLogPrefix() + "new replica request from " + channelName + ", received context id " + contextId);
            }
            int n = contextId;
            return n;
        }
        finally {
            this._lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IReplicationGroupBacklog getGroupBacklogByRequestContext(Object requestContext) {
        this._lock.lock();
        try {
            ReplicaRequestData replicaRequestData = this._activeReplicaProcesses.get(requestContext);
            IReplicationSourceGroup replicationSourceGroup = this._replicationNode.getReplicationSourceGroup(replicaRequestData.getGroupName());
            IReplicationGroupBacklog iReplicationGroupBacklog = replicationSourceGroup.getGroupBacklog();
            return iReplicationGroupBacklog;
        }
        finally {
            this._lock.unlock();
        }
    }

    private void handleSyncList(ReplicaRequestPacket replicaRequestPacket) {
        SpaceCopyReplicaParameters replicaParams = (SpaceCopyReplicaParameters)replicaRequestPacket.getParameters();
        List<String> syncList = null;
        try {
            syncList = this.fetchSynchronizationList(replicaParams);
            replicaParams.setSyncList(syncList);
        }
        catch (RemoteException e) {
            throw new ReplicaFailFetchingSynchronizationListException(e);
        }
    }

    private boolean isDirectPersistencySyncReplicaRequest(ReplicaRequestPacket replicaRequestPacket) {
        return replicaRequestPacket.getParameters() instanceof SpaceCopyReplicaParameters && ((SpaceCopyReplicaParameters)replicaRequestPacket.getParameters()).getSynchronizationListFetcher() != null;
    }

    private List<String> fetchSynchronizationList(SpaceCopyReplicaParameters params) throws RemoteException {
        DirectPersistencySyncListBatch batch;
        LinkedList<String> syncList = new LinkedList<String>();
        int batchSize = Integer.getInteger("com.gs.replication.blobstore.sync_list_batch_size", 15000);
        DirectPersistencySyncListFetcher fetcher = params.getSynchronizationListFetcher();
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest(this._replicationNode.getLogPrefix() + "fetching sync list from backup, batch size is " + batchSize);
        }
        do {
            batch = fetcher.fetchBatch();
            syncList.addAll(batch.getBatch());
        } while (batch.size() == batchSize);
        return syncList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<ISpaceReplicaData> getNextReplicaBatch(final Object context, int batchSize) {
        this._lock.lock();
        try {
            Object data;
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest(this._replicationNode.getLogPrefix() + "context [" + context + "] get next replica batch request");
            }
            final ReplicaRequestData replicaData = this.getReplicaContext(context);
            ISynchronizationCallback syncCallback = new ISynchronizationCallback(){

                @Override
                public boolean synchronizationDataGenerated(ISpaceReplicaData data) {
                    if (replicaData.isSynchronizeReplica()) {
                        IReplicationSourceGroup sourceGroup = ReplicationNodeReplicaHandler.this._replicationNode.getReplicationSourceGroup(replicaData.getGroupName());
                        boolean duplicateUid = sourceGroup.synchronizationDataGenerated(replicaData.getOriginLookupName(), data.getUid());
                        if (duplicateUid && _logger.isLoggable(Level.FINEST)) {
                            _logger.finest(ReplicationNodeReplicaHandler.this._replicationNode.getLogPrefix() + "context [" + context + "] filtered replica data [" + data + "] due to duplicate uid [" + data.getUid() + "]");
                        }
                        return duplicateUid;
                    }
                    return false;
                }
            };
            SpaceReplicaBatch result = new SpaceReplicaBatch(batchSize);
            boolean isFifoBatch = false;
            while (result.size() < batchSize && (data = replicaData.getProducer().produceNextData(syncCallback)) != null) {
                if (this._isFiltered && data.supportsReplicationFilter()) {
                    IReplicationFilterEntry filterEntry = replicaData.getProducer().toFilterEntry(data);
                    this._outFilter.filterOut(filterEntry, replicaData.getOriginLookupName());
                    if (filterEntry.isDiscarded()) continue;
                }
                result.add((ISpaceReplicaData)data);
                if (isFifoBatch) continue;
                isFifoBatch = this.isFifoType((ISpaceReplicaData)data);
            }
            if (isFifoBatch) {
                result.setFifoId(replicaData.nextFifoBatchId());
            }
            if (!result.isEmpty() && _logger.isLoggable(Level.FINEST)) {
                _logger.finest(this._replicationNode.getLogPrefix() + "context [" + context + "] returning batch " + result);
            }
            SpaceReplicaBatch spaceReplicaBatch = result;
            return spaceReplicaBatch;
        }
        finally {
            this._lock.unlock();
        }
    }

    private boolean isFifoType(ISpaceReplicaData data) {
        if (data.isEntryReplicaData()) {
            CacheManager cacheManager = this._spaceEngine.getCacheManager();
            IEntryPacket entryPacket = ((AbstractEntryReplicaData)data).getEntryPacket();
            if (entryPacket != null) {
                IServerTypeDesc serverTypeDesc = cacheManager.getTypeManager().getServerTypeDesc(entryPacket.getTypeName());
                TypeData typeData = cacheManager.getTypeData(serverTypeDesc);
                return typeData.isFifoSupport() || typeData.getFifoGroupingIndex() != null;
            }
        }
        return false;
    }

    private ReplicaRequestData getReplicaContext(Object context) {
        ReplicaRequestData replicaData = this._activeReplicaProcesses.get(context);
        if (replicaData == null) {
            throw new IllegalArgumentException("Context [" + context + "] is not valid");
        }
        replicaData.touch();
        return replicaData;
    }

    public CurrentStageInfo nextReplicaState(Object context) {
        ReplicaRequestData replicaData = this.getReplicaContext(context);
        CurrentStageInfo currentStage = replicaData.getProducer().nextReplicaStage();
        if (currentStage.isLastStage()) {
            if (_logger.isLoggable(Level.FINER)) {
                _logger.finer(this._replicationNode.getLogPrefix() + "context [" + context + "] all stages completed, closing request");
            }
            replicaData.getProducer().close(false);
            if (this._replicationNode.getDirectPesistencySyncHandler() != null) {
                if (_logger.isLoggable(Level.FINER)) {
                    _logger.finer(this._replicationNode.getLogPrefix() + "clearing direct persistency sync list");
                }
                this._replicationNode.getDirectPesistencySyncHandler().afterRecovery();
            }
            if (replicaData.isSynchronizeReplica()) {
                this._replicationNode.getReplicationSourceGroup(replicaData.getGroupName()).synchronizationCopyStageDone(replicaData.getOriginLookupName());
            }
            this._activeReplicaProcesses.remove(context);
        } else if (_logger.isLoggable(Level.FINER)) {
            _logger.finer(this._replicationNode.getLogPrefix() + "context [" + context + "] completed stage [" + currentStage.getStageName() + "] moving to next stage [" + currentStage.getNextStageName() + "]");
        }
        return currentStage;
    }

    public void clearStaleReplicas(long expirationTime) {
        if (this._spaceEngine != null && this._spaceEngine.getLeaseManager().isCurrentLeaseReaperThread()) {
            if (!this._lock.tryLock()) {
                if (_logger.isLoggable(Level.FINER)) {
                    _logger.finer("LeaseManager thread-->clearStaleReplicas: No need in  clearing stale replicas done by shutdowm thread");
                }
                return;
            }
        } else {
            this._lock.lock();
        }
        try {
            if (_logger.isLoggable(Level.FINER)) {
                _logger.finer("clearing stale replicas, last touched before " + expirationTime);
            }
            this.clearReplicas(expirationTime);
        }
        finally {
            this._lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearReplicas(long forcedExpirationTime) {
        this._lock.lock();
        try {
            Iterator<Map.Entry<Object, ReplicaRequestData>> iterator = this._activeReplicaProcesses.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<Object, ReplicaRequestData> entry = iterator.next();
                ReplicaRequestData replicaRequestData = entry.getValue();
                if (forcedExpirationTime != 0L && replicaRequestData.getLastTouched() > forcedExpirationTime) continue;
                if (forcedExpirationTime != 0L && _logger.isLoggable(Level.FINER)) {
                    _logger.finer("clearing stale replica [" + entry.getKey() + "]" + replicaRequestData);
                }
                if (forcedExpirationTime == 0L) {
                    _logger.warning("forced clearing of replica [" + entry.getKey() + "]" + replicaRequestData);
                }
                try {
                    ISingleStageReplicaDataProducer.CloseStatus closeStatus = replicaRequestData.getProducer().close(forcedExpirationTime == 0L);
                    if (closeStatus == ISingleStageReplicaDataProducer.CloseStatus.CLOSING) continue;
                    iterator.remove();
                    if (!replicaRequestData.isSynchronizeReplica()) continue;
                    IReplicationSourceGroup sourceGroup = this._replicationNode.getReplicationSourceGroup(replicaRequestData.getGroupName());
                    sourceGroup.stopSynchronization(replicaRequestData.getOriginLookupName());
                }
                catch (Exception e) {
                    if (!_logger.isLoggable(Level.WARNING)) continue;
                    _logger.log(Level.WARNING, "error while clearing stale/forced replica [" + entry.getKey() + "]" + replicaRequestData, e);
                }
            }
        }
        finally {
            this._lock.unlock();
        }
    }

    public void close() {
        this.clearReplicas(0L);
    }

    public String dumpState() {
        StringBuilder dump = new StringBuilder("Active outgoing replicas: ");
        Set<Map.Entry<Object, ReplicaRequestData>> entrySet = this._activeReplicaProcesses.entrySet();
        if (entrySet.isEmpty()) {
            dump.append(StringUtils.NEW_LINE);
            dump.append("NONE");
        }
        for (Map.Entry<Object, ReplicaRequestData> entry : entrySet) {
            dump.append(StringUtils.NEW_LINE);
            dump.append("Context id [" + entry.getKey() + "]: " + entry.getValue());
        }
        return dump.toString();
    }

    public DirectPersistencyBackupSyncIteratorHandler getDirectPersistencyBackupSyncIteratorHandler() {
        return this._directPersistencyBackupSyncIteratorHandler;
    }

    public void setDirectPersistencyBackupSyncIteratorHandler(DirectPersistencyBackupSyncIteratorHandler _directPersistencyBackupSyncIteratorHandler) {
        this._directPersistencyBackupSyncIteratorHandler = _directPersistencyBackupSyncIteratorHandler;
    }

    public SpaceReplicaFifoBatchesHandler getFifoBatchesHandler() {
        return this._fifoBatchesHandler;
    }

    public void initFifoBatchesHandler() {
        this._fifoBatchesHandler = new SpaceReplicaFifoBatchesHandler(this._replicationNode);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine(this._replicationNode.getLogPrefix() + "created fifoBatchesHandler");
        }
    }

    public void clearFifoBatchesHandler() {
        this._fifoBatchesHandler = null;
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine(this._replicationNode.getLogPrefix() + "cleared fifoBatchesHandler");
        }
    }

    private static class ReplicaRequestData {
        private final String _groupName;
        private final String _originLookupName;
        private final ISpaceReplicaDataProducer<? extends ISpaceReplicaData> _producer;
        private final boolean _synchronizeReplica;
        private volatile long _lastTouched;
        private int _fifoIdGenerator = 0;

        public ReplicaRequestData(String groupName, String originLookupName, ISpaceReplicaDataProducer<? extends ISpaceReplicaData> producer, boolean synchronizeReplica) {
            this._groupName = groupName;
            this._originLookupName = originLookupName;
            this._producer = producer;
            this._synchronizeReplica = synchronizeReplica;
            this._lastTouched = SystemTime.timeMillis();
        }

        public void touch() {
            this._lastTouched = SystemTime.timeMillis();
        }

        public long getLastTouched() {
            return this._lastTouched;
        }

        public String getOriginLookupName() {
            return this._originLookupName;
        }

        public String getGroupName() {
            return this._groupName;
        }

        public ISpaceReplicaDataProducer getProducer() {
            return this._producer;
        }

        public boolean isSynchronizeReplica() {
            return this._synchronizeReplica;
        }

        public int nextFifoBatchId() {
            return ++this._fifoIdGenerator;
        }

        public String toString() {
            return "Origin [" + this.getOriginLookupName() + "] isSynchronize [" + this.isSynchronizeReplica() + "] Synchronize group name [" + this.getGroupName() + "] Last touched time [" + this.getLastTouched() + "]" + StringUtils.NEW_LINE + "\tProducer state: " + this.getProducer().dumpState();
        }
    }
}

