/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.replica;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.cluster.node.impl.replica.AbstractMultiSpaceReplicaDataProducer;
import com.gigaspaces.internal.cluster.node.impl.replica.BroadcastNotifyTemplateReplicaProducer;
import com.gigaspaces.internal.cluster.node.impl.replica.IExecutableSpaceReplicaData;
import com.gigaspaces.internal.cluster.node.impl.replica.ISingleStageReplicaDataProducer;
import com.gigaspaces.internal.cluster.node.impl.replica.SpaceTypeReplicaDataProducer;
import com.gigaspaces.internal.cluster.node.replica.SpaceCopyReplicaParameters;
import com.gigaspaces.internal.server.space.SpaceEngine;
import com.j_spaces.core.cluster.IReplicationFilterEntry;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;

@InternalApi
public class SpaceBroadcastNotifyReplicaDataProducer
extends AbstractMultiSpaceReplicaDataProducer {
    public SpaceBroadcastNotifyReplicaDataProducer(SpaceEngine engine, SpaceCopyReplicaParameters parameters, Object requestContext) {
        super(engine, parameters, requestContext);
    }

    @Override
    protected List<ISingleStageReplicaDataProducer<? extends IExecutableSpaceReplicaData>> buildDataProducers(SpaceCopyReplicaParameters parameters) {
        ArrayList<ISingleStageReplicaDataProducer<? extends IExecutableSpaceReplicaData>> dataProducers = new ArrayList<ISingleStageReplicaDataProducer<? extends IExecutableSpaceReplicaData>>();
        dataProducers.add(new SpaceTypeReplicaDataProducer(this._engine));
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest(this._engine.getReplicationNode() + "created SpaceTypeReplicaDataProducer");
        }
        if (parameters.isCopyNotifyTemplates()) {
            dataProducers.add(new BroadcastNotifyTemplateReplicaProducer(this._engine, this._requestContext));
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest(this.getLogPrefix() + "created BroadcastNotifyTemplateReplicaProducer");
            }
        }
        return dataProducers;
    }

    @Override
    public IReplicationFilterEntry toFilterEntry(IExecutableSpaceReplicaData data) {
        return data.toFilterEntry(this._engine.getTypeManager());
    }

    @Override
    public String getName() {
        return "SpaceBroadcastNotifyReplicaDataProducer";
    }
}

