/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.replica;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.events.GSEventRegistration;
import com.gigaspaces.internal.cluster.node.impl.replica.ISpaceCopyIntermediateResult;
import com.gigaspaces.internal.cluster.node.replica.ISpaceCopyResult;
import com.gigaspaces.internal.utils.collections.ConcurrentHashSet;
import com.j_spaces.core.SpaceCopyStatus;
import com.j_spaces.core.SpaceCopyStatusImpl;
import com.j_spaces.kernel.JSpaceUtilities;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import net.jini.core.event.EventRegistration;

@InternalApi
public class SpaceCopyIntermediateResult
implements ISpaceCopyIntermediateResult,
ISpaceCopyResult {
    private final ConcurrentHashMap<String, AtomicInteger> _writtenTypesCount;
    private final ConcurrentHashMap<String, AtomicInteger> _notifyTemplateTypesCount;
    private final ConcurrentHashMap<String, String> _duplicateEntries;
    private final AtomicInteger _totalCopiedObjects;
    private final AtomicInteger _blockedByFilterEntries;
    private final Exception _failureReason;
    private final ConcurrentHashSet<EventRegistration> _notifyRegistrations;

    public SpaceCopyIntermediateResult() {
        this._writtenTypesCount = new ConcurrentHashMap();
        this._notifyTemplateTypesCount = new ConcurrentHashMap();
        this._duplicateEntries = new ConcurrentHashMap();
        this._totalCopiedObjects = new AtomicInteger(0);
        this._blockedByFilterEntries = new AtomicInteger(0);
        this._notifyRegistrations = new ConcurrentHashSet();
        this._failureReason = null;
    }

    public SpaceCopyIntermediateResult(Map<String, Integer> writtenTypesCount, Map<String, Integer> notifyTemplateTypesCount, Map<String, String> duplicateEntries, int totalCopiedObjects, int blockedByFilterEntries, Exception failureReason, ConcurrentHashSet<EventRegistration> notifyRegistrations) {
        this._writtenTypesCount = SpaceCopyIntermediateResult.toConcurrentCount(writtenTypesCount);
        this._notifyTemplateTypesCount = SpaceCopyIntermediateResult.toConcurrentCount(notifyTemplateTypesCount);
        this._duplicateEntries = new ConcurrentHashMap<String, String>(duplicateEntries);
        this._totalCopiedObjects = new AtomicInteger(totalCopiedObjects);
        this._blockedByFilterEntries = new AtomicInteger(blockedByFilterEntries);
        this._notifyRegistrations = notifyRegistrations;
        this._failureReason = failureReason;
    }

    @Override
    public ISpaceCopyIntermediateResult merge(ISpaceCopyIntermediateResult mergeWith) {
        SpaceCopyIntermediateResult other = (SpaceCopyIntermediateResult)mergeWith;
        Map<String, Integer> mergedWritten = SpaceCopyIntermediateResult.mergeCountMaps(this._writtenTypesCount, other._writtenTypesCount);
        Map<String, Integer> mergedNotify = SpaceCopyIntermediateResult.mergeCountMaps(this._notifyTemplateTypesCount, other._notifyTemplateTypesCount);
        int mergedTotalCopied = this._totalCopiedObjects.get() + other._totalCopiedObjects.get();
        int mergedTotalBlocked = this._blockedByFilterEntries.get() + other._blockedByFilterEntries.get();
        HashMap<String, String> mergedDuplicateEntries = new HashMap<String, String>(this._duplicateEntries);
        mergedDuplicateEntries.putAll(other._duplicateEntries);
        Exception mergedFailureReason = this._failureReason;
        if (mergedFailureReason == null) {
            mergedFailureReason = other._failureReason;
        }
        ConcurrentHashSet<EventRegistration> mergedRegistrations = new ConcurrentHashSet<EventRegistration>();
        mergedRegistrations.addAll(this._notifyRegistrations);
        mergedRegistrations.addAll(other._notifyRegistrations);
        return new SpaceCopyIntermediateResult(mergedWritten, mergedNotify, mergedDuplicateEntries, mergedTotalCopied, mergedTotalBlocked, mergedFailureReason, mergedRegistrations);
    }

    private static Map<String, Integer> mergeCountMaps(ConcurrentHashMap<String, AtomicInteger> writtenTypesCount1, ConcurrentHashMap<String, AtomicInteger> writtenTypesCount2) {
        HashMap<String, Integer> result = new HashMap<String, Integer>(SpaceCopyIntermediateResult.toFinalCountMap(writtenTypesCount1));
        for (Map.Entry<String, AtomicInteger> entry : writtenTypesCount2.entrySet()) {
            Integer currentCount = result.get(entry.getKey());
            if (currentCount == null) {
                currentCount = 0;
            }
            currentCount = currentCount + entry.getValue().get();
            result.put(entry.getKey(), currentCount);
        }
        return result;
    }

    @Override
    public ISpaceCopyIntermediateResult mergeFailure(Exception failureReason) {
        return new SpaceCopyIntermediateResult(SpaceCopyIntermediateResult.toFinalCountMap(this._writtenTypesCount), SpaceCopyIntermediateResult.toFinalCountMap(this._notifyTemplateTypesCount), this._duplicateEntries, this._totalCopiedObjects.get(), this._blockedByFilterEntries.get(), failureReason, this._notifyRegistrations);
    }

    private static Map<String, Integer> toFinalCountMap(ConcurrentHashMap<String, AtomicInteger> writtenTypesCount) {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        for (Map.Entry<String, AtomicInteger> entry : writtenTypesCount.entrySet()) {
            result.put(entry.getKey(), entry.getValue().get());
        }
        return result;
    }

    private static ConcurrentHashMap<String, AtomicInteger> toConcurrentCount(Map<String, Integer> notifyTemplateTypesCount) {
        ConcurrentHashMap<String, AtomicInteger> result = new ConcurrentHashMap<String, AtomicInteger>();
        for (Map.Entry<String, Integer> entry : notifyTemplateTypesCount.entrySet()) {
            result.put(entry.getKey(), new AtomicInteger(entry.getValue()));
        }
        return result;
    }

    @Override
    public ISpaceCopyResult toFinalResult() {
        return this;
    }

    public void increaseWritenTypeCount(String className) {
        this.increaseCount(className, this._writtenTypesCount);
    }

    public void addDuplicateEntry(String uid, String className) {
        this._duplicateEntries.put(uid, className);
    }

    @Override
    public void incrementBlockedByFilterEntry() {
        this._blockedByFilterEntries.incrementAndGet();
    }

    public void increaseNotifyTemplateTypeCount(String className) {
        this.increaseCount(className, this._notifyTemplateTypesCount);
    }

    private void increaseCount(String className, ConcurrentHashMap<String, AtomicInteger> countMap) {
        AtomicInteger prevCounter;
        AtomicInteger counter = countMap.get(className);
        if (counter == null && (prevCounter = countMap.putIfAbsent(className, counter = new AtomicInteger())) != null) {
            counter = prevCounter;
        }
        counter.incrementAndGet();
        this._totalCopiedObjects.incrementAndGet();
    }

    @Override
    public Exception getFailureReason() {
        return this._failureReason;
    }

    @Override
    public boolean isEmpty() {
        return this._totalCopiedObjects.get() == 0;
    }

    @Override
    public boolean isFailed() {
        return this.getFailureReason() != null;
    }

    @Override
    public boolean isSuccessful() {
        return !this.isFailed();
    }

    @Override
    public String getStringDescription(String remoteSpaceMember, String remoteMemberUrl, String spaceName, boolean spaceSyncOperation, long duration) {
        if (this.isFailed()) {
            return (spaceSyncOperation ? "Recovery" : "Copy") + " operation failed: " + this.getFailureReason().toString();
        }
        StringBuilder sb = new StringBuilder();
        String operation = spaceSyncOperation ? "Recovered" : "Copied";
        sb.append(operation).append(" from ").append(remoteSpaceMember).append(" [").append(remoteMemberUrl).append("] to ").append(spaceName);
        sb.append(" [duration=" + JSpaceUtilities.formatMillis(duration));
        sb.append(", total-objects=").append(this._totalCopiedObjects.get());
        this.appendEntriesDesc(sb, this._writtenTypesCount);
        this.appendNotifyTemplatesDesc(sb, this._notifyTemplateTypesCount);
        this.appendDuplicatesDesc(sb, this._duplicateEntries);
        int discarded = this._blockedByFilterEntries.get();
        if (discarded != 0) {
            sb.append(",discarded-by-replication-input-filter=" + discarded);
        }
        sb.append("]");
        return sb.toString();
    }

    private static void append(StringBuilder sb, String format, Object ... args) {
        String formatted = MessageFormat.format(format, args);
        sb.append(formatted);
    }

    private void appendEntriesDesc(StringBuilder sb, Map<String, AtomicInteger> copiedEntries) {
        if (copiedEntries.size() != 0) {
            sb.append(",entries={");
            int total = 0;
            for (Map.Entry<String, AtomicInteger> entry : copiedEntries.entrySet()) {
                int count = entry.getValue().get();
                sb.append(entry.getKey() + "=" + count + ",");
                total += count;
            }
            sb.append("TOTAL=" + total + "}");
        }
    }

    private void appendNotifyTemplatesDesc(StringBuilder sb, Map<String, AtomicInteger> copiedNotifyTemplates) {
        if (copiedNotifyTemplates.size() != 0) {
            sb.append(",notify-templates={");
            int total = 0;
            for (Map.Entry<String, AtomicInteger> entry : copiedNotifyTemplates.entrySet()) {
                int count = entry.getValue().get();
                sb.append(entry.getKey() + "=" + count + ",");
                total += count;
            }
            sb.append("TOTAL=" + total + "}");
        }
    }

    private void appendDuplicatesDesc(StringBuilder sb, Map<String, String> duplicateEntries) {
        if (duplicateEntries.size() != 0) {
            sb.append(",duplicates=" + duplicateEntries.size());
            sb.append(" {");
            for (Map.Entry<String, String> entry : duplicateEntries.entrySet()) {
                String uid = entry.getKey();
                String className = entry.getValue();
                sb.append(uid + "/" + className + ",");
            }
            sb.setLength(sb.length() - 1);
            sb.append("}");
        }
    }

    public void addRegisteredNotifyTemplate(String templateClassName, GSEventRegistration notifyRegistration) {
        this._notifyRegistrations.add(notifyRegistration);
        this.increaseCount(templateClassName, this._notifyTemplateTypesCount);
    }

    public Set<EventRegistration> getNotifyRegistrations() {
        return this._notifyRegistrations;
    }

    @Override
    public SpaceCopyStatus toOldResult(short operationType, String targetMember) {
        SpaceCopyStatusImpl result = new SpaceCopyStatusImpl(operationType, targetMember);
        Set<Map.Entry<String, AtomicInteger>> writtenTypesCount = this._writtenTypesCount.entrySet();
        for (Map.Entry<String, AtomicInteger> entry : writtenTypesCount) {
            String string = entry.getKey();
            AtomicInteger count = entry.getValue();
            result.setWriteCount(string, count.intValue());
        }
        Set<Map.Entry<String, AtomicInteger>> notifyTemplateTypesCount = this._notifyTemplateTypesCount.entrySet();
        for (Map.Entry<String, AtomicInteger> entry : notifyTemplateTypesCount) {
            String className = entry.getKey();
            AtomicInteger count = entry.getValue();
            result.setNotifyTemplateCount(className, count.intValue());
        }
        Set<Map.Entry<String, String>> set = this._duplicateEntries.entrySet();
        for (Map.Entry<String, String> entry : set) {
            String UID = entry.getKey();
            String className = entry.getValue();
            result.addDuplicateUID(className, UID);
        }
        result.setTotalDummyObj(this._blockedByFilterEntries.intValue());
        if (this._failureReason != null) {
            result.setCauseException(this._failureReason);
        }
        return result;
    }
}

