/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.replica;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.cluster.node.impl.replica.AbstractMultiSpaceReplicaDataProducer;
import com.gigaspaces.internal.cluster.node.impl.replica.BroadcastNotifyTemplateReplicaProducer;
import com.gigaspaces.internal.cluster.node.impl.replica.EntryReplicaProducer;
import com.gigaspaces.internal.cluster.node.impl.replica.IExecutableSpaceReplicaData;
import com.gigaspaces.internal.cluster.node.impl.replica.ISingleStageReplicaDataProducer;
import com.gigaspaces.internal.cluster.node.impl.replica.SpaceTypeReplicaDataProducer;
import com.gigaspaces.internal.cluster.node.replica.SpaceCopyReplicaParameters;
import com.gigaspaces.internal.server.space.SpaceEngine;
import com.gigaspaces.internal.transport.ITemplatePacket;
import com.gigaspaces.security.authorities.SpaceAuthority;
import com.j_spaces.core.SpaceContext;
import com.j_spaces.core.cluster.IReplicationFilterEntry;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;

@InternalApi
public class SpaceCopyReplicaDataProducer
extends AbstractMultiSpaceReplicaDataProducer {
    public SpaceCopyReplicaDataProducer(SpaceEngine engine, SpaceCopyReplicaParameters parameters, Object requestContext) {
        super(engine, parameters, requestContext);
        SpaceContext sc = parameters.getSpaceContext();
        List<ITemplatePacket> templatePackets = parameters.getTemplatePackets();
        for (ITemplatePacket templatePacket : templatePackets) {
            engine.getSpaceImpl().checkPacketAccessPrivileges(sc, SpaceAuthority.SpacePrivilege.READ, templatePacket);
        }
        if (engine.getFilterManager()._isFilter[2]) {
            for (ITemplatePacket templatePacket : templatePackets) {
                engine.getFilterManager().invokeFilters(2, sc, templatePacket);
            }
        }
    }

    @Override
    protected List<ISingleStageReplicaDataProducer<? extends IExecutableSpaceReplicaData>> buildDataProducers(SpaceCopyReplicaParameters parameters) {
        ArrayList<ISingleStageReplicaDataProducer<? extends IExecutableSpaceReplicaData>> dataProducers = new ArrayList<ISingleStageReplicaDataProducer<? extends IExecutableSpaceReplicaData>>();
        dataProducers.add(new SpaceTypeReplicaDataProducer(this._engine));
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest(this._engine.getReplicationNode() + "created SpaceTypeReplicaDataProducer");
        }
        for (ITemplatePacket templatePacket : parameters.getTemplatePackets()) {
            dataProducers.add(new EntryReplicaProducer(this._engine, parameters, templatePacket, this._requestContext));
            if (!_logger.isLoggable(Level.FINEST)) continue;
            _logger.finest(this.getLogPrefix() + "created EntryReplicaProducer for templatePacket " + templatePacket);
        }
        if (parameters.isCopyNotifyTemplates()) {
            dataProducers.add(new BroadcastNotifyTemplateReplicaProducer(this._engine, this._requestContext));
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest(this.getLogPrefix() + "created BroadcastNotifyTemplateReplicaProducer");
            }
        }
        return dataProducers;
    }

    @Override
    public IReplicationFilterEntry toFilterEntry(IExecutableSpaceReplicaData data) {
        return data.toFilterEntry(this._engine.getTypeManager());
    }

    @Override
    public String getName() {
        return "SpaceCopyReplicaDataProducer";
    }
}

