/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.replica;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.async.AsyncFuture;
import com.gigaspaces.async.AsyncFutureListener;
import com.gigaspaces.async.AsyncResult;
import com.gigaspaces.internal.cluster.node.impl.ReplicationNode;
import com.gigaspaces.internal.cluster.node.impl.filters.ISpaceCopyReplicaInFilter;
import com.gigaspaces.internal.cluster.node.impl.packets.NextReplicaStatePacket;
import com.gigaspaces.internal.cluster.node.impl.packets.ReplicaFetchDataPacket;
import com.gigaspaces.internal.cluster.node.impl.replica.CurrentStageInfo;
import com.gigaspaces.internal.cluster.node.impl.replica.ISpaceCopyIntermediateResult;
import com.gigaspaces.internal.cluster.node.impl.replica.ISpaceReplicaData;
import com.gigaspaces.internal.cluster.node.impl.replica.ISpaceReplicaDataConsumer;
import com.gigaspaces.internal.cluster.node.impl.replica.ReplicaAbortedException;
import com.gigaspaces.internal.cluster.node.impl.replica.SpaceReplicaBatch;
import com.gigaspaces.internal.cluster.node.impl.replica.SpaceReplicaFifoBatchesHandler;
import com.gigaspaces.internal.cluster.node.impl.replica.SpaceReplicaState;
import com.gigaspaces.internal.cluster.node.impl.router.IReplicationMonitoredConnection;
import com.gigaspaces.internal.utils.concurrent.AsyncCallable;
import com.gigaspaces.internal.utils.concurrent.CyclicAtomicInteger;
import com.gigaspaces.internal.utils.concurrent.IAsyncHandlerProvider;
import com.gigaspaces.time.SystemTime;
import com.j_spaces.core.cluster.IReplicationFilterEntry;
import java.util.Collection;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

@InternalApi
public class SpaceCopyReplicaRunnable
extends AsyncCallable
implements AsyncFutureListener<Collection<ISpaceReplicaData>> {
    protected static final Logger _logger = Logger.getLogger("com.gigaspaces.replication.replica");
    private final ReplicationNode _replicationNode;
    private final IReplicationMonitoredConnection _originConnection;
    private final ISpaceReplicaDataConsumer _replicaDataProducer;
    private final Object _replicaRemoteContext;
    private final SpaceReplicaState _state;
    private final ReplicaFetchDataPacket _fetchDataPacket;
    private final ISpaceCopyIntermediateResult _intermediateResult;
    private final ISpaceCopyReplicaInFilter _inFilter;
    private final boolean _isFiltered;
    private final CyclicAtomicInteger _orderProvider;
    private volatile boolean _aborted;
    private volatile long _lastIterationTimeStamp = SystemTime.timeMillis();

    public SpaceCopyReplicaRunnable(ReplicationNode replicationNode, IReplicationMonitoredConnection originConnection, ISpaceReplicaDataConsumer replicaDataProcessor, ISpaceCopyReplicaInFilter inFilter, Object replicaRemoteContext, int fetchBatchSize, SpaceReplicaState state, CyclicAtomicInteger orderProvider) {
        this._replicationNode = replicationNode;
        this._originConnection = originConnection;
        this._replicaDataProducer = replicaDataProcessor;
        this._replicaRemoteContext = replicaRemoteContext;
        this._state = state;
        this._inFilter = inFilter;
        this._orderProvider = orderProvider;
        this._isFiltered = this._inFilter != null;
        this._fetchDataPacket = new ReplicaFetchDataPacket(replicaRemoteContext, fetchBatchSize);
        this._intermediateResult = this._replicaDataProducer.createEmptyResult();
    }

    public ISpaceCopyIntermediateResult getIntermediateResult() {
        return this._intermediateResult;
    }

    @Override
    public IAsyncHandlerProvider.CycleResult call() {
        try {
            if (this._aborted) {
                throw new ReplicaAbortedException();
            }
            AsyncFuture<Collection<ISpaceReplicaData>> future = this._originConnection.dispatchAsync(this._fetchDataPacket);
            future.setListener(this);
            return IAsyncHandlerProvider.CycleResult.SUSPEND;
        }
        catch (Throwable e2) {
            ExecutionException e2;
            if (_logger.isLoggable(Level.FINER)) {
                _logger.log(Level.FINER, this._replicationNode.getLogPrefix() + " dispatch request for replica batch has an exception", e2);
            }
            if (!(e2 instanceof Exception)) {
                e2 = new ExecutionException(e2.getMessage(), e2);
            }
            this._state.signalCopyStageFailed(e2);
            return IAsyncHandlerProvider.CycleResult.TERMINATE;
        }
    }

    public long getLastIterationTimeStamp() {
        return this._lastIterationTimeStamp;
    }

    public void abort() {
        this._aborted = true;
        this.getHandler().stop(1L, TimeUnit.MILLISECONDS);
    }

    @Override
    public void onResult(AsyncResult<Collection<ISpaceReplicaData>> result) {
        try {
            if (result.getException() != null) {
                if (_logger.isLoggable(Level.FINER)) {
                    _logger.log(Level.FINER, this._replicationNode.getLogPrefix() + " incoming replica batch has an exception", result.getException());
                }
                throw result.getException();
            }
            if (result.getResult() == null || result.getResult().isEmpty()) {
                boolean hasMoreStages;
                int arrivalOrder = this._orderProvider.getAndIncrement();
                if (arrivalOrder < this._orderProvider.getMaxValue()) {
                    return;
                }
                boolean isOldVersion = false;
                Object nextStage = this._originConnection.dispatch(new NextReplicaStatePacket(this._replicaRemoteContext));
                String stageName = null;
                String nextStageName = null;
                if (nextStage instanceof Boolean) {
                    hasMoreStages = (Boolean)nextStage;
                    isOldVersion = true;
                } else {
                    CurrentStageInfo stageInfo = (CurrentStageInfo)nextStage;
                    stageName = stageInfo.getStageName();
                    hasMoreStages = !stageInfo.isLastStage();
                    nextStageName = stageInfo.getNextStageName();
                }
                if (hasMoreStages) {
                    if (_logger.isLoggable(Level.FINER)) {
                        _logger.finer(this._replicationNode.getLogPrefix() + (isOldVersion ? "" : " completed current stage [" + stageName + "], ") + "moved to the next stage" + (isOldVersion ? "" : " [" + nextStageName + "]") + ".");
                    }
                    this._state.signalSingleCopyStageDone();
                } else {
                    if (_logger.isLoggable(Level.FINER)) {
                        _logger.finer(this._replicationNode.getLogPrefix() + (isOldVersion ? "" : " completed current stage [" + stageName + "], ") + "all stages completed.");
                    }
                    this._state.signalEntireCopyStageDoneSucessfully();
                }
            } else if (result.getResult() instanceof SpaceReplicaBatch) {
                SpaceReplicaBatch batch = (SpaceReplicaBatch)result.getResult();
                if (batch.isFifoBatch()) {
                    SpaceReplicaFifoBatchesHandler fifoBatchesHandler = this._replicationNode.getReplicaHandler().getFifoBatchesHandler();
                    fifoBatchesHandler.handleIncomingBatch(batch, this);
                } else {
                    this.processBatch(result.getResult());
                }
            } else {
                this.processBatch(result.getResult());
            }
        }
        catch (Throwable e2) {
            ExecutionException e2;
            if (!(e2 instanceof Exception)) {
                e2 = new ExecutionException(e2.getMessage(), e2);
            }
            this._state.signalCopyStageFailed(e2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processBatch(Collection<ISpaceReplicaData> copiedData) {
        try {
            this._lastIterationTimeStamp = SystemTime.timeMillis();
            if (this._replicationNode.getBlobStoreReplicaConsumeHelper() != null && copiedData.size() > 1) {
                this._replicationNode.getBlobStoreReplicaConsumeHelper().prepareForBulking();
            }
            try {
                for (ISpaceReplicaData data : copiedData) {
                    if (this._isFiltered && data.supportsReplicationFilter()) {
                        IReplicationFilterEntry filterEntry = this._replicaDataProducer.toFilterEntry(data);
                        this._inFilter.filterIn(filterEntry, this._originConnection.getFinalEndpointLookupName());
                        if (filterEntry.isDiscarded()) {
                            this._intermediateResult.incrementBlockedByFilterEntry();
                            continue;
                        }
                    }
                    this._replicaDataProducer.consumeData(data, this._intermediateResult, this._replicationNode);
                }
            }
            finally {
                if (this._replicationNode.getBlobStoreReplicaConsumeHelper() != null) {
                    this._replicationNode.getBlobStoreReplicaConsumeHelper().flushBulk();
                }
            }
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.log(Level.FINEST, this._replicationNode.getLogPrefix() + "copied replica batch " + copiedData);
            }
            this.getHandler().resumeNow();
        }
        catch (Throwable e2) {
            ExecutionException e2;
            if (!(e2 instanceof Exception)) {
                e2 = new ExecutionException(e2.getMessage(), e2);
            }
            this._state.signalCopyStageFailed(e2);
        }
    }
}

