/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.replica;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.cluster.node.impl.replica.IExecutableSpaceReplicaData;
import com.gigaspaces.internal.cluster.node.impl.replica.ISpaceReplicaDataProducer;
import com.gigaspaces.internal.cluster.node.impl.replica.ISpaceReplicaDataProducerBuilder;
import com.gigaspaces.internal.cluster.node.impl.replica.SpaceBroadcastNotifyReplicaDataProducer;
import com.gigaspaces.internal.cluster.node.impl.replica.SpaceCopyReplicaDataProducer;
import com.gigaspaces.internal.cluster.node.impl.replica.SynchronizeReplicaDataProducer;
import com.gigaspaces.internal.cluster.node.replica.ISpaceCopyReplicaParameters;
import com.gigaspaces.internal.cluster.node.replica.SpaceCopyReplicaParameters;
import com.gigaspaces.internal.server.space.SpaceEngine;

@InternalApi
public class SpaceReplicaDataProducerBuilder
implements ISpaceReplicaDataProducerBuilder<IExecutableSpaceReplicaData> {
    private final SpaceEngine _engine;

    public SpaceReplicaDataProducerBuilder(SpaceEngine engine) {
        this._engine = engine;
    }

    @Override
    public ISpaceReplicaDataProducer<IExecutableSpaceReplicaData> createProducer(ISpaceCopyReplicaParameters parameters, Object requestContext) {
        SpaceCopyReplicaParameters copyParameters = (SpaceCopyReplicaParameters)parameters;
        switch (copyParameters.getReplicaType()) {
            case SYNCRONIZE: {
                return new SynchronizeReplicaDataProducer(this._engine, copyParameters, requestContext);
            }
            case COPY: {
                return new SpaceCopyReplicaDataProducer(this._engine, copyParameters, requestContext);
            }
            case BROADCAST_NOTIFY_TEMPLATES_COPY: {
                return new SpaceBroadcastNotifyReplicaDataProducer(this._engine, copyParameters, requestContext);
            }
        }
        throw new IllegalArgumentException("Illegal replica type " + (Object)((Object)copyParameters.getReplicaType()));
    }

    public SpaceEngine getSpaceEngine() {
        return this._engine;
    }
}

