/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.replica;

import com.gigaspaces.internal.cluster.node.impl.ReplicationNode;
import com.gigaspaces.internal.cluster.node.impl.replica.SpaceCopyReplicaRunnable;
import com.gigaspaces.internal.cluster.node.impl.replica.SpaceReplicaBatch;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SpaceReplicaFifoBatchesHandler {
    private final ReplicationNode replicationNode;
    private final Logger logger = Logger.getLogger("com.gigaspaces.replication.replica");
    private final TreeMap<Integer, SpaceReplicaBatch> pendingBatches = new TreeMap();
    private int lastProcessed = 0;
    private final Object lock = new Object();

    public SpaceReplicaFifoBatchesHandler(ReplicationNode node) {
        this.replicationNode = node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleIncomingBatch(SpaceReplicaBatch batch, SpaceCopyReplicaRunnable consumer) {
        Object object = this.getLock();
        synchronized (object) {
            this.addBatch(batch);
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine(this.replicationNode.getLogPrefix() + "inserting fifo batch " + batch.getFifoId() + " to queue, fifo state: " + this);
            }
        }
        this.processNextIfPossible(consumer);
    }

    private SpaceReplicaBatch getNextBatchForProcessing() {
        return this.pendingBatches.remove(this.pendingBatches.firstKey());
    }

    private boolean hasNextBatch() {
        return !this.pendingBatches.isEmpty() && this.pendingBatches.firstKey() == this.lastProcessed + 1;
    }

    private Object getLock() {
        return this.lock;
    }

    private void addBatch(SpaceReplicaBatch batch) {
        this.pendingBatches.put(batch.getFifoId(), batch);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onProcessBatchCompletion(int id) {
        Object object = this.getLock();
        synchronized (object) {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine(this.replicationNode.getLogPrefix() + "finished processing fifo batch " + id + ", fifo state: " + this);
            }
            if (id != this.lastProcessed + 1) {
                throw new IllegalStateException("completed processing batch " + id + " but was expecting " + (this.lastProcessed + 1));
            }
            this.lastProcessed = id;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processNextIfPossible(SpaceCopyReplicaRunnable consumer) {
        while (true) {
            boolean process = false;
            SpaceReplicaBatch currentBatch = null;
            Object object = this.getLock();
            synchronized (object) {
                if (this.hasNextBatch()) {
                    currentBatch = this.getNextBatchForProcessing();
                    process = true;
                }
            }
            if (!process) break;
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine(this.replicationNode.getLogPrefix() + "processing fifo batch " + currentBatch.getFifoId() + ", fifo state: " + this);
            }
            consumer.processBatch(currentBatch.getBatch());
            this.onProcessBatchCompletion(currentBatch.getFifoId());
        }
    }

    public String toString() {
        return "SpaceReplicaFifoBatchesHandler{pendingBatches=" + this.pendingBatches.keySet() + ", lastProcessed=" + this.lastProcessed + '}';
    }
}

