/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.replica;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.cluster.node.impl.groups.IReplicationTargetGroup;
import com.gigaspaces.internal.cluster.node.impl.replica.ISpaceCopyIntermediateResult;
import com.gigaspaces.internal.cluster.node.impl.replica.ReplicaNoProgressException;
import com.gigaspaces.internal.cluster.node.impl.replica.SpaceCopyReplicaRunnable;
import com.gigaspaces.internal.cluster.node.impl.replica.SpaceSynchronizeResult;
import com.gigaspaces.internal.cluster.node.impl.router.IReplicationMonitoredConnection;
import com.gigaspaces.internal.cluster.node.replica.ISpaceCopyResult;
import com.gigaspaces.internal.cluster.node.replica.ISpaceSynchronizeReplicaState;
import com.gigaspaces.internal.cluster.node.replica.ISpaceSynchronizeResult;
import com.gigaspaces.internal.cluster.node.replica.SpaceReplicaStage;
import com.gigaspaces.time.SystemTime;
import java.util.Collection;
import java.util.Vector;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import net.jini.space.InternalSpaceException;

@InternalApi
public class SpaceReplicaState
implements ISpaceSynchronizeReplicaState {
    private final IReplicationMonitoredConnection _originConnection;
    private final Lock _lock = new ReentrantLock();
    private final Condition _condition = this._lock.newCondition();
    private final boolean _isSynchronize;
    private final Collection<SpaceCopyReplicaRunnable> _consumers = new Vector<SpaceCopyReplicaRunnable>();
    private final long _progressTimeout;
    private final IReplicationTargetGroup _targetGroup;
    private final String _replicaSourceLookupName;
    private boolean _copyStageDone = false;
    private boolean _synchronizeDone = false;
    private volatile Exception _failureReason;
    private volatile SpaceReplicaStage _stage = SpaceReplicaStage.COPY;
    private volatile ISpaceCopyResult _copyResult;
    private volatile ISpaceSynchronizeResult _syncResult;

    public SpaceReplicaState(IReplicationMonitoredConnection originConnection, boolean isSynchronize, long progressTimeout, IReplicationTargetGroup targetGroup) {
        this._originConnection = originConnection;
        this._isSynchronize = isSynchronize;
        this._progressTimeout = progressTimeout;
        this._replicaSourceLookupName = originConnection.getFinalEndpointLookupName();
        this._targetGroup = targetGroup;
        if (this._isSynchronize && this._targetGroup != null) {
            this._targetGroup.addSynchronizeState(this._replicaSourceLookupName, this);
        }
    }

    @Override
    public ISpaceCopyResult waitForCopyResult() throws InterruptedException {
        try {
            return this.waitForCopyResult(Long.MAX_VALUE, TimeUnit.DAYS);
        }
        catch (TimeoutException e) {
            throw new InternalSpaceException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ISpaceCopyResult waitForCopyResult(long time, TimeUnit unit) throws InterruptedException, TimeoutException {
        this._lock.lock();
        try {
            this.waitForCopyResultHelper(time, unit);
            ISpaceCopyResult iSpaceCopyResult = this.mergedResults();
            return iSpaceCopyResult;
        }
        finally {
            this._lock.unlock();
        }
    }

    private void waitForCopyResultHelper(long time, TimeUnit unit) throws InterruptedException, TimeoutException {
        long lastActiviteTime = -1L;
        long remainingTime = unit.toMillis(time);
        while (!this.isCopyDone()) {
            long lastActiviteTime1 = lastActiviteTime;
            for (SpaceCopyReplicaRunnable consumer1 : this._consumers) {
                lastActiviteTime1 = Math.max(lastActiviteTime1, consumer1.getLastIterationTimeStamp());
            }
            lastActiviteTime = lastActiviteTime1;
            if (SystemTime.timeMillis() - lastActiviteTime > this._progressTimeout) {
                for (SpaceCopyReplicaRunnable consumer : this._consumers) {
                    consumer.abort();
                }
                this._failureReason = new ReplicaNoProgressException("No progress in replica stage for the past " + this._progressTimeout + " milliseconds");
                break;
            }
            long waitTime = Math.min(this._progressTimeout, remainingTime);
            if (this._condition.await(waitTime, TimeUnit.MILLISECONDS) || (remainingTime -= waitTime) > 0L) continue;
            throw new TimeoutException();
        }
    }

    private ISpaceCopyResult mergedResults() {
        if (this._copyResult != null) {
            return this._copyResult;
        }
        ISpaceCopyIntermediateResult mergedResult = null;
        for (SpaceCopyReplicaRunnable consumer : this._consumers) {
            ISpaceCopyIntermediateResult result = consumer.getIntermediateResult();
            if (mergedResult == null) {
                mergedResult = result;
                continue;
            }
            mergedResult = mergedResult.merge(result);
        }
        if (this._failureReason != null) {
            mergedResult = mergedResult.mergeFailure(this._failureReason);
        }
        this._copyResult = mergedResult.toFinalResult();
        return this._copyResult;
    }

    @Override
    public boolean isDone() {
        this._lock.lock();
        try {
            if (this._failureReason != null) {
                boolean bl = true;
                return bl;
            }
            boolean copyDone = this.isCopyDone();
            boolean bl = copyDone && (!this._isSynchronize || this._synchronizeDone);
            return bl;
        }
        finally {
            this._lock.unlock();
        }
    }

    public boolean isFailed() {
        return this._failureReason != null;
    }

    public void updateSynchronizationDone() {
        this._lock.lock();
        try {
            this._synchronizeDone = true;
            this._stage = SpaceReplicaStage.DONE;
            this._condition.signalAll();
        }
        finally {
            this._lock.unlock();
        }
    }

    private boolean isCopyDone() {
        return this._copyStageDone;
    }

    @Override
    public ISpaceSynchronizeResult getSynchronizeResult() {
        return this._syncResult;
    }

    @Override
    public ISpaceSynchronizeResult waitForSynchronizeCompletion() throws InterruptedException {
        try {
            return this.waitForSynchronizeCompletion(Long.MAX_VALUE, TimeUnit.DAYS);
        }
        catch (TimeoutException e) {
            throw new InternalSpaceException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ISpaceSynchronizeResult waitForSynchronizeCompletion(long time, TimeUnit unit) throws InterruptedException, TimeoutException {
        this._lock.lock();
        try {
            if (this._syncResult != null) {
                ISpaceSynchronizeResult iSpaceSynchronizeResult = this._syncResult;
                return iSpaceSynchronizeResult;
            }
            long remainingTime = unit.toMillis(time);
            long copyStageTimeStamp = SystemTime.timeMillis();
            this.waitForCopyResultHelper(time, unit);
            remainingTime -= SystemTime.timeMillis() - copyStageTimeStamp;
            long lastProgressTimeStamp = SystemTime.timeMillis();
            while (!this.isDone()) {
                lastProgressTimeStamp = Math.max(this._targetGroup.getLastProcessTimeStamp(this._replicaSourceLookupName), lastProgressTimeStamp);
                if (SystemTime.timeMillis() - lastProgressTimeStamp > this._progressTimeout) {
                    this._failureReason = new ReplicaNoProgressException("No progress in synchronize stage for the past " + this._progressTimeout + " milliseconds");
                    break;
                }
                long waitTime = Math.min(this._progressTimeout, remainingTime);
                if (this._condition.await(waitTime, TimeUnit.MILLISECONDS) || (remainingTime -= waitTime) > 0L) continue;
                throw new TimeoutException();
            }
            ISpaceSynchronizeResult iSpaceSynchronizeResult = this._syncResult = new SpaceSynchronizeResult(this._failureReason);
            return iSpaceSynchronizeResult;
        }
        finally {
            this._lock.unlock();
        }
    }

    @Override
    public SpaceReplicaStage getStage() {
        return this._stage;
    }

    @Override
    public ISpaceCopyResult getCopyResult() {
        this._lock.lock();
        try {
            ISpaceCopyResult iSpaceCopyResult = this._copyResult;
            return iSpaceCopyResult;
        }
        finally {
            this._lock.unlock();
        }
    }

    public void addReplicateConsumer(SpaceCopyReplicaRunnable consumer) {
        this._consumers.add(consumer);
    }

    @Override
    public void abort(long timeout, TimeUnit units) throws InterruptedException, TimeoutException {
        for (SpaceCopyReplicaRunnable consumer : this._consumers) {
            consumer.abort();
        }
        this.waitForCopyResult(timeout, units);
    }

    public void signalEntireCopyStageDoneSucessfully() {
        this._lock.lock();
        try {
            this._copyStageDone = true;
            this.stopAllConsumers();
            this._stage = this._isSynchronize ? SpaceReplicaStage.SYNCHRONIZING : SpaceReplicaStage.DONE;
            this._condition.signalAll();
            this._originConnection.close();
        }
        finally {
            this._lock.unlock();
        }
    }

    public void signalSingleCopyStageDone() {
        this._lock.lock();
        try {
            for (SpaceCopyReplicaRunnable consumer : this._consumers) {
                consumer.getHandler().resumeNow();
            }
        }
        finally {
            this._lock.unlock();
        }
    }

    public void signalCopyStageFailed(Exception error) {
        this._lock.lock();
        try {
            if (this._failureReason != null) {
                return;
            }
            this._failureReason = error;
            this._copyStageDone = true;
            this.stopAllConsumers();
            this._condition.signalAll();
            this._originConnection.close();
        }
        finally {
            this._lock.unlock();
        }
    }

    private void stopAllConsumers() {
        for (SpaceCopyReplicaRunnable consumer : this._consumers) {
            consumer.getHandler().stop(3L, TimeUnit.SECONDS);
        }
    }
}

