/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.replica;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.cluster.node.impl.replica.ISingleStageReplicaDataProducer;
import com.gigaspaces.internal.cluster.node.impl.replica.ISynchronizationCallback;
import com.gigaspaces.internal.cluster.node.impl.replica.data.SpaceTypeReplicaData;
import com.gigaspaces.internal.metadata.ITypeDesc;
import com.gigaspaces.internal.server.metadata.IServerTypeDesc;
import com.gigaspaces.internal.server.space.SpaceEngine;
import com.gigaspaces.internal.server.space.metadata.SpaceTypeManager;
import com.j_spaces.core.cluster.IReplicationFilterEntry;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

@InternalApi
public class SpaceTypeReplicaDataProducer
implements ISingleStageReplicaDataProducer<SpaceTypeReplicaData> {
    private final SpaceTypeManager _typeManager;
    private final Iterator<IServerTypeDesc> _typesIterator;
    private boolean _isClosed;
    private List<String> _generatedTypes = new LinkedList<String>();

    public SpaceTypeReplicaDataProducer(SpaceEngine engine) {
        this._typeManager = engine.getTypeManager();
        Collection<IServerTypeDesc> types = this._typeManager.getSafeTypeTable().values();
        this._typesIterator = types.iterator();
    }

    @Override
    public ISingleStageReplicaDataProducer.CloseStatus close(boolean forced) {
        this._isClosed = true;
        return ISingleStageReplicaDataProducer.CloseStatus.CLOSED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SpaceTypeReplicaData produceNextData(ISynchronizationCallback synchCallback) {
        if (this._isClosed) {
            return null;
        }
        Object object = this._typeManager.getTypeDescLock();
        synchronized (object) {
            if (this._typesIterator.hasNext()) {
                ITypeDesc typeDesc = this._typesIterator.next().getTypeDesc();
                SpaceTypeReplicaData spaceTypeReplicaData = new SpaceTypeReplicaData(typeDesc);
                synchCallback.synchronizationDataGenerated(spaceTypeReplicaData);
                this._generatedTypes.add(typeDesc.getTypeName());
                return spaceTypeReplicaData;
            }
        }
        this.close(false);
        return null;
    }

    @Override
    public IReplicationFilterEntry toFilterEntry(SpaceTypeReplicaData data) {
        return null;
    }

    @Override
    public String dumpState() {
        return "Types replica producer: completed [" + this._isClosed + "] generated types [" + this._generatedTypes + "]";
    }

    @Override
    public String getName() {
        return "SpaceTypeReplicaDataProducer";
    }
}

