/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.replica;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.cluster.node.impl.replica.AbstractMultiSpaceReplicaDataProducer;
import com.gigaspaces.internal.cluster.node.impl.replica.DirectPersisntecyEntryReplicaProducer;
import com.gigaspaces.internal.cluster.node.impl.replica.EntryReplicaProducer;
import com.gigaspaces.internal.cluster.node.impl.replica.IExecutableSpaceReplicaData;
import com.gigaspaces.internal.cluster.node.impl.replica.ISingleStageReplicaDataProducer;
import com.gigaspaces.internal.cluster.node.impl.replica.NotifyTemplateReplicaProducer;
import com.gigaspaces.internal.cluster.node.impl.replica.SpaceTypeReplicaDataProducer;
import com.gigaspaces.internal.cluster.node.replica.SpaceCopyReplicaParameters;
import com.gigaspaces.internal.server.space.SpaceEngine;
import com.gigaspaces.internal.transport.ITemplatePacket;
import com.j_spaces.core.cluster.IReplicationFilterEntry;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;

@InternalApi
public class SynchronizeReplicaDataProducer
extends AbstractMultiSpaceReplicaDataProducer {
    public SynchronizeReplicaDataProducer(SpaceEngine engine, SpaceCopyReplicaParameters parameters, Object requestContext) {
        super(engine, parameters, requestContext);
    }

    @Override
    protected List<ISingleStageReplicaDataProducer<? extends IExecutableSpaceReplicaData>> buildDataProducers(SpaceCopyReplicaParameters parameters) {
        ArrayList<ISingleStageReplicaDataProducer<? extends IExecutableSpaceReplicaData>> dataProducers = new ArrayList<ISingleStageReplicaDataProducer<? extends IExecutableSpaceReplicaData>>();
        dataProducers.add(new SpaceTypeReplicaDataProducer(this._engine));
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest(this._engine.getReplicationNode() + "created SpaceTypeReplicaDataProducer");
        }
        for (ITemplatePacket templatePacket : parameters.getTemplatePackets()) {
            if (parameters.getSynchronizationListFetcher() != null) {
                dataProducers.add(new DirectPersisntecyEntryReplicaProducer(this._engine, parameters, templatePacket, this._requestContext));
            } else {
                dataProducers.add(new EntryReplicaProducer(this._engine, parameters, templatePacket, this._requestContext));
            }
            if (!_logger.isLoggable(Level.FINEST)) continue;
            _logger.finest(this._engine.getReplicationNode() + "created EntryReplicaProducer for templatePacket " + templatePacket);
        }
        if (parameters.isCopyNotifyTemplates()) {
            dataProducers.add(new NotifyTemplateReplicaProducer(this._engine, this._requestContext));
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest(this._engine.getReplicationNode() + "created NotifyTemplateReplicaProducer");
            }
        }
        return dataProducers;
    }

    @Override
    public void onClose() {
        try {
            if (!this._engine.getLeaseManager().isCurrentLeaseReaperThread()) {
                if (this._engine.getCacheManager().isBlobStoreCachePolicy()) {
                    long forceLeaseReaperCycleTimeToWait = Long.getLong("com.gs.leaseManager.forceReaperCycleTimeToWait", 60000L);
                    this._engine.getLeaseManager().forceLeaseReaperCycle(true, forceLeaseReaperCycleTimeToWait);
                } else {
                    this._engine.getLeaseManager().forceLeaseReaperCycle(true);
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public IReplicationFilterEntry toFilterEntry(IExecutableSpaceReplicaData data) {
        return data.toFilterEntry(this._engine.getTypeManager());
    }

    @Override
    public String getName() {
        return "SynchronizeReplicaDataProducer";
    }
}

