/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.replica.data;

import com.gigaspaces.internal.cluster.node.impl.IIncomingReplicationFacade;
import com.gigaspaces.internal.cluster.node.impl.backlog.sync.IMarker;
import com.gigaspaces.internal.cluster.node.impl.replica.ISpaceReplicaConsumeFacade;
import com.gigaspaces.internal.cluster.node.impl.replica.SpaceCopyIntermediateResult;
import com.gigaspaces.internal.cluster.node.impl.replica.data.AbstractReplicaData;
import com.gigaspaces.internal.cluster.node.impl.replica.data.filters.ReplicationFilterEntryReplicaDataWrapper;
import com.gigaspaces.internal.cluster.node.replica.SpaceCopyReplicaParameters;
import com.gigaspaces.internal.io.IOUtils;
import com.gigaspaces.internal.metadata.ITypeDesc;
import com.gigaspaces.internal.server.space.metadata.SpaceTypeManager;
import com.gigaspaces.internal.transport.IEntryPacket;
import com.j_spaces.core.client.EntryAlreadyInSpaceException;
import com.j_spaces.core.cluster.IReplicationFilterEntry;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public abstract class AbstractEntryReplicaData
extends AbstractReplicaData {
    private static final long serialVersionUID = 1L;
    private IEntryPacket _entryPacket;

    public AbstractEntryReplicaData() {
    }

    public AbstractEntryReplicaData(IEntryPacket entryPacket) {
        this._entryPacket = entryPacket;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        IOUtils.writeObject(out, this._entryPacket);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this._entryPacket = (IEntryPacket)IOUtils.readObject(in);
    }

    @Override
    public String getUid() {
        return this._entryPacket.getUID();
    }

    public IEntryPacket getEntryPacket() {
        return this._entryPacket;
    }

    public void setEntryPacket(IEntryPacket _entryPacket) {
        this._entryPacket = _entryPacket;
    }

    @Override
    public void execute(ISpaceReplicaConsumeFacade consumeFacade, SpaceCopyIntermediateResult intermediateResult, IIncomingReplicationFacade incomingReplicationFacade) throws Exception {
        try {
            consumeFacade.write(this._entryPacket, this.getMarker(incomingReplicationFacade), this.getReplicaType());
            intermediateResult.increaseWritenTypeCount(this._entryPacket.getTypeName());
        }
        catch (EntryAlreadyInSpaceException e) {
            intermediateResult.addDuplicateEntry(this._entryPacket.getUID(), this._entryPacket.getTypeName());
        }
    }

    protected abstract IMarker getMarker(IIncomingReplicationFacade var1);

    @Override
    public boolean supportsReplicationFilter() {
        return true;
    }

    @Override
    public IReplicationFilterEntry toFilterEntry(SpaceTypeManager typeManager) {
        ITypeDesc typeDesc = this.getTypeDescriptor(typeManager, this.getEntryPacket());
        return new ReplicationFilterEntryReplicaDataWrapper(this.getEntryPacket(), typeDesc);
    }

    public abstract SpaceCopyReplicaParameters.ReplicaType getReplicaType();

    public String toString() {
        return "EntryReplicaData " + this._entryPacket;
    }

    @Override
    public boolean isEntryReplicaData() {
        return true;
    }
}

