/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.replica.data;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.cluster.node.impl.IIncomingReplicationFacade;
import com.gigaspaces.internal.cluster.node.impl.backlog.sync.IMarker;
import com.gigaspaces.internal.cluster.node.impl.replica.ISpaceReplicaConsumeFacade;
import com.gigaspaces.internal.cluster.node.impl.replica.SpaceCopyIntermediateResult;
import com.gigaspaces.internal.cluster.node.impl.replica.data.AbstractEntryReplicaData;
import com.gigaspaces.internal.cluster.node.replica.SpaceCopyReplicaParameters;
import com.gigaspaces.internal.transport.IEntryPacket;
import com.j_spaces.core.client.EntryAlreadyInSpaceException;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

@InternalApi
public class DirectPersistencyEntryReplicaData
extends AbstractEntryReplicaData {
    private static final long serialVersionUID = 1L;
    private String _uid;

    public DirectPersistencyEntryReplicaData() {
    }

    public DirectPersistencyEntryReplicaData(String uid) {
        this._uid = uid;
        this.markEntryAsNotExists();
    }

    public DirectPersistencyEntryReplicaData(IEntryPacket entryPacket) {
        super(entryPacket);
        this._uid = entryPacket.getUID();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeUTF(this._uid);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this._uid = in.readUTF();
    }

    public void markEntryAsNotExists() {
        this.setEntryPacket(null);
    }

    @Override
    public SpaceCopyReplicaParameters.ReplicaType getReplicaType() {
        return SpaceCopyReplicaParameters.ReplicaType.SYNCRONIZE;
    }

    @Override
    public String getUid() {
        return this._uid;
    }

    @Override
    public void execute(ISpaceReplicaConsumeFacade consumeFacade, SpaceCopyIntermediateResult intermediateResult, IIncomingReplicationFacade incomingReplicationFacade) throws Exception {
        try {
            if (this.getEntryPacket() != null) {
                consumeFacade.write(this.getEntryPacket(), this.getMarker(incomingReplicationFacade), this.getReplicaType());
                intermediateResult.increaseWritenTypeCount(this.getEntryPacket().getTypeName());
            } else {
                consumeFacade.remove(this._uid, this.getMarker(incomingReplicationFacade), this.getReplicaType());
            }
        }
        catch (EntryAlreadyInSpaceException e) {
            intermediateResult.addDuplicateEntry(this.getEntryPacket().getUID(), this.getEntryPacket().getTypeName());
        }
    }

    @Override
    protected IMarker getMarker(IIncomingReplicationFacade incomingReplicationFacade) {
        return null;
    }

    @Override
    public String toString() {
        if (this.getEntryPacket() != null) {
            return super.toString();
        }
        return "EntryReplicaData " + this._uid;
    }
}

