/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.replica.data;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.cluster.node.impl.IIncomingReplicationFacade;
import com.gigaspaces.internal.cluster.node.impl.backlog.sync.IMarker;
import com.gigaspaces.internal.cluster.node.impl.backlog.sync.IMarkerWireForm;
import com.gigaspaces.internal.cluster.node.impl.groups.IReplicationSourceGroup;
import com.gigaspaces.internal.cluster.node.impl.replica.data.AbstractEntryReplicaData;
import com.gigaspaces.internal.cluster.node.replica.SpaceCopyReplicaParameters;
import com.gigaspaces.internal.io.IOUtils;
import com.gigaspaces.internal.transport.IEntryPacket;
import com.gigaspaces.internal.version.PlatformLogicalVersion;
import com.gigaspaces.lrmi.LRMIInvocationContext;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

@InternalApi
public class EntrySynchronizeReplicaData
extends AbstractEntryReplicaData {
    private static final long serialVersionUID = 1L;
    private transient IMarker _marker;
    private IMarkerWireForm _markerWireForm;

    public EntrySynchronizeReplicaData() {
    }

    public EntrySynchronizeReplicaData(IEntryPacket entryPacket, IMarker marker) {
        super(entryPacket);
        this._marker = marker;
    }

    @Override
    public SpaceCopyReplicaParameters.ReplicaType getReplicaType() {
        return SpaceCopyReplicaParameters.ReplicaType.SYNCRONIZE;
    }

    @Override
    protected IMarker getMarker(IIncomingReplicationFacade incomingReplicationFacade) {
        if (this._markerWireForm == null) {
            return null;
        }
        String groupName = this._markerWireForm.getGroupName();
        IReplicationSourceGroup sourceGroup = incomingReplicationFacade.getReplicationSourceGroup(groupName);
        return this._markerWireForm.toFinalizedForm(sourceGroup.getGroupBacklog());
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        if (LRMIInvocationContext.getEndpointLogicalVersion().greaterOrEquals(PlatformLogicalVersion.v9_1_0)) {
            IMarkerWireForm markerWireForm = this._marker != null ? this._marker.toWireForm() : null;
            IOUtils.writeObject(out, markerWireForm);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        if (LRMIInvocationContext.getEndpointLogicalVersion().greaterOrEquals(PlatformLogicalVersion.v9_1_0)) {
            this._markerWireForm = (IMarkerWireForm)IOUtils.readObject(in);
        }
    }

    @Override
    public String toString() {
        String markerStr = null;
        if (this._marker != null) {
            markerStr = this._marker.toString();
        } else if (this._markerWireForm != null) {
            markerStr = this._markerWireForm.toString();
        }
        return super.toString() + (markerStr != null ? " " + markerStr : "");
    }
}

