/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.replica.data;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.events.GSEventRegistration;
import com.gigaspaces.events.NotifyInfo;
import com.gigaspaces.internal.cluster.node.impl.IIncomingReplicationFacade;
import com.gigaspaces.internal.cluster.node.impl.replica.ISpaceReplicaConsumeFacade;
import com.gigaspaces.internal.cluster.node.impl.replica.SpaceCopyIntermediateResult;
import com.gigaspaces.internal.cluster.node.impl.replica.data.AbstractReplicaData;
import com.gigaspaces.internal.cluster.node.impl.replica.data.filters.NotifyReplicationFilterReplicaDataWrapper;
import com.gigaspaces.internal.io.IOUtils;
import com.gigaspaces.internal.metadata.ITypeDesc;
import com.gigaspaces.internal.server.space.metadata.SpaceTypeManager;
import com.gigaspaces.internal.transport.ITemplatePacket;
import com.j_spaces.core.cluster.IReplicationFilterEntry;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

@InternalApi
public class NotifyTemplateReplicaData
extends AbstractReplicaData {
    private static final long serialVersionUID = 1L;
    private ITemplatePacket _templatePacket;
    private NotifyInfo _notifyInfo;
    private String _templateUid;
    private int _objectType;

    public NotifyTemplateReplicaData() {
    }

    public NotifyTemplateReplicaData(ITemplatePacket templatePacket, String templateUid, NotifyInfo notifyInfo, int objectType) {
        this._templatePacket = templatePacket;
        this._templateUid = templateUid;
        this._notifyInfo = notifyInfo;
        this._objectType = objectType;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        IOUtils.writeObject(out, this._templatePacket);
        IOUtils.writeString(out, this._templateUid);
        IOUtils.writeObject(out, this._notifyInfo);
        out.writeInt(this._objectType);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this._templatePacket = (ITemplatePacket)IOUtils.readObject(in);
        this._templateUid = IOUtils.readString(in);
        this._notifyInfo = (NotifyInfo)IOUtils.readObject(in);
        this._objectType = in.readInt();
    }

    @Override
    public String getUid() {
        return this._templateUid;
    }

    @Override
    public void execute(ISpaceReplicaConsumeFacade consumeFacade, SpaceCopyIntermediateResult intermediateResult, IIncomingReplicationFacade incomingReplicationFacade) throws Exception {
        GSEventRegistration eventRegistration = consumeFacade.insertNotifyTemplate(this._templatePacket, this._templateUid, this._notifyInfo);
        intermediateResult.addRegisteredNotifyTemplate(this._templatePacket.getTypeName(), eventRegistration);
    }

    @Override
    public boolean supportsReplicationFilter() {
        return true;
    }

    @Override
    public boolean isEntryReplicaData() {
        return false;
    }

    @Override
    public IReplicationFilterEntry toFilterEntry(SpaceTypeManager typeManager) {
        ITypeDesc typeDesc = this.getTypeDescriptor(typeManager, this._templatePacket);
        return new NotifyReplicationFilterReplicaDataWrapper(this._templatePacket, this._notifyInfo, this._objectType, typeDesc);
    }

    public String toString() {
        return "NotifyTemplateReplicaData, templateUid [" + this._templateUid + "] " + this._templatePacket;
    }
}

