/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.router;

import com.gigaspaces.async.AsyncFuture;
import com.gigaspaces.internal.cluster.node.impl.IServiceExporter;
import com.gigaspaces.internal.cluster.node.impl.ReplicationLogUtils;
import com.gigaspaces.internal.cluster.node.impl.packets.PingPacket;
import com.gigaspaces.internal.cluster.node.impl.router.AbstractProxyBasedReplicationMonitoredConnection;
import com.gigaspaces.internal.cluster.node.impl.router.AbstractReplicationPacket;
import com.gigaspaces.internal.cluster.node.impl.router.CallbackVerifier;
import com.gigaspaces.internal.cluster.node.impl.router.ConnectionState;
import com.gigaspaces.internal.cluster.node.impl.router.DirectConnectionScheduledPoolConnectionMonitor;
import com.gigaspaces.internal.cluster.node.impl.router.IAsyncContextProvider;
import com.gigaspaces.internal.cluster.node.impl.router.IIncomingReplicationHandler;
import com.gigaspaces.internal.cluster.node.impl.router.IReplicationMonitoredConnection;
import com.gigaspaces.internal.cluster.node.impl.router.IReplicationRouter;
import com.gigaspaces.internal.cluster.node.impl.router.IReplicationRouterAdmin;
import com.gigaspaces.internal.cluster.node.impl.router.MemberProxyBasedReplicationMonitoredConnection;
import com.gigaspaces.internal.cluster.node.impl.router.ReplicationEndpointDetails;
import com.gigaspaces.internal.cluster.node.impl.router.RouterStubHolder;
import com.gigaspaces.internal.cluster.node.impl.router.StubBasedReplicationMonitoredConnection;
import com.gigaspaces.internal.cluster.node.impl.router.UrlProxyBasedReplicationMonitoredConnection;
import com.gigaspaces.internal.cluster.node.impl.router.spacefinder.ConnectionReference;
import com.gigaspaces.internal.cluster.node.impl.router.spacefinder.IConnectionMonitor;
import com.gigaspaces.internal.cluster.node.impl.router.spacefinder.IReplicationConnectionProxy;
import com.gigaspaces.internal.utils.StringUtils;
import com.gigaspaces.lrmi.ILRMIService;
import com.j_spaces.core.exception.ClosedResourceException;
import java.rmi.RemoteException;
import java.rmi.server.ExportException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.id.Uuid;

public abstract class AbstractConnectionProxyBasedReplicationRouter<T, L>
implements IReplicationRouter,
IReplicationRouterAdmin {
    protected final Logger _specificLogger;
    private final String _myLookupName;
    private final Map<String, AbstractProxyBasedReplicationMonitoredConnection<T, L>> _connections;
    private final Map<String, RouterStubHolder> _directStubs;
    private final IConnectionMonitor<T, L> _connectionMonitor;
    private final IConnectionMonitor<IReplicationConnectionProxy, Object> _directConnectionMonitor;
    private final IServiceExporter _serviceExporter;
    private final Uuid _uuid;
    private final IIncomingReplicationHandler _incomingReplicationHandler;
    private final ConnectionEndpoint _connectionEndPoint;
    private final IAsyncContextProvider _asyncContextProvider;
    private final boolean _setMyIdBeforeDispatch;
    private final ReplicationEndpointDetails _myReplicationEndpointDetails;
    private final IReplicationConnectionProxy _stub;
    private boolean _incommingCommunicationEnabled;
    private boolean _closed;

    protected AbstractConnectionProxyBasedReplicationRouter(String myLookupName, Uuid uuid, IConnectionMonitor<T, L> connectionMonitor, IServiceExporter serviceExporter, IIncomingReplicationHandler incomingReplicationHandler, IAsyncContextProvider asyncContextProvider, boolean setMyIdBeforeDispatch, int replicationMonitorThreadPoolSize) {
        this._myLookupName = myLookupName;
        this._uuid = uuid;
        this._connectionMonitor = connectionMonitor;
        this._serviceExporter = serviceExporter;
        this._incomingReplicationHandler = incomingReplicationHandler;
        this._asyncContextProvider = asyncContextProvider;
        this._setMyIdBeforeDispatch = setMyIdBeforeDispatch;
        this._connections = new HashMap<String, AbstractProxyBasedReplicationMonitoredConnection<T, L>>();
        this._directStubs = new HashMap<String, RouterStubHolder>();
        this._connectionEndPoint = new ConnectionEndpoint();
        this._specificLogger = Logger.getLogger("com.gigaspaces.replication.router." + ReplicationLogUtils.toShortLookupName(this._myLookupName));
        this._directConnectionMonitor = new DirectConnectionScheduledPoolConnectionMonitor(this._myLookupName, replicationMonitorThreadPoolSize, 3L, 1L, TimeUnit.SECONDS);
        this._stub = this.createStub();
        this._myReplicationEndpointDetails = ReplicationEndpointDetails.createMyEndpointDetails(this._myLookupName, this._uuid);
    }

    protected AbstractConnectionProxyBasedReplicationRouter(String myLookupName, Uuid uuid, IConnectionMonitor<T, L> connectionMonitor, IServiceExporter serviceExporter, IIncomingReplicationHandler incomingReplicationHandler, IAsyncContextProvider asyncContextProvider, boolean setMyIdBeforeDispatch) {
        this(myLookupName, uuid, connectionMonitor, serviceExporter, incomingReplicationHandler, asyncContextProvider, setMyIdBeforeDispatch, 4);
    }

    @Override
    public IReplicationMonitoredConnection getMemberConnection(String lookupName) {
        return this.getMemberConnection(lookupName, true);
    }

    @Override
    public IReplicationMonitoredConnection getMemberConnectionAsync(String lookupName) {
        return this.getMemberConnection(lookupName, false);
    }

    private synchronized IReplicationMonitoredConnection getMemberConnection(String lookupName, boolean connectSynchronously) {
        if (this.isClosed()) {
            throw new ClosedResourceException("Replication Router [" + this.getMyLookupName() + "] is closed");
        }
        AbstractProxyBasedReplicationMonitoredConnection<T, L> connection = this._connections.get(lookupName);
        if (connection != null) {
            return new ConnectionReference<T, L>(connection);
        }
        if (this._directStubs.containsKey(lookupName)) {
            return this.createDirectConnection(lookupName, connectSynchronously);
        }
        if (this._specificLogger.isLoggable(Level.FINE)) {
            this._specificLogger.fine("creating new member connection to [" + lookupName + "], connect synchronously [" + connectSynchronously + "]");
        }
        connection = this.createNewMemberConnection(lookupName, connectSynchronously);
        this._connections.put(lookupName, connection);
        return new ConnectionReference<T, L>(connection);
    }

    protected IReplicationMonitoredConnection createDirectConnection(String lookupName, boolean connectSynchronously) {
        if (this._specificLogger.isLoggable(Level.FINE)) {
            this._specificLogger.fine("creating new direct connection to [" + lookupName + "], connect synchronously [" + connectSynchronously + "]");
        }
        RouterStubHolder routerStubHolder = this._directStubs.get(lookupName);
        AbstractProxyBasedReplicationMonitoredConnection<IReplicationConnectionProxy, Object> directConnection = this.wrapDirectStubWithMonitoredConnection(connectSynchronously, routerStubHolder);
        return new ConnectionReference<IReplicationConnectionProxy, Object>(directConnection);
    }

    protected AbstractProxyBasedReplicationMonitoredConnection<IReplicationConnectionProxy, Object> wrapDirectStubWithMonitoredConnection(boolean connectSynchronously, RouterStubHolder routerStubHolder) {
        String lookupName = routerStubHolder.getMyEndpointDetails().getLookupName();
        IReplicationConnectionProxy stub = (IReplicationConnectionProxy)routerStubHolder.getStub();
        ConnectionState state = ConnectionState.DISCONNECTED;
        RemoteException disconnectedReason = new RemoteException("Connection not established yet");
        if (connectSynchronously) {
            try {
                this.pingStub(stub);
                state = ConnectionState.CONNECTED;
                disconnectedReason = null;
            }
            catch (RemoteException e) {
                disconnectedReason = e;
            }
        }
        StubBasedReplicationMonitoredConnection directConnection = new StubBasedReplicationMonitoredConnection(this, lookupName, stub, this._directConnectionMonitor, state, disconnectedReason, (Uuid)routerStubHolder.getMyEndpointDetails().getUniqueId(), this._asyncContextProvider);
        return directConnection;
    }

    protected abstract AbstractProxyBasedReplicationMonitoredConnection<T, L> createNewMemberConnection(String var1, boolean var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addRemoteRouterStub(RouterStubHolder routerStubHolder) {
        this.pingIfPossible(routerStubHolder);
        AbstractConnectionProxyBasedReplicationRouter abstractConnectionProxyBasedReplicationRouter = this;
        synchronized (abstractConnectionProxyBasedReplicationRouter) {
            this._directStubs.put(routerStubHolder.getMyEndpointDetails().getLookupName(), routerStubHolder);
        }
    }

    private void pingIfPossible(RouterStubHolder routerStubHolder) {
        if (routerStubHolder.getStub() instanceof CallbackVerifier) {
            if (this._specificLogger.isLoggable(Level.FINER)) {
                this._specificLogger.finer("Verifying connection using a remote stub " + routerStubHolder.toString());
            }
            try {
                ((CallbackVerifier)((Object)routerStubHolder.getStub())).verify();
            }
            catch (RemoteException e) {
                throw new RuntimeException("Failure verifying connection using a remote stub " + routerStubHolder.toString(), e);
            }
        }
    }

    @Override
    public synchronized void removeRemoteStubHolder(String routerLookupName) {
        this._directStubs.remove(routerLookupName);
    }

    @Override
    public IReplicationMonitoredConnection getDirectConnection(RouterStubHolder remoteStubHolder) {
        AbstractProxyBasedReplicationMonitoredConnection<IReplicationConnectionProxy, Object> directConnection = this.wrapDirectStubWithMonitoredConnection(true, remoteStubHolder);
        return new ConnectionReference<IReplicationConnectionProxy, Object>(directConnection);
    }

    @Override
    public synchronized void close() {
        if (this._closed) {
            return;
        }
        if (this._specificLogger.isLoggable(Level.FINER)) {
            this._specificLogger.finer("closing replication router");
        }
        if (this._specificLogger.isLoggable(Level.FINEST)) {
            this._specificLogger.finest("unexporting stub");
        }
        this._serviceExporter.unexport(this._connectionEndPoint);
        if (this._specificLogger.isLoggable(Level.FINEST)) {
            this._specificLogger.finest("closing connection monitor");
        }
        this.getConnectionMonitor().close();
        if (this._specificLogger.isLoggable(Level.FINEST)) {
            this._specificLogger.finest("closing direct connection monitor");
        }
        this._directConnectionMonitor.close();
        ClosedResourceException reason = new ClosedResourceException("Replication Router [" + this.getMyLookupName() + "] is closed");
        if (this._specificLogger.isLoggable(Level.FINEST)) {
            this._specificLogger.finest("disconnecting connections");
        }
        for (AbstractProxyBasedReplicationMonitoredConnection<T, L> connection : this._connections.values()) {
            connection.setDisconnected(reason);
        }
        this._connections.clear();
        this._closed = true;
        if (this._specificLogger.isLoggable(Level.FINER)) {
            this._specificLogger.finer("replication router closed");
        }
    }

    @Override
    public String getMyLookupName() {
        return this._myLookupName;
    }

    public Uuid getMyUniqueId() {
        return this._uuid;
    }

    public boolean isSetMyIdBeforeDispatch() {
        return this._setMyIdBeforeDispatch;
    }

    @Override
    public RouterStubHolder getMyStubHolder() {
        return new RouterStubHolder(this.getStub(), this.getMyEndpointDetails());
    }

    @Override
    public ReplicationEndpointDetails getMyEndpointDetails() {
        return this._myReplicationEndpointDetails;
    }

    @Override
    public synchronized String dumpState() {
        StringBuilder dump = new StringBuilder("UniqueId [" + this.getMyUniqueId() + "]");
        dump.append(StringUtils.NEW_LINE);
        for (AbstractProxyBasedReplicationMonitoredConnection<T, L> abstractProxyBasedReplicationMonitoredConnection : this._connections.values()) {
            dump.append(abstractProxyBasedReplicationMonitoredConnection.dumpState());
            dump.append(StringUtils.NEW_LINE);
        }
        dump.append("Direct Stubs:");
        dump.append(StringUtils.NEW_LINE);
        for (Map.Entry entry : this._directStubs.entrySet()) {
            dump.append("Id [");
            dump.append((String)entry.getKey());
            dump.append("Id ]");
            dump.append(StringUtils.NEW_LINE);
            dump.append(entry.getValue());
            dump.append(StringUtils.NEW_LINE);
        }
        dump.append("Connection Monitor: " + StringUtils.NEW_LINE + this.getConnectionMonitor().dumpState());
        dump.append("Direct connection Monitor: " + StringUtils.NEW_LINE + this._directConnectionMonitor.dumpState());
        return dump.toString();
    }

    public void pingStub(IReplicationConnectionProxy proxy) throws RemoteException {
        PingPacket packet = new PingPacket();
        packet.setSourceEndpointDetails(this.getMyEndpointDetails());
        Object result = proxy.dispatchAsync(packet);
        AsyncFuture<Object> future = this._asyncContextProvider.getFutureContext(result, proxy);
        try {
            future.get(30L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new RemoteException(e.getMessage(), e);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof RemoteException) {
                throw (RemoteException)e.getCause();
            }
            if (this._specificLogger.isLoggable(Level.FINER)) {
                this._specificLogger.finer("pinging of stub has failed [" + e.getCause() + "], considering it as failure");
            }
            throw new RemoteException(e.getMessage(), e.getCause());
        }
        catch (TimeoutException e) {
            if (this._specificLogger.isLoggable(Level.FINER)) {
                this._specificLogger.finer("pinging of stub has timed out, considering it as failure");
            }
            throw new RemoteException(e.getMessage(), e);
        }
    }

    public IReplicationConnectionProxy createStub() {
        try {
            return this._serviceExporter.export(this._connectionEndPoint);
        }
        catch (ExportException e) {
            throw new RuntimeException("Failed to export replication router stub", e);
        }
    }

    public IReplicationConnectionProxy getStub() {
        return this._stub;
    }

    public synchronized boolean isClosed() {
        return this._closed;
    }

    public synchronized void removeUrlConnection(UrlProxyBasedReplicationMonitoredConnection<T, L> connection) {
        this.getConnectionMonitor().stopMonitoring(connection);
    }

    public synchronized void removeMemberConnection(MemberProxyBasedReplicationMonitoredConnection<T, L> connection) {
        this._connections.remove(connection.getTargetLookupName());
        this.getConnectionMonitor().stopMonitoring(connection);
    }

    public synchronized void removeDirectConnection(StubBasedReplicationMonitoredConnection connection) {
        this._directConnectionMonitor.stopMonitoring(connection);
    }

    protected IConnectionMonitor<T, L> getConnectionMonitor() {
        return this._connectionMonitor;
    }

    public IAsyncContextProvider getAsyncContextProvider() {
        return this._asyncContextProvider;
    }

    public synchronized boolean hasExistingConnection(String lookupName) {
        return this._connections.containsKey(lookupName);
    }

    @Override
    public IReplicationRouterAdmin getAdmin() {
        return this;
    }

    @Override
    public RouterStubHolder getMyRouterStubHolder() {
        return this.getMyStubHolder();
    }

    @Override
    public synchronized RouterStubHolder getRemoteRouterStub(String routerLookupName) {
        return this._directStubs.get(routerLookupName);
    }

    @Override
    public synchronized void enableIncomingCommunication() {
        if (this._specificLogger.isLoggable(Level.FINER)) {
            this._specificLogger.finer("Incoming communication enabled");
        }
        this._incommingCommunicationEnabled = true;
    }

    public class ConnectionEndpoint
    implements IReplicationConnectionProxy,
    ILRMIService,
    CallbackVerifier {
        public <TR> TR dispatch(AbstractReplicationPacket<TR> packet) throws RemoteException {
            if (!AbstractConnectionProxyBasedReplicationRouter.this._incommingCommunicationEnabled) {
                throw new RemoteException("Incoming communication is not enabled");
            }
            return AbstractConnectionProxyBasedReplicationRouter.this._incomingReplicationHandler.onReplication(packet);
        }

        public <TR> TR dispatchAsync(AbstractReplicationPacket<TR> packet) throws RemoteException {
            if (!AbstractConnectionProxyBasedReplicationRouter.this._incommingCommunicationEnabled) {
                throw new RemoteException("Incoming communication is not enabled");
            }
            return AbstractConnectionProxyBasedReplicationRouter.this._incomingReplicationHandler.onReplication(packet);
        }

        @Override
        public void close() throws RemoteException {
        }

        @Override
        public String getServiceName() {
            return AbstractConnectionProxyBasedReplicationRouter.this._myLookupName;
        }

        @Override
        public void verify() throws RemoteException {
        }
    }
}

