/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.router;

import com.gigaspaces.internal.cluster.node.impl.IIncomingReplicationFacade;
import com.gigaspaces.internal.cluster.node.impl.groups.IReplicationTargetGroup;
import com.gigaspaces.internal.cluster.node.impl.router.AbstractReplicationPacket;
import com.gigaspaces.internal.io.IOUtils;
import com.gigaspaces.internal.utils.Textualizer;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public abstract class AbstractGroupNameReplicationPacket<T>
extends AbstractReplicationPacket<T> {
    private static final long serialVersionUID = 1L;
    private String _groupName;

    public AbstractGroupNameReplicationPacket() {
    }

    public AbstractGroupNameReplicationPacket(String groupName) {
        this._groupName = groupName;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        IOUtils.writeRepetitiveString(out, this._groupName);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this._groupName = IOUtils.readRepetitiveString(in);
    }

    public String getGroupName() {
        return this._groupName;
    }

    protected IReplicationTargetGroup getTargetGroup(IIncomingReplicationFacade incomingReplicationFacade) {
        IReplicationTargetGroup targetGroup = incomingReplicationFacade.getReplicationTargetGroup(this.getGroupName());
        return targetGroup;
    }

    @Override
    public void toText(Textualizer textualizer) {
        super.toText(textualizer);
        textualizer.append("groupName", this.getGroupName());
    }
}

