/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.router;

import com.gigaspaces.async.AsyncFuture;
import com.gigaspaces.internal.cluster.node.impl.ReplicationLogUtils;
import com.gigaspaces.internal.cluster.node.impl.router.AbstractConnectionProxyBasedReplicationRouter;
import com.gigaspaces.internal.cluster.node.impl.router.AbstractReplicationPacket;
import com.gigaspaces.internal.cluster.node.impl.router.ConnectionState;
import com.gigaspaces.internal.cluster.node.impl.router.IAsyncContextProvider;
import com.gigaspaces.internal.cluster.node.impl.router.IConnectionStateListener;
import com.gigaspaces.internal.cluster.node.impl.router.IConnectivityCheckListener;
import com.gigaspaces.internal.cluster.node.impl.router.spacefinder.DisconnectionProxy;
import com.gigaspaces.internal.cluster.node.impl.router.spacefinder.IConnectionMonitor;
import com.gigaspaces.internal.cluster.node.impl.router.spacefinder.IReplicationConnectionProxy;
import com.gigaspaces.internal.utils.StringUtils;
import com.gigaspaces.internal.utils.collections.CopyOnUpdateSet;
import com.gigaspaces.internal.version.PlatformLogicalVersion;
import com.gigaspaces.lrmi.ILRMIProxy;
import com.gigaspaces.lrmi.LRMIUtilities;
import com.gigaspaces.lrmi.nio.async.IExceptionHandler;
import com.gigaspaces.lrmi.nio.async.IFuture;
import com.gigaspaces.management.transport.ConnectionEndpointDetails;
import com.gigaspaces.time.SystemTime;
import java.rmi.RemoteException;
import java.util.HashSet;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.core.lookup.ServiceID;
import net.jini.id.Uuid;

public abstract class AbstractProxyBasedReplicationMonitoredConnection<T, L>
implements IExceptionHandler {
    private volatile IReplicationConnectionProxy _connectionProxy;
    private volatile T _tag;
    private volatile String _endPointLookupName;
    private volatile Uuid _proxyId;
    private volatile ConnectionState _connectionState;
    private volatile Exception _lastDisconnectionReason;
    private volatile Long _timeOfDisconnection;
    private final Logger _specificLogger;
    private volatile boolean _connectionClosed;
    private final IConnectionMonitor<T, L> _monitor;
    private final L _url;
    private final AbstractConnectionProxyBasedReplicationRouter<T, L> _router;
    private final String _targetLookupName;
    private final Set<IConnectionStateListener> _stateListeners = new HashSet<IConnectionStateListener>();
    private final Set<IConnectivityCheckListener> _connectivityCheckListeners = new CopyOnUpdateSet<IConnectivityCheckListener>();
    private final Object _stateLock = new Object();
    private final Object _dispatchLock = new Object();
    private final Queue<StateChangedEvent> _pendingStateEvents = new ConcurrentLinkedQueue<StateChangedEvent>();
    private final AtomicInteger _reference = new AtomicInteger(0);
    private final IAsyncContextProvider _asyncContextProvider;

    public AbstractProxyBasedReplicationMonitoredConnection(AbstractConnectionProxyBasedReplicationRouter<T, L> router, String targetLookupName, IReplicationConnectionProxy connectionProxy, T tag, String endpointLookupName, IConnectionMonitor<T, L> monitor, L url, ConnectionState state, Exception disconnectionReason, Uuid proxyId, IAsyncContextProvider asyncContextProvider) {
        this._router = router;
        this._targetLookupName = targetLookupName;
        this._connectionProxy = connectionProxy;
        this._tag = tag;
        this._endPointLookupName = endpointLookupName;
        this._monitor = monitor;
        this._url = url;
        this._proxyId = proxyId;
        this._connectionState = state;
        this._timeOfDisconnection = this._connectionState == ConnectionState.DISCONNECTED ? Long.valueOf(SystemTime.timeMillis()) : null;
        this._lastDisconnectionReason = disconnectionReason;
        this._asyncContextProvider = asyncContextProvider;
        this._specificLogger = Logger.getLogger("com.gigaspaces.replication.router.communication." + ReplicationLogUtils.toShortLookupName(router.getMyLookupName()));
        this._monitor.monitor(this);
    }

    public AbstractConnectionProxyBasedReplicationRouter<T, L> getRouter() {
        return this._router;
    }

    private void close() {
        this.onClose();
        IReplicationConnectionProxy connectionProxy = this.getConnectionProxy();
        if (connectionProxy != null) {
            try {
                connectionProxy.close();
                if (connectionProxy instanceof ILRMIProxy) {
                    ((ILRMIProxy)((Object)connectionProxy)).closeProxy();
                }
            }
            catch (RemoteException remoteException) {
            }
            finally {
                this._connectionClosed = true;
            }
        }
    }

    public boolean isConnectionClosed() {
        return this._connectionClosed;
    }

    protected abstract void onClose();

    public <TR> TR dispatch(AbstractReplicationPacket<TR> packet) throws RemoteException {
        if (this._router.isSetMyIdBeforeDispatch()) {
            packet.setSourceEndpointDetails(this._router.getMyEndpointDetails());
        }
        try {
            boolean logCommunication = this._specificLogger.isLoggable(Level.FINEST);
            if (logCommunication) {
                this._specificLogger.finest("dispatching packet to " + ReplicationLogUtils.toShortLookupName(this._endPointLookupName) + " - " + packet);
            }
            TR result = this._connectionProxy.dispatch(packet);
            if (logCommunication) {
                this._specificLogger.finest("dispatch result from " + ReplicationLogUtils.toShortLookupName(this._endPointLookupName) + " for packet " + packet.toIdString() + " is - " + result);
            }
            return result;
        }
        catch (RemoteException e) {
            this._monitor.updateDisconnected(this, e);
            throw e;
        }
    }

    public <TR> AsyncFuture<TR> dispatchAsync(AbstractReplicationPacket<TR> packet) throws RemoteException {
        if (this._router.isSetMyIdBeforeDispatch()) {
            packet.setSourceEndpointDetails(this._router.getMyEndpointDetails());
        }
        try {
            IReplicationConnectionProxy connectionProxy = this._connectionProxy;
            this._asyncContextProvider.setExceptionHandler(this);
            if (this._specificLogger.isLoggable(Level.FINEST)) {
                this._specificLogger.finest("async dispatching packet to " + ReplicationLogUtils.toShortLookupName(this._endPointLookupName) + " - " + packet);
            }
            TR result = connectionProxy.dispatchAsync(packet);
            return this._asyncContextProvider.getFutureContext(result, connectionProxy);
        }
        catch (RemoteException e) {
            this._monitor.updateDisconnected(this, e);
            throw e;
        }
    }

    @Override
    public Throwable handleException(Throwable ex, IFuture future) {
        if (ex instanceof RemoteException) {
            this._monitor.updateDisconnected(this, (RemoteException)ex);
        }
        return ex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConnected(IReplicationConnectionProxy proxy, T tag, String endPointLookupName, Uuid proxyId) {
        boolean newTarget = this._proxyId == null ? true : !this._proxyId.equals((Object)proxyId);
        Object object = this.getStateLock();
        synchronized (object) {
            if (this._connectionState == ConnectionState.CONNECTED) {
                return;
            }
            this._timeOfDisconnection = null;
            this._connectionProxy = proxy;
            this._tag = tag;
            this._endPointLookupName = endPointLookupName;
            this._proxyId = proxyId;
            this._connectionState = ConnectionState.CONNECTED;
            if (this._specificLogger.isLoggable(Level.INFO)) {
                this._specificLogger.info("Connection state updated to 'CONNECTED', Lookup name: " + endPointLookupName);
            }
            this.addPendingEvent(newTarget ? StateChangedEvent.CONNECTED_NEW : StateChangedEvent.CONNECTED_OLD);
        }
    }

    private void addPendingEvent(StateChangedEvent stateChangedEvent) {
        this._pendingStateEvents.add(stateChangedEvent);
        Thread trd = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = AbstractProxyBasedReplicationMonitoredConnection.this._dispatchLock;
                synchronized (object) {
                    StateChangedEvent event;
                    while (!AbstractProxyBasedReplicationMonitoredConnection.this._pendingStateEvents.isEmpty() && (event = (StateChangedEvent)((Object)AbstractProxyBasedReplicationMonitoredConnection.this._pendingStateEvents.poll())) != null) {
                        for (IConnectionStateListener listener : AbstractProxyBasedReplicationMonitoredConnection.this._stateListeners) {
                            switch (event) {
                                case CONNECTED_NEW: {
                                    listener.onConnected(true);
                                    break;
                                }
                                case CONNECTED_OLD: {
                                    listener.onConnected(false);
                                    break;
                                }
                                case DISCONNECTED: {
                                    listener.onDisconnected();
                                }
                            }
                        }
                    }
                }
            }
        });
        trd.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDisconnected(Exception reason) {
        Object object = this.getStateLock();
        synchronized (object) {
            if (this._connectionState == ConnectionState.DISCONNECTED) {
                return;
            }
            this._timeOfDisconnection = SystemTime.timeMillis();
            this._connectionProxy = new DisconnectionProxy();
            this._connectionState = ConnectionState.DISCONNECTED;
            if (this._specificLogger.isLoggable(Level.WARNING)) {
                this._specificLogger.warning("Connection state updated to 'DISCONNECTED', Lookup name: " + this._endPointLookupName + ", Reason: " + reason);
            }
            this.addPendingEvent(StateChangedEvent.DISCONNECTED);
        }
    }

    public ConnectionState getState() {
        return this._connectionState;
    }

    public L getFinderURL() {
        return this._url;
    }

    public IReplicationConnectionProxy getConnectionProxy() {
        return this._connectionProxy;
    }

    public String getTargetLookupName() {
        return this._targetLookupName;
    }

    public String getFinalEndpointLookupName() {
        return this._endPointLookupName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStateListener(IConnectionStateListener listener) {
        Object object = this.getStateLock();
        synchronized (object) {
            this._stateListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeStateListener(IConnectionStateListener listener) {
        Object object = this.getStateLock();
        synchronized (object) {
            this._stateListeners.remove(listener);
        }
    }

    public void removeConnectivityCheckListener(IConnectivityCheckListener connectivityCheckListener) {
        this._connectivityCheckListeners.remove(connectivityCheckListener);
    }

    public void addConnectivityCheckListener(IConnectivityCheckListener connectivityCheckListener) {
        this._connectivityCheckListeners.add(connectivityCheckListener);
    }

    public void removeReference() {
        if (this._reference.decrementAndGet() == 0) {
            this.close();
        }
    }

    public void addReference() {
        this._reference.incrementAndGet();
    }

    public Exception getLastDisconnectionReason() {
        return this._lastDisconnectionReason;
    }

    public void setLastDisconnectionReason(Exception exception) {
        this._lastDisconnectionReason = exception;
    }

    public T getTag() {
        return this._tag;
    }

    public ServiceID getServiceId() {
        if (this._proxyId == null) {
            return null;
        }
        return new ServiceID(this._proxyId.getMostSignificantBits(), this._proxyId.getLeastSignificantBits());
    }

    public Uuid getProxyId() {
        return this._proxyId;
    }

    public Object getStateLock() {
        return this._stateLock;
    }

    public Object getConnectionUrl() {
        return this._url;
    }

    public String dumpState() {
        return "Connection [" + this._router.getMyLookupName() + "->" + this.getTargetLookupName() + "(id=" + this.getProxyId() + ")] state [" + (Object)((Object)this._connectionState) + "] timeOfDisconnection [" + this._timeOfDisconnection + "]" + StringUtils.NEW_LINE + "\ttarget url: " + this._url;
    }

    public String toString() {
        return this.dumpState();
    }

    public long getGeneratedTraffic() {
        if (!(this._connectionProxy instanceof ILRMIProxy)) {
            return 0L;
        }
        return ((ILRMIProxy)((Object)this._connectionProxy)).getGeneratedTraffic();
    }

    public long getReceivedTraffic() {
        if (!(this._connectionProxy instanceof ILRMIProxy)) {
            return 0L;
        }
        return ((ILRMIProxy)((Object)this._connectionProxy)).getReceivedTraffic();
    }

    public Object getClosestEndpointAddress() {
        if (!(this._connectionProxy instanceof ILRMIProxy)) {
            return "Not available";
        }
        return ((ILRMIProxy)((Object)this._connectionProxy)).getConnectionUrl();
    }

    public PlatformLogicalVersion getClosestEndpointLogicalVersion() {
        IReplicationConnectionProxy connectionProxy = this._connectionProxy;
        if (connectionProxy == null) {
            return PlatformLogicalVersion.getLogicalVersion();
        }
        return LRMIUtilities.getServicePlatformLogicalVersion(connectionProxy);
    }

    public ConnectionEndpointDetails getClosestEndpointDetails() {
        return LRMIUtilities.getConnectionEndpointDetails(this._connectionProxy);
    }

    public void triggerSuccessfulConnectivityCheckEvent() {
        for (IConnectivityCheckListener listener : this._connectivityCheckListeners) {
            try {
                listener.afterSuccessfulConnectivityCheck();
            }
            catch (Exception exception) {}
        }
    }

    public abstract boolean supportsConnectivityCheckEvents();

    public Long getTimeOfDisconnection() {
        return this._timeOfDisconnection;
    }

    public static enum StateChangedEvent {
        CONNECTED_NEW,
        CONNECTED_OLD,
        DISCONNECTED;

    }
}

