/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.router;

import com.gigaspaces.internal.cluster.node.impl.ReplicationLogUtils;
import com.gigaspaces.internal.cluster.node.impl.router.AbstractProxyBasedReplicationMonitoredConnection;
import com.gigaspaces.internal.cluster.node.impl.router.ConnectionState;
import com.gigaspaces.internal.cluster.node.impl.router.spacefinder.IConnectionMonitor;
import com.gigaspaces.internal.utils.StringUtils;
import com.gigaspaces.internal.utils.concurrent.GSThreadFactory;
import java.rmi.RemoteException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractScheduledPoolConnectionMonitor<T, L>
implements IConnectionMonitor<T, L> {
    protected final Logger _specificLogger;
    private final ScheduledExecutorService _pool;
    private final long _monitorConnectedDelay;
    private final long _monitorDisconnectedDelay;
    private final TimeUnit _timeUnit;
    private final Map<AbstractProxyBasedReplicationMonitoredConnection<T, L>, ScheduledFuture<?>> _monitoredDisconnectedFutures = new ConcurrentHashMap();
    private final Map<AbstractProxyBasedReplicationMonitoredConnection<T, L>, ScheduledFuture<?>> _monitoredConnectedFutures = new ConcurrentHashMap();
    private final String _myLookupName;
    private volatile boolean _closed;
    public final boolean mayInterruptIfRunning = Boolean.getBoolean("com.gs.replication.connection-monitor.mayInterruptIfRunning");

    public AbstractScheduledPoolConnectionMonitor(String myLookupName, int corePoolSize, long monitorConnectedDelay, long monitorDisconnectedDelay, TimeUnit timeUnit) {
        this._myLookupName = myLookupName;
        this._monitorConnectedDelay = monitorConnectedDelay;
        this._monitorDisconnectedDelay = monitorDisconnectedDelay;
        this._timeUnit = timeUnit;
        this._specificLogger = Logger.getLogger("com.gigaspaces.replication.router." + ReplicationLogUtils.toShortLookupName(this._myLookupName));
        this._pool = new ScheduledThreadPoolExecutor(corePoolSize, (ThreadFactory)new GSThreadFactory("connection-monitor-thread", true));
    }

    protected String getLogPrefix() {
        return "Failure Monitor [" + this._myLookupName + "]: ";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void monitor(AbstractProxyBasedReplicationMonitoredConnection<T, L> connection) {
        Object object = connection.getStateLock();
        synchronized (object) {
            ConnectionState connectionState = connection.getState();
            if (connectionState == ConnectionState.CONNECTED) {
                try {
                    this.monitorConnected(connection);
                }
                catch (Exception e) {
                    this.updateDisconnected(connection, e);
                }
            } else if (connectionState == ConnectionState.DISCONNECTED) {
                this.monitorDisconnected(connection);
            }
        }
    }

    private void monitorDisconnected(AbstractProxyBasedReplicationMonitoredConnection<T, L> connection) {
        block4: {
            if (this._monitoredDisconnectedFutures.containsKey(connection)) {
                throw new IllegalArgumentException("Provided connection " + connection + " is already monitored");
            }
            if (this._specificLogger.isLoggable(Level.FINEST)) {
                this._specificLogger.finest(this.getLogPrefix() + "monitoring disconnected connection " + connection.getTargetLookupName());
            }
            Runnable monitorTask = this.createMonitorDisconnectedTask(connection);
            try {
                ScheduledFuture<?> future = this._pool.scheduleWithFixedDelay(monitorTask, this._monitorDisconnectedDelay, this._monitorDisconnectedDelay, this._timeUnit);
                this._monitoredDisconnectedFutures.put(connection, future);
            }
            catch (RejectedExecutionException e) {
                if (this._closed) break block4;
                throw e;
            }
        }
    }

    protected abstract Runnable createMonitorDisconnectedTask(AbstractProxyBasedReplicationMonitoredConnection<T, L> var1);

    private void monitorConnected(AbstractProxyBasedReplicationMonitoredConnection<T, L> connection) {
        block4: {
            if (this._monitoredConnectedFutures.containsKey(connection)) {
                throw new IllegalArgumentException("Provided connection " + connection + " is already monitored");
            }
            if (this._specificLogger.isLoggable(Level.FINEST)) {
                this._specificLogger.finest(this.getLogPrefix() + "monitoring connected connection " + connection.getTargetLookupName() + StringUtils.NEW_LINE + "ServiceID=" + connection.getServiceId());
            }
            MonitorConnectedConnectionTask monitorTask = new MonitorConnectedConnectionTask(connection);
            try {
                ScheduledFuture<?> future = this._pool.scheduleWithFixedDelay(monitorTask, this._monitorConnectedDelay, this._monitorConnectedDelay, this._timeUnit);
                this._monitoredConnectedFutures.put(connection, future);
            }
            catch (RejectedExecutionException e) {
                if (this._closed) break block4;
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopMonitoring(AbstractProxyBasedReplicationMonitoredConnection<T, L> connection) {
        Object object = connection.getStateLock();
        synchronized (object) {
            ScheduledFuture<?> future = this._monitoredConnectedFutures.remove(connection);
            if (future != null) {
                future.cancel(this.mayInterruptIfRunning);
            }
            if ((future = this._monitoredDisconnectedFutures.remove(connection)) != null) {
                future.cancel(this.mayInterruptIfRunning);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateDisconnected(AbstractProxyBasedReplicationMonitoredConnection<T, L> connection, Exception reason) {
        Object object = connection.getStateLock();
        synchronized (object) {
            if (this._monitoredDisconnectedFutures.containsKey(connection)) {
                return;
            }
            if (this._specificLogger.isLoggable(Level.FINE)) {
                this._specificLogger.fine(this.getLogPrefix() + "connection disconnection detected " + connection.getTargetLookupName() + reason != null ? " reason - " + reason : "");
            }
            this.stopMonitoring(connection);
            connection.setDisconnected(reason);
            if (!connection.isConnectionClosed()) {
                this.monitorDisconnected(connection);
            }
        }
    }

    public int getMonitoredCount() {
        return this._monitoredConnectedFutures.size() + this._monitoredDisconnectedFutures.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        ScheduledExecutorService scheduledExecutorService = this._pool;
        synchronized (scheduledExecutorService) {
            if (this._closed) {
                return;
            }
            this._closed = true;
            for (ScheduledFuture<?> future : this._monitoredConnectedFutures.values()) {
                future.cancel(true);
            }
            for (ScheduledFuture<?> future : this._monitoredDisconnectedFutures.values()) {
                future.cancel(true);
            }
            this._pool.shutdownNow();
        }
    }

    @Override
    public String dumpState() {
        StringBuilder dump = new StringBuilder("Disconnected monitored:");
        dump.append(StringUtils.NEW_LINE);
        for (AbstractProxyBasedReplicationMonitoredConnection<T, L> connection : this._monitoredDisconnectedFutures.keySet()) {
            dump.append(connection.dumpState());
            dump.append(StringUtils.NEW_LINE);
        }
        dump.append("Connected monitored:");
        dump.append(StringUtils.NEW_LINE);
        for (AbstractProxyBasedReplicationMonitoredConnection<T, L> connection : this._monitoredConnectedFutures.keySet()) {
            dump.append(connection.dumpState());
            dump.append(StringUtils.NEW_LINE);
        }
        return dump.toString();
    }

    public class MonitorConnectedConnectionTask
    implements Runnable {
        private final AbstractProxyBasedReplicationMonitoredConnection<T, L> _connection;

        public MonitorConnectedConnectionTask(AbstractProxyBasedReplicationMonitoredConnection<T, L> connection) {
            this._connection = connection;
        }

        @Override
        public void run() {
            try {
                this._connection.getRouter().pingStub(this._connection.getConnectionProxy());
                this._connection.triggerSuccessfulConnectivityCheckEvent();
            }
            catch (RemoteException e) {
                AbstractScheduledPoolConnectionMonitor.this.updateDisconnected(this._connection, e);
            }
        }
    }
}

