/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.router;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.cluster.node.impl.router.AbstractProxyBasedReplicationMonitoredConnection;
import com.gigaspaces.internal.cluster.node.impl.router.AbstractScheduledPoolConnectionMonitor;
import com.gigaspaces.internal.cluster.node.impl.router.spacefinder.IReplicationConnectionProxy;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

@InternalApi
public class DirectConnectionScheduledPoolConnectionMonitor
extends AbstractScheduledPoolConnectionMonitor<IReplicationConnectionProxy, Object> {
    public DirectConnectionScheduledPoolConnectionMonitor(String myLookupName, int corePoolSize, long monitorConnectedDelay, long monitorDisconnectedDelay, TimeUnit timeUnit) {
        super(myLookupName, corePoolSize, monitorConnectedDelay, monitorDisconnectedDelay, timeUnit);
    }

    @Override
    protected Runnable createMonitorDisconnectedTask(AbstractProxyBasedReplicationMonitoredConnection<IReplicationConnectionProxy, Object> connection) {
        return new MonitorDisconnectedConnectionTask(connection);
    }

    private class MonitorDisconnectedConnectionTask
    implements Runnable {
        private final AbstractProxyBasedReplicationMonitoredConnection<IReplicationConnectionProxy, Object> _connection;

        public MonitorDisconnectedConnectionTask(AbstractProxyBasedReplicationMonitoredConnection<IReplicationConnectionProxy, Object> connection) {
            this._connection = connection;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (DirectConnectionScheduledPoolConnectionMonitor.this._specificLogger.isLoggable(Level.FINER)) {
                DirectConnectionScheduledPoolConnectionMonitor.this._specificLogger.finer(DirectConnectionScheduledPoolConnectionMonitor.this.getLogPrefix() + "trying to establish connection with " + this._connection.getTargetLookupName() + " [" + this._connection.getFinderURL() + "]");
            }
            try {
                IReplicationConnectionProxy directConnectionProxy = this._connection.getTag();
                this._connection.getRouter().pingStub(directConnectionProxy);
                Object object = this._connection.getStateLock();
                synchronized (object) {
                    if (DirectConnectionScheduledPoolConnectionMonitor.this._specificLogger.isLoggable(Level.FINE)) {
                        DirectConnectionScheduledPoolConnectionMonitor.this._specificLogger.fine(DirectConnectionScheduledPoolConnectionMonitor.this.getLogPrefix() + "established connection with " + this._connection.getTargetLookupName() + " [" + this._connection.getFinderURL() + "]");
                    }
                    this._connection.setConnected(directConnectionProxy, directConnectionProxy, this._connection.getFinalEndpointLookupName(), this._connection.getProxyId());
                    DirectConnectionScheduledPoolConnectionMonitor.this.stopMonitoring(this._connection);
                    DirectConnectionScheduledPoolConnectionMonitor.this.monitor(this._connection);
                }
            }
            catch (Exception e) {
                this._connection.setLastDisconnectionReason(e);
            }
        }
    }
}

