/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.router;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.io.IOUtils;
import com.gigaspaces.internal.utils.Textualizable;
import com.gigaspaces.internal.utils.Textualizer;
import com.gigaspaces.internal.version.PlatformLogicalVersion;
import com.gigaspaces.lrmi.LRMIInvocationContext;
import com.gigaspaces.management.transport.ConnectionEndpointDetails;
import com.gigaspaces.start.SystemInfo;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

@InternalApi
public class ReplicationEndpointDetails
implements Externalizable,
Textualizable {
    private static final long serialVersionUID = 1L;
    private String _lookupName;
    private Object _uniqueId;
    private String _hostname;
    private ConnectionEndpointDetails _connectionDetails;

    public static ReplicationEndpointDetails createMyEndpointDetails(String lookupName, Object uniqueId) {
        String hostname = SystemInfo.singleton().network().getHost().getHostName();
        return new ReplicationEndpointDetails(lookupName, uniqueId, hostname, ConnectionEndpointDetails.create());
    }

    public ReplicationEndpointDetails cloneWithCurrentVersion() {
        return new ReplicationEndpointDetails(this._lookupName, this._uniqueId, this._hostname, this._connectionDetails.createCopy(PlatformLogicalVersion.getLogicalVersion()));
    }

    @Deprecated
    public static ReplicationEndpointDetails createBackwardEndpointDetails(String lookupName, Object uniqueId) {
        return new ReplicationEndpointDetails(lookupName, uniqueId, null, ConnectionEndpointDetails.EMPTY);
    }

    public ReplicationEndpointDetails() {
    }

    private ReplicationEndpointDetails(String lookupName, Object uniqueId, String hostname, ConnectionEndpointDetails connectionDetails) {
        this._lookupName = lookupName;
        this._uniqueId = uniqueId;
        this._hostname = hostname;
        this._connectionDetails = connectionDetails;
    }

    public Object getUniqueId() {
        return this._uniqueId;
    }

    public String getLookupName() {
        return this._lookupName;
    }

    public ConnectionEndpointDetails getConnectionDetails() {
        return this._connectionDetails;
    }

    public String getHostname() {
        return this._hostname;
    }

    public long getPid() {
        return this._connectionDetails.getProcessId();
    }

    public PlatformLogicalVersion getPlatformLogicalVersion() {
        return this._connectionDetails.getVersion();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._uniqueId == null ? 0 : this._uniqueId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ReplicationEndpointDetails other = (ReplicationEndpointDetails)obj;
        return !(this._uniqueId == null ? other._uniqueId != null : !this._uniqueId.equals(other._uniqueId));
    }

    public String toString() {
        return Textualizer.toString(this);
    }

    @Override
    public void toText(Textualizer textualizer) {
        textualizer.append("lookupName", this.getLookupName());
        textualizer.append("uniqueId", this.getUniqueId());
        textualizer.append("hostname", this.getHostname());
        textualizer.append("pid", this.getPid());
        textualizer.append("version", this.getPlatformLogicalVersion());
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        PlatformLogicalVersion version = LRMIInvocationContext.getEndpointLogicalVersion();
        if (version.greaterOrEquals(PlatformLogicalVersion.v9_5_0)) {
            this.writeExternalV9_5_0(out);
        } else {
            this.writeExternalOld(out);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        PlatformLogicalVersion version = LRMIInvocationContext.getEndpointLogicalVersion();
        if (version.greaterOrEquals(PlatformLogicalVersion.v9_5_0)) {
            this.readExternalV9_5_0(in);
        } else {
            this.readExternalOld(in);
        }
    }

    private void writeExternalV9_5_0(ObjectOutput out) throws IOException {
        IOUtils.writeRepetitiveString(out, this._lookupName);
        IOUtils.writeRepetitiveObject(out, this._uniqueId);
        IOUtils.writeRepetitiveString(out, this._hostname);
        IOUtils.writeObject(out, this._connectionDetails);
    }

    private void readExternalV9_5_0(ObjectInput in) throws IOException, ClassNotFoundException {
        this._lookupName = IOUtils.readRepetitiveString(in);
        this._uniqueId = IOUtils.readRepetitiveObject(in);
        this._hostname = IOUtils.readRepetitiveString(in);
        this._connectionDetails = (ConnectionEndpointDetails)IOUtils.readObject(in);
    }

    private void writeExternalOld(ObjectOutput out) throws IOException {
        IOUtils.writeRepetitiveString(out, this._lookupName);
        IOUtils.writeRepetitiveObject(out, this._uniqueId);
        out.writeLong(this._connectionDetails.getProcessId());
        IOUtils.writeRepetitiveString(out, this._hostname);
        IOUtils.writeRepetitiveObject(out, this._connectionDetails.getVersion());
    }

    private void readExternalOld(ObjectInput in) throws IOException, ClassNotFoundException {
        this._lookupName = IOUtils.readRepetitiveString(in);
        this._uniqueId = IOUtils.readRepetitiveObject(in);
        long pid = in.readLong();
        this._hostname = IOUtils.readRepetitiveString(in);
        PlatformLogicalVersion version = (PlatformLogicalVersion)IOUtils.readRepetitiveObject(in);
        this._connectionDetails = new ConnectionEndpointDetails(this._hostname, null, pid, version);
    }
}

