/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.router;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.cluster.node.impl.router.ReplicationRouterBuilder;
import com.gigaspaces.internal.cluster.node.impl.router.spacefinder.DummyUrlConverter;
import com.gigaspaces.internal.cluster.node.impl.router.spacefinder.ISpaceUrlConverter;
import com.gigaspaces.internal.cluster.node.impl.router.spacefinder.SpaceFinderSpaceProxyProvider;
import com.gigaspaces.internal.cluster.node.impl.router.spacefinder.SpaceProxyReplicationRouter;
import com.gigaspaces.internal.cluster.node.impl.router.spacefinder.SpaceUrlConverter;
import com.gigaspaces.internal.cluster.node.impl.router.spacefinder.failuredetector.DummyFailureDetector;
import com.gigaspaces.internal.cluster.node.impl.router.spacefinder.failuredetector.FailureDetectorConnectionMonitor;
import com.gigaspaces.internal.cluster.node.impl.router.spacefinder.failuredetector.IFailureDetector;
import com.gigaspaces.internal.server.space.SpaceImpl;
import com.gigaspaces.internal.server.space.replication.SpaceServiceExporter;
import com.j_spaces.core.cluster.ClusterPolicy;
import java.util.concurrent.TimeUnit;

@InternalApi
public class ReplicationRouterBuilderFactory {
    public ReplicationRouterBuilder create(SpaceImpl spaceImpl) {
        return this.createSpaceProxyReplicationRouterBuilder(spaceImpl, false);
    }

    public ReplicationRouterBuilder createSpaceProxyReplicationRouterBuilder(SpaceImpl spaceImpl, boolean dummy) {
        ClusterPolicy clusterPolicy = spaceImpl.getClusterPolicy();
        boolean isReplicated = clusterPolicy != null && clusterPolicy.m_Replicated;
        ISpaceUrlConverter spaceUrlConverter = dummy ? new DummyUrlConverter() : new SpaceUrlConverter(clusterPolicy.getReplicationPolicy());
        SpaceFinderSpaceProxyProvider spaceProxyProvider = new SpaceFinderSpaceProxyProvider();
        int CORE_POOL_SIZE = isReplicated ? clusterPolicy.getReplicationPolicy().getConnectionMonitorThreadPoolSize() : 4;
        long MONITOR_DISCONNECTED_DELAY = 1L;
        String ownMemberName = spaceImpl.getConfigReader().getFullSpaceName();
        IFailureDetector failureDetector = spaceImpl.getClusterFailureDetector() != null ? spaceImpl.getClusterFailureDetector() : new DummyFailureDetector();
        FailureDetectorConnectionMonitor connectionMonitor = new FailureDetectorConnectionMonitor(ownMemberName, CORE_POOL_SIZE, 1L, TimeUnit.SECONDS, spaceProxyProvider, failureDetector);
        return new SpaceProxyReplicationRouter.Builder(ownMemberName, spaceImpl.getUuid(), spaceProxyProvider, spaceUrlConverter, connectionMonitor, new SpaceServiceExporter(spaceImpl), CORE_POOL_SIZE);
    }
}

