/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.router.spacefinder;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.async.AsyncFuture;
import com.gigaspaces.internal.cluster.node.impl.router.AbstractProxyBasedReplicationMonitoredConnection;
import com.gigaspaces.internal.cluster.node.impl.router.AbstractReplicationPacket;
import com.gigaspaces.internal.cluster.node.impl.router.ConnectionState;
import com.gigaspaces.internal.cluster.node.impl.router.IConnectionStateListener;
import com.gigaspaces.internal.cluster.node.impl.router.IConnectivityCheckListener;
import com.gigaspaces.internal.cluster.node.impl.router.IReplicationMonitoredConnection;
import com.gigaspaces.internal.version.PlatformLogicalVersion;
import com.gigaspaces.management.transport.ConnectionEndpointDetails;
import java.rmi.RemoteException;
import net.jini.id.Uuid;

@InternalApi
public class ConnectionReference<T, L>
implements IReplicationMonitoredConnection {
    private final AbstractProxyBasedReplicationMonitoredConnection<T, L> _connection;
    private IConnectionStateListener _listener;
    private IConnectivityCheckListener _connectivityCheckListener;
    private boolean _closed;

    public ConnectionReference(AbstractProxyBasedReplicationMonitoredConnection<T, L> connection) {
        this._connection = connection;
        this._connection.addReference();
    }

    @Override
    public synchronized void close() {
        if (this._closed) {
            return;
        }
        this._closed = true;
        if (this._listener != null) {
            this._connection.removeStateListener(this._listener);
        }
        if (this._connectivityCheckListener != null) {
            this._connection.removeConnectivityCheckListener(this._connectivityCheckListener);
        }
        this._connection.removeReference();
    }

    @Override
    public <T> T dispatch(AbstractReplicationPacket<T> packet) throws RemoteException {
        return this._connection.dispatch(packet);
    }

    @Override
    public <T> AsyncFuture<T> dispatchAsync(AbstractReplicationPacket<T> packet) throws RemoteException {
        return this._connection.dispatchAsync(packet);
    }

    @Override
    public ConnectionState getState() {
        return this._connection.getState();
    }

    @Override
    public synchronized void setConnectionStateListener(IConnectionStateListener listener) {
        if (this._listener != null) {
            this._connection.removeStateListener(this._listener);
        }
        this._listener = listener;
        this._connection.addStateListener(this._listener);
    }

    @Override
    public synchronized void setConnectivityCheckListener(IConnectivityCheckListener listener) {
        if (this._connectivityCheckListener != null) {
            this._connection.removeConnectivityCheckListener(this._connectivityCheckListener);
        }
        this._connectivityCheckListener = listener;
        this._connection.addConnectivityCheckListener(this._connectivityCheckListener);
    }

    public AbstractProxyBasedReplicationMonitoredConnection<T, L> getUnderlyingConnection() {
        return this._connection;
    }

    @Override
    public Exception getLastDisconnectionReason() {
        return this._connection.getLastDisconnectionReason();
    }

    @Override
    public String getFinalEndpointLookupName() {
        return this._connection.getFinalEndpointLookupName();
    }

    public Uuid getClosestEndpointUniqueId() {
        return this._connection.getProxyId();
    }

    @Override
    public Object getClosestEndpointAddress() {
        return this._connection.getClosestEndpointAddress();
    }

    @Override
    public ConnectionEndpointDetails getClosestEndpointDetails() {
        return this._connection.getClosestEndpointDetails();
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    @Override
    public Object getConnectionUrl() {
        return this._connection.getConnectionUrl();
    }

    @Override
    public long getGeneratedTraffic() {
        return this._connection.getGeneratedTraffic();
    }

    @Override
    public long getReceivedTraffic() {
        return this._connection.getReceivedTraffic();
    }

    @Override
    public PlatformLogicalVersion getClosestEndpointLogicalVersion() {
        return this._connection.getClosestEndpointLogicalVersion();
    }

    @Override
    public boolean supportsConnectivityCheckEvents() {
        return this._connection.supportsConnectivityCheckEvents();
    }

    @Override
    public Long getTimeOfDisconnection() {
        return this._connection.getTimeOfDisconnection();
    }

    @Override
    public String dumpState() {
        return this._connection.dumpState();
    }
}

