/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.router.spacefinder;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.cluster.node.impl.IServiceExporter;
import com.gigaspaces.internal.cluster.node.impl.router.AbstractConnectionProxyBasedReplicationRouter;
import com.gigaspaces.internal.cluster.node.impl.router.AbstractProxyBasedReplicationMonitoredConnection;
import com.gigaspaces.internal.cluster.node.impl.router.ConnectionState;
import com.gigaspaces.internal.cluster.node.impl.router.IAsyncContextProvider;
import com.gigaspaces.internal.cluster.node.impl.router.IIncomingReplicationHandler;
import com.gigaspaces.internal.cluster.node.impl.router.IReplicationMonitoredConnection;
import com.gigaspaces.internal.cluster.node.impl.router.IReplicationRouter;
import com.gigaspaces.internal.cluster.node.impl.router.MemberProxyBasedReplicationMonitoredConnection;
import com.gigaspaces.internal.cluster.node.impl.router.ReplicationRouterBuilder;
import com.gigaspaces.internal.cluster.node.impl.router.UrlProxyBasedReplicationMonitoredConnection;
import com.gigaspaces.internal.cluster.node.impl.router.spacefinder.ConnectionReference;
import com.gigaspaces.internal.cluster.node.impl.router.spacefinder.DisconnectionProxy;
import com.gigaspaces.internal.cluster.node.impl.router.spacefinder.IConnectionMonitor;
import com.gigaspaces.internal.cluster.node.impl.router.spacefinder.IReplicationConnectionProxy;
import com.gigaspaces.internal.cluster.node.impl.router.spacefinder.ISpaceProxyProvider;
import com.gigaspaces.internal.cluster.node.impl.router.spacefinder.ISpaceUrlConverter;
import com.gigaspaces.internal.cluster.node.impl.router.spacefinder.RemoteSpaceResult;
import com.gigaspaces.internal.server.space.IRemoteSpace;
import com.j_spaces.core.client.FinderException;
import com.j_spaces.core.client.SpaceURL;
import com.j_spaces.core.exception.ClosedResourceException;
import java.rmi.RemoteException;
import net.jini.id.Uuid;

@InternalApi
public class SpaceProxyReplicationRouter
extends AbstractConnectionProxyBasedReplicationRouter<IRemoteSpace, SpaceURL>
implements IReplicationRouter {
    private final ISpaceProxyProvider _spaceProxyProvider;
    private final ISpaceUrlConverter _spaceUrlConverter;

    public SpaceProxyReplicationRouter(String myLookupName, Uuid uuid, IConnectionMonitor<IRemoteSpace, SpaceURL> connectionMonitor, IServiceExporter serviceExporter, IIncomingReplicationHandler incomingReplicationHandler, ISpaceProxyProvider spaceProxyProvider, ISpaceUrlConverter spaceUrlConverter, int replicationMonitorThreadPoolSize) {
        super(myLookupName, uuid, connectionMonitor, serviceExporter, incomingReplicationHandler, spaceProxyProvider, true, replicationMonitorThreadPoolSize);
        this._spaceProxyProvider = spaceProxyProvider;
        this._spaceUrlConverter = spaceUrlConverter;
    }

    public SpaceProxyReplicationRouter(String myLookupName, Uuid uuid, IConnectionMonitor<IRemoteSpace, SpaceURL> connectionMonitor, IServiceExporter serviceExporter, IIncomingReplicationHandler incomingReplicationHandler, ISpaceProxyProvider spaceProxyProvider, ISpaceUrlConverter spaceUrlConverter) {
        super(myLookupName, uuid, connectionMonitor, serviceExporter, incomingReplicationHandler, spaceProxyProvider, true);
        this._spaceProxyProvider = spaceProxyProvider;
        this._spaceUrlConverter = spaceUrlConverter;
    }

    @Override
    protected AbstractProxyBasedReplicationMonitoredConnection<IRemoteSpace, SpaceURL> createNewMemberConnection(String lookupName, boolean connectSynchronously) {
        SpaceURL url = this.convertNameToLookupParameters(lookupName);
        if (connectSynchronously) {
            return this.createConnectionAndConnect(lookupName, url, true);
        }
        return this.createConnection(lookupName, url);
    }

    private SpaceURL convertNameToLookupParameters(String lookupName) {
        SpaceURL url = this._spaceUrlConverter.convertMemberName(lookupName);
        return url;
    }

    private MemberProxyBasedReplicationMonitoredConnection<IRemoteSpace, SpaceURL> createConnection(String lookupName, SpaceURL url) {
        ConnectionState connectionState = ConnectionState.DISCONNECTED;
        Uuid proxyId = null;
        DisconnectionProxy connectionProxy = new DisconnectionProxy();
        String endpointLookupName = null;
        Object remoteSpace = null;
        Exception lastDisconnectionReason = null;
        return new MemberProxyBasedReplicationMonitoredConnection<Object, SpaceURL>(this, lookupName, connectionProxy, remoteSpace, endpointLookupName, this.getConnectionMonitor(), url, connectionState, lastDisconnectionReason, proxyId, this._spaceProxyProvider, false);
    }

    private AbstractProxyBasedReplicationMonitoredConnection<IRemoteSpace, SpaceURL> createConnectionAndConnect(String lookupName, SpaceURL url, boolean memberConnection) {
        ConnectionState connectionState = ConnectionState.DISCONNECTED;
        Uuid proxyId = null;
        IReplicationConnectionProxy connectionProxy = new DisconnectionProxy();
        String endpointLookupName = null;
        IRemoteSpace remoteSpace = null;
        Exception lastDisconnectionReason = null;
        try {
            RemoteSpaceResult result = this._spaceProxyProvider.getSpaceProxy(url);
            remoteSpace = result.getRemoteSpace();
            connectionProxy = remoteSpace.getReplicationRouterConnectionProxy();
            if (connectionProxy == null) {
                throw new IllegalStateException("Got null connection proxy");
            }
            connectionState = ConnectionState.CONNECTED;
            proxyId = remoteSpace.getSpaceUuid();
            endpointLookupName = result.getEndpointLookupName();
        }
        catch (FinderException e) {
            lastDisconnectionReason = e;
        }
        catch (RemoteException e) {
            lastDisconnectionReason = e;
        }
        AbstractProxyBasedReplicationMonitoredConnection connection = memberConnection ? new MemberProxyBasedReplicationMonitoredConnection<IRemoteSpace, SpaceURL>(this, lookupName, connectionProxy, remoteSpace, endpointLookupName, this.getConnectionMonitor(), url, connectionState, lastDisconnectionReason, proxyId, this._spaceProxyProvider, false) : new UrlProxyBasedReplicationMonitoredConnection<IRemoteSpace, SpaceURL>((AbstractConnectionProxyBasedReplicationRouter)this, lookupName, connectionProxy, remoteSpace, endpointLookupName, this.getConnectionMonitor(), url, connectionState, lastDisconnectionReason, proxyId, (IAsyncContextProvider)this._spaceProxyProvider);
        return connection;
    }

    @Override
    public synchronized IReplicationMonitoredConnection getUrlConnection(Object customUrl) {
        if (this.isClosed()) {
            throw new ClosedResourceException("Replication Router [" + this.getMyLookupName() + "] is closed");
        }
        SpaceURL url = (SpaceURL)customUrl;
        String urlString = url.toString();
        AbstractProxyBasedReplicationMonitoredConnection<IRemoteSpace, SpaceURL> connection = this.createConnectionAndConnect(urlString, url, false);
        return new ConnectionReference<IRemoteSpace, SpaceURL>(connection);
    }

    public static class Builder
    extends ReplicationRouterBuilder<SpaceProxyReplicationRouter> {
        private final String _myLookupName;
        private final ISpaceProxyProvider _spaceProxyProvider;
        private final ISpaceUrlConverter _spaceUrlConverter;
        private final IConnectionMonitor _connectionMonitor;
        private final IServiceExporter _serviceExporter;
        private final Uuid _uuid;
        private final int _connectionMonitorThreadPoolSize;

        public Builder(String myLookupName, Uuid uuid, ISpaceProxyProvider spaceProxyProvider, ISpaceUrlConverter spaceUrlConverter, IConnectionMonitor connectionMonitor, IServiceExporter serviceExporter) {
            this(myLookupName, uuid, spaceProxyProvider, spaceUrlConverter, connectionMonitor, serviceExporter, 4);
        }

        public Builder(String myLookupName, Uuid uuid, ISpaceProxyProvider spaceProxyProvider, ISpaceUrlConverter spaceUrlConverter, IConnectionMonitor connectionMonitor, IServiceExporter serviceExporter, int connectionMonitorThreadPoolSize) {
            this._myLookupName = myLookupName;
            this._uuid = uuid;
            this._spaceProxyProvider = spaceProxyProvider;
            this._spaceUrlConverter = spaceUrlConverter;
            this._connectionMonitor = connectionMonitor;
            this._serviceExporter = serviceExporter;
            this._connectionMonitorThreadPoolSize = connectionMonitorThreadPoolSize;
        }

        @Override
        public SpaceProxyReplicationRouter create(IIncomingReplicationHandler handler) {
            return new SpaceProxyReplicationRouter(this._myLookupName, this._uuid, this._connectionMonitor, this._serviceExporter, handler, this._spaceProxyProvider, this._spaceUrlConverter, this._connectionMonitorThreadPoolSize);
        }

        public String toString() {
            return "SpaceProxyReplicationRouter.Builder [_myLookupName=" + this._myLookupName + ", _spaceProxyProvider=" + this._spaceProxyProvider + ", _spaceUrlConverter=" + this._spaceUrlConverter + ", _connectionMonitor=" + this._connectionMonitor + ", _stubHandler=" + this._serviceExporter + ", _uuid=" + this._uuid + "]";
        }
    }
}

