/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.router.spacefinder;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.cluster.node.impl.router.spacefinder.ISpaceUrlConverter;
import com.j_spaces.core.client.SpaceURL;
import com.j_spaces.core.cluster.ReplicationPolicy;
import com.j_spaces.kernel.JSpaceUtilities;
import com.j_spaces.lookup.entry.State;
import java.util.LinkedList;
import java.util.List;
import net.jini.core.entry.Entry;

@InternalApi
public class SpaceUrlConverter
implements ISpaceUrlConverter {
    private final List<String> _groupMembersNames;
    private final List<SpaceURL> _groupMembersUrls;
    private final long _finderTimeout;

    public SpaceUrlConverter(ReplicationPolicy replicationPolicy) {
        this._finderTimeout = replicationPolicy.m_SpaceFinderTimeout;
        this._groupMembersNames = new LinkedList<String>(replicationPolicy.m_ReplicationGroupMembersNames);
        this._groupMembersUrls = new LinkedList<SpaceURL>(replicationPolicy.m_ReplicationGroupMembersURLs);
    }

    @Override
    public SpaceURL convertMemberName(String memberLookupName) {
        SpaceURL result = this.convertReplicationGroupUrl(memberLookupName);
        if (result != null) {
            return result;
        }
        throw new IllegalArgumentException("Could not convert " + memberLookupName + " to SpaceURL");
    }

    private SpaceURL convertReplicationGroupUrl(String memberLookupName) {
        int position = this._groupMembersNames.indexOf(memberLookupName);
        if (position == -1) {
            return null;
        }
        SpaceURL spaceUrl = this._groupMembersUrls.get(position).clone();
        if (JSpaceUtilities.isEmpty(spaceUrl.getProperty("timeout"))) {
            spaceUrl.setProperty("timeout", String.valueOf(this._finderTimeout));
        }
        spaceUrl.setLookupAttribute("state", (Entry)new State().setReplicable(Boolean.TRUE));
        return spaceUrl;
    }
}

