/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.router.spacefinder.failuredetector;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.cluster.node.impl.ReplicationLogUtils;
import com.gigaspaces.internal.cluster.node.impl.router.AbstractProxyBasedReplicationMonitoredConnection;
import com.gigaspaces.internal.cluster.node.impl.router.ConnectionState;
import com.gigaspaces.internal.cluster.node.impl.router.spacefinder.IConnectionMonitor;
import com.gigaspaces.internal.cluster.node.impl.router.spacefinder.IReplicationConnectionProxy;
import com.gigaspaces.internal.cluster.node.impl.router.spacefinder.ISpaceProxyProvider;
import com.gigaspaces.internal.cluster.node.impl.router.spacefinder.RemoteSpaceResult;
import com.gigaspaces.internal.cluster.node.impl.router.spacefinder.failuredetector.IFailureDetector;
import com.gigaspaces.internal.server.space.IRemoteSpace;
import com.gigaspaces.internal.utils.StringUtils;
import com.gigaspaces.internal.utils.collections.CopyOnUpdateSet;
import com.gigaspaces.internal.utils.concurrent.GSThreadFactory;
import com.j_spaces.core.client.FinderException;
import com.j_spaces.core.client.SpaceURL;
import com.j_spaces.core.cluster.startup.FaultDetectionListener;
import java.rmi.RemoteException;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.core.lookup.ServiceID;
import net.jini.id.Uuid;

@InternalApi
public class FailureDetectorConnectionMonitor
implements IConnectionMonitor<IRemoteSpace, SpaceURL>,
FaultDetectionListener {
    private final ScheduledExecutorService _pool;
    private final long _monitorDisconnectedDelay;
    private final TimeUnit _timeUnit;
    private final Map<AbstractProxyBasedReplicationMonitoredConnection<IRemoteSpace, SpaceURL>, ScheduledFuture<?>> _monitoredDisconnectedFutures = new ConcurrentHashMap();
    private final ConcurrentMap<ServiceID, Set<AbstractProxyBasedReplicationMonitoredConnection<IRemoteSpace, SpaceURL>>> _livenessMonitored = new ConcurrentHashMap<ServiceID, Set<AbstractProxyBasedReplicationMonitoredConnection<IRemoteSpace, SpaceURL>>>();
    private final ISpaceProxyProvider _proxyProvider;
    private final String _myLookupName;
    private final IFailureDetector _failureDetector;
    private final Logger _specificLogger;
    private volatile boolean _closed;

    public FailureDetectorConnectionMonitor(String myLookupName, int corePoolSize, long monitorDisconnectedDelay, TimeUnit timeUnit, ISpaceProxyProvider proxyProvider, IFailureDetector failureDetector) {
        this._monitorDisconnectedDelay = monitorDisconnectedDelay;
        this._timeUnit = timeUnit;
        this._proxyProvider = proxyProvider;
        this._myLookupName = myLookupName;
        this._failureDetector = failureDetector;
        this._specificLogger = Logger.getLogger("com.gigaspaces.replication.router." + ReplicationLogUtils.toShortLookupName(this._myLookupName));
        this._pool = new ScheduledThreadPoolExecutor(corePoolSize, (ThreadFactory)new GSThreadFactory(null, true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void monitor(AbstractProxyBasedReplicationMonitoredConnection<IRemoteSpace, SpaceURL> connection) {
        Object object = connection.getStateLock();
        synchronized (object) {
            ConnectionState connectionState = connection.getState();
            if (connectionState == ConnectionState.CONNECTED) {
                try {
                    this.monitorConnected(connection);
                }
                catch (Exception e) {
                    this.updateDisconnected(connection, e);
                }
            } else if (connectionState == ConnectionState.DISCONNECTED) {
                this.monitorDisconnected(connection);
            }
        }
    }

    private String getLogPrefix() {
        return "Failure Monitor [" + this._myLookupName + "]: ";
    }

    private void monitorDisconnected(AbstractProxyBasedReplicationMonitoredConnection<IRemoteSpace, SpaceURL> connection) {
        block4: {
            if (this._monitoredDisconnectedFutures.containsKey(connection)) {
                throw new IllegalArgumentException("Provided connection " + connection + " is already monitored");
            }
            if (this._specificLogger.isLoggable(Level.FINEST)) {
                this._specificLogger.finest(this.getLogPrefix() + "monitoring disconnected connection " + connection.getTargetLookupName());
            }
            MonitorDisconnectedConnectionTask monitorTask = new MonitorDisconnectedConnectionTask(connection, this);
            try {
                ScheduledFuture<?> future = this._pool.scheduleWithFixedDelay(monitorTask, 0L, this._monitorDisconnectedDelay, this._timeUnit);
                this._monitoredDisconnectedFutures.put(connection, future);
            }
            catch (RejectedExecutionException e) {
                if (this._closed) break block4;
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void monitorConnected(AbstractProxyBasedReplicationMonitoredConnection<IRemoteSpace, SpaceURL> connection) throws Exception {
        boolean firstSubscriber;
        IRemoteSpace spaceProxy = connection.getTag();
        ServiceID serviceId = connection.getServiceId();
        if (this._specificLogger.isLoggable(Level.FINEST)) {
            this._specificLogger.finest(this.getLogPrefix() + "monitoring connected connection " + connection.getTargetLookupName() + StringUtils.NEW_LINE + "ServiceID=" + serviceId);
        }
        ConcurrentMap<ServiceID, Set<AbstractProxyBasedReplicationMonitoredConnection<IRemoteSpace, SpaceURL>>> concurrentMap = this._livenessMonitored;
        synchronized (concurrentMap) {
            CopyOnUpdateSet<AbstractProxyBasedReplicationMonitoredConnection<IRemoteSpace, SpaceURL>> monitoredConnections = (CopyOnUpdateSet<AbstractProxyBasedReplicationMonitoredConnection<IRemoteSpace, SpaceURL>>)this._livenessMonitored.get(serviceId);
            if (monitoredConnections == null) {
                firstSubscriber = true;
                monitoredConnections = new CopyOnUpdateSet<AbstractProxyBasedReplicationMonitoredConnection<IRemoteSpace, SpaceURL>>();
                this._livenessMonitored.put(serviceId, monitoredConnections);
            } else {
                firstSubscriber = false;
            }
            monitoredConnections.add(connection);
        }
        if (firstSubscriber) {
            this._failureDetector.registerRemoteSpace(this, serviceId, spaceProxy);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopMonitoring(AbstractProxyBasedReplicationMonitoredConnection<IRemoteSpace, SpaceURL> connection) {
        Object object = connection.getStateLock();
        synchronized (object) {
            ServiceID serviceId;
            ScheduledFuture<?> future = this._monitoredDisconnectedFutures.remove(connection);
            if (future != null) {
                future.cancel(false);
            }
            if ((serviceId = connection.getServiceId()) != null) {
                ConcurrentMap<ServiceID, Set<AbstractProxyBasedReplicationMonitoredConnection<IRemoteSpace, SpaceURL>>> concurrentMap = this._livenessMonitored;
                synchronized (concurrentMap) {
                    Set connectionSet = (Set)this._livenessMonitored.get(serviceId);
                    if (connectionSet != null) {
                        connectionSet.remove(connection);
                        if (connectionSet.isEmpty()) {
                            this._livenessMonitored.remove(serviceId);
                        }
                    }
                }
            }
        }
    }

    private RemoteSpaceResult getSpaceProxy(SpaceURL spaceURL) throws FinderException {
        return this._proxyProvider.getSpaceProxy(spaceURL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateDisconnected(AbstractProxyBasedReplicationMonitoredConnection<IRemoteSpace, SpaceURL> connection, Exception reason) {
        Object object = connection.getStateLock();
        synchronized (object) {
            if (this._monitoredDisconnectedFutures.containsKey(connection)) {
                return;
            }
            if (this._specificLogger.isLoggable(Level.FINE)) {
                this._specificLogger.fine(this.getLogPrefix() + "connection disconnection detected " + connection.getTargetLookupName() + reason != null ? " reason - " + reason : "");
            }
            this.stopMonitoring(connection);
            connection.setDisconnected(reason);
            this.monitorDisconnected(connection);
        }
    }

    public int getMonitoredCount() {
        return this._monitoredDisconnectedFutures.size() + this._livenessMonitored.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void serviceFailure(Object service, Object serviceID) {
        Set connectionSet;
        if (this._specificLogger.isLoggable(Level.FINER)) {
            this._specificLogger.finer(this.getLogPrefix() + "received failure notice for " + service + ", " + serviceID);
        }
        if ((connectionSet = (Set)this._livenessMonitored.get(serviceID)) != null) {
            for (AbstractProxyBasedReplicationMonitoredConnection connection : connectionSet) {
                Object object = connection.getStateLock();
                synchronized (object) {
                    if (this._specificLogger.isLoggable(Level.FINER)) {
                        this._specificLogger.fine(this.getLogPrefix() + "monitoring failure detected via service failure " + connection.getTargetLookupName());
                    }
                    this.updateDisconnected(connection, (Exception)null);
                }
            }
        }
    }

    @Override
    public void close() {
        if (this._closed) {
            return;
        }
        this._closed = true;
        for (ScheduledFuture<?> future : this._monitoredDisconnectedFutures.values()) {
            future.cancel(true);
        }
        this._livenessMonitored.clear();
        this._pool.shutdownNow();
    }

    @Override
    public String dumpState() {
        StringBuilder dump = new StringBuilder("Disconnected monitored:");
        dump.append(StringUtils.NEW_LINE);
        for (AbstractProxyBasedReplicationMonitoredConnection<IRemoteSpace, SpaceURL> abstractProxyBasedReplicationMonitoredConnection : this._monitoredDisconnectedFutures.keySet()) {
            dump.append(abstractProxyBasedReplicationMonitoredConnection.dumpState());
            dump.append(StringUtils.NEW_LINE);
        }
        dump.append("Connected monitored:");
        dump.append(StringUtils.NEW_LINE);
        for (Map.Entry entry : this._livenessMonitored.entrySet()) {
            dump.append("ServiceID [" + entry.getKey() + "]");
            dump.append(StringUtils.NEW_LINE);
            dump.append("Connections: ");
            dump.append(StringUtils.NEW_LINE);
            for (AbstractProxyBasedReplicationMonitoredConnection connection : (Set)entry.getValue()) {
                dump.append(connection.dumpState());
                dump.append(StringUtils.NEW_LINE);
            }
        }
        return dump.toString();
    }

    public class MonitorDisconnectedConnectionTask
    implements Runnable {
        private final AbstractProxyBasedReplicationMonitoredConnection<IRemoteSpace, SpaceURL> _connection;
        private final FailureDetectorConnectionMonitor _monitor;

        public MonitorDisconnectedConnectionTask(AbstractProxyBasedReplicationMonitoredConnection<IRemoteSpace, SpaceURL> connection, FailureDetectorConnectionMonitor monitor) {
            this._connection = connection;
            this._monitor = monitor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block12: {
                try {
                    RemoteSpaceResult result;
                    IRemoteSpace remoteSpace;
                    if (FailureDetectorConnectionMonitor.this._specificLogger.isLoggable(Level.FINER)) {
                        FailureDetectorConnectionMonitor.this._specificLogger.finer(FailureDetectorConnectionMonitor.this.getLogPrefix() + "trying to establish connection with " + this._connection.getTargetLookupName() + " [" + this._connection.getFinderURL() + "]");
                    }
                    if ((remoteSpace = (result = this._monitor.getSpaceProxy(this._connection.getFinderURL())).getRemoteSpace()) == null) break block12;
                    String endpointLookupName = result.getEndpointLookupName();
                    IReplicationConnectionProxy connectionProxy = null;
                    Uuid proxyId = null;
                    try {
                        proxyId = remoteSpace.getSpaceUuid();
                        connectionProxy = remoteSpace.getReplicationRouterConnectionProxy();
                    }
                    catch (RemoteException e) {
                        this._connection.setLastDisconnectionReason(e);
                    }
                    if (connectionProxy != null) {
                        Object object = this._connection.getStateLock();
                        synchronized (object) {
                            if (FailureDetectorConnectionMonitor.this._specificLogger.isLoggable(Level.FINE)) {
                                FailureDetectorConnectionMonitor.this._specificLogger.fine(FailureDetectorConnectionMonitor.this.getLogPrefix() + "established connection with " + this._connection.getTargetLookupName() + " [" + this._connection.getFinderURL() + "]");
                            }
                            this._connection.setConnected(connectionProxy, remoteSpace, endpointLookupName, proxyId);
                            this._monitor.stopMonitoring(this._connection);
                            this._monitor.monitor(this._connection);
                            break block12;
                        }
                    }
                    if (FailureDetectorConnectionMonitor.this._specificLogger.isLoggable(Level.WARNING)) {
                        FailureDetectorConnectionMonitor.this._specificLogger.warning(FailureDetectorConnectionMonitor.this.getLogPrefix() + "failed to establish connection with " + this._connection.getTargetLookupName() + " [" + this._connection.getFinderURL() + "]" + StringUtils.NEW_LINE + "no connection proxy available");
                    }
                }
                catch (FinderException e) {
                    if (FailureDetectorConnectionMonitor.this._specificLogger.isLoggable(Level.FINEST)) {
                        FailureDetectorConnectionMonitor.this._specificLogger.finest(FailureDetectorConnectionMonitor.this.getLogPrefix() + "failed to establish connection with " + this._connection.getTargetLookupName() + " [" + this._connection.getFinderURL() + "]" + StringUtils.NEW_LINE + e);
                    }
                    this._connection.setLastDisconnectionReason(e);
                }
            }
        }
    }
}

