/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.view;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.document.DocumentProperties;
import com.gigaspaces.internal.io.IOUtils;
import com.gigaspaces.internal.metadata.EntryTypeDesc;
import com.gigaspaces.internal.metadata.ITypeDesc;
import com.gigaspaces.internal.query.valuegetter.SpaceEntryPathGetter;
import com.gigaspaces.internal.server.space.metadata.SpaceTypeManager;
import com.gigaspaces.internal.server.space.redolog.storage.bytebuffer.ISwapExternalizable;
import com.gigaspaces.internal.server.storage.EntryDataType;
import com.gigaspaces.internal.server.storage.ICustomTypeDescLoader;
import com.gigaspaces.internal.server.storage.IEntryData;
import com.gigaspaces.internal.transport.IEntryPacket;
import com.gigaspaces.metadata.SpaceMetadataException;
import com.gigaspaces.metadata.SpaceTypeDescriptor;
import com.j_spaces.core.LeaseManager;
import com.j_spaces.core.UnknownTypeException;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Map;
import net.jini.core.entry.UnusableEntryException;

@InternalApi
public class EntryPacketServerEntryAdapter
implements IEntryData,
ICustomTypeDescLoader,
Externalizable,
ISwapExternalizable {
    private static final long serialVersionUID = -4521887144678238254L;
    private volatile IEntryPacket _entryPacket;

    public EntryPacketServerEntryAdapter() {
    }

    public EntryPacketServerEntryAdapter(IEntryPacket entryPacket) {
        this._entryPacket = entryPacket;
    }

    @Override
    public void loadTypeDescriptor(SpaceTypeManager typeManager) {
        try {
            typeManager.loadServerTypeDesc(this._entryPacket);
        }
        catch (UnusableEntryException e) {
            throw new SpaceMetadataException("Failed to load type descriptor", e);
        }
        catch (UnknownTypeException e) {
            throw new SpaceMetadataException("Failed to load type descriptor", e);
        }
    }

    @Override
    public SpaceTypeDescriptor getSpaceTypeDescriptor() {
        return this._entryPacket.getTypeDescriptor();
    }

    @Override
    public Object getFixedPropertyValue(int position) {
        return this._entryPacket.getFieldValue(position);
    }

    @Override
    public Object getPropertyValue(String name) {
        ITypeDesc typeDesc = this._entryPacket.getTypeDescriptor();
        int pos = typeDesc.getFixedPropertyPosition(name);
        if (pos != -1) {
            return this.getFixedPropertyValue(pos);
        }
        if (typeDesc.supportsDynamicProperties()) {
            Map<String, Object> dynamicProperties = this._entryPacket.getDynamicProperties();
            return dynamicProperties != null ? dynamicProperties.get(name) : null;
        }
        throw new IllegalArgumentException("Unknown property name '" + name + "'");
    }

    @Override
    public Object getPathValue(String path) {
        if (!path.contains(".")) {
            return this.getPropertyValue(path);
        }
        return new SpaceEntryPathGetter(path).getValue(this);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        IOUtils.writeObject(out, this._entryPacket);
    }

    public void writeToSwap(ObjectOutput out) throws IOException {
        IOUtils.writeNullableSwapExternalizableObject(out, this._entryPacket);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this._entryPacket = (IEntryPacket)IOUtils.readObject(in);
    }

    public void readFromSwap(ObjectInput in) throws IOException, ClassNotFoundException {
        this._entryPacket = (IEntryPacket)IOUtils.readNullableSwapExternalizableObject(in);
    }

    @Override
    public int getVersion() {
        return this._entryPacket.getVersion();
    }

    @Override
    public long getExpirationTime() {
        return LeaseManager.toAbsoluteTime(this._entryPacket.getTTL());
    }

    @Override
    public EntryDataType getEntryDataType() {
        return EntryDataType.FLAT;
    }

    @Override
    public EntryTypeDesc getEntryTypeDesc() {
        return this._entryPacket.getTypeDescriptor().getEntryTypeDesc(this._entryPacket.getEntryType());
    }

    @Override
    public int getNumOfFixedProperties() {
        return this._entryPacket.getTypeDescriptor().getNumOfFixedProperties();
    }

    @Override
    public void setFixedPropertyValue(int index, Object value) {
        this._entryPacket.setFieldValue(index, value);
    }

    @Override
    public void setFixedPropertyValues(Object[] values) {
        this._entryPacket.setFieldsValues(values);
    }

    @Override
    public Object[] getFixedPropertiesValues() {
        return this._entryPacket.getFieldValues();
    }

    @Override
    public Map<String, Object> getDynamicProperties() {
        return this._entryPacket.getDynamicProperties();
    }

    @Override
    public long getTimeToLive(boolean useDummyIfRelevant) {
        return this._entryPacket.getTTL();
    }

    @Override
    public void setDynamicProperties(Map<String, Object> dynamicProperties) {
        this._entryPacket.setDynamicProperties(dynamicProperties);
    }

    @Override
    public void setDynamicPropertyValue(String propertyName, Object value) {
        DocumentProperties dynamicProperties = this._entryPacket.getDynamicProperties();
        if (dynamicProperties == null) {
            dynamicProperties = new DocumentProperties();
        }
        dynamicProperties.put(propertyName, value);
        this._entryPacket.setDynamicProperties(dynamicProperties);
    }

    @Override
    public void unsetDynamicPropertyValue(String propertyName) {
        Map<String, Object> dynamicProperties = this._entryPacket.getDynamicProperties();
        if (dynamicProperties != null) {
            dynamicProperties.remove(propertyName);
        }
    }
}

