/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.view;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.cluster.node.impl.config.DynamicSourceGroupMemberLifeCycle;
import com.gigaspaces.internal.cluster.node.impl.config.MemberAddedEvent;
import com.gigaspaces.internal.cluster.node.impl.config.MemberRemovedEvent;
import com.gigaspaces.internal.server.space.LocalViewRegistrations;
import com.gigaspaces.management.space.SpaceQueryDetails;
import com.gigaspaces.management.transport.ConnectionEndpointDetails;
import java.util.Collection;

@InternalApi
public class ViewDynamicSourceGroupMemberLifeCycle
extends DynamicSourceGroupMemberLifeCycle {
    private final LocalViewRegistrations _localViewRegistrations;
    private final Collection<SpaceQueryDetails> _queryDescriptions;
    private final ConnectionEndpointDetails _connectionDetails;

    public ViewDynamicSourceGroupMemberLifeCycle(LocalViewRegistrations localViewRegistrations, Collection<SpaceQueryDetails> queryDescriptions, ConnectionEndpointDetails connectionDetails) {
        this._localViewRegistrations = localViewRegistrations;
        this._queryDescriptions = queryDescriptions;
        this._connectionDetails = connectionDetails;
    }

    @Override
    public void afterMemberAdded(MemberAddedEvent memberAddedEvent) {
        super.afterMemberAdded(memberAddedEvent);
        this._localViewRegistrations.add(memberAddedEvent.getMemberName(), this._connectionDetails, this._queryDescriptions);
    }

    @Override
    public void afterMemberRemoved(MemberRemovedEvent memberRemovedEvent) {
        super.afterMemberRemoved(memberRemovedEvent);
        this._localViewRegistrations.remove(memberRemovedEvent.getMemberName());
    }

    @Override
    public Object[] getConstructionArguments() {
        return new Object[]{this._queryDescriptions, this._connectionDetails};
    }
}

