/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.impl.view;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.cluster.node.impl.ReplicationSingleOperationType;
import com.gigaspaces.internal.cluster.node.impl.groups.IReplicationUnreliableOperation;
import com.gigaspaces.internal.cluster.node.impl.groups.ReplicationChannelEntryDataFilterResult;
import com.gigaspaces.internal.cluster.node.impl.groups.reliableasync.ReliableAsyncChannelDataFilter;
import com.gigaspaces.internal.cluster.node.impl.packets.data.IReplicationPacketData;
import com.gigaspaces.internal.cluster.node.impl.packets.data.IReplicationPacketEntryData;
import com.gigaspaces.internal.cluster.node.impl.packets.data.IReplicationPacketEntryDataContentExtractor;
import com.gigaspaces.internal.cluster.node.impl.packets.data.ReplicationEntryDataConversionMetadata;
import com.gigaspaces.internal.query.RegexCache;
import com.gigaspaces.internal.server.metadata.IServerTypeDesc;
import com.gigaspaces.internal.server.space.metadata.SpaceTypeManager;
import com.gigaspaces.internal.server.storage.IEntryData;
import com.gigaspaces.internal.server.storage.TemplateEntryData;
import com.gigaspaces.internal.server.storage.TemplateHolder;
import com.gigaspaces.internal.transport.ITemplatePacket;
import com.gigaspaces.internal.utils.collections.CopyOnUpdateMap;
import com.gigaspaces.internal.version.PlatformLogicalVersion;
import com.gigaspaces.metadata.SpaceTypeDescriptor;
import com.gigaspaces.server.ServerEntry;
import com.j_spaces.core.cache.CacheManager;
import java.util.logging.Level;
import java.util.logging.Logger;

@InternalApi
public class ViewReplicationChannelDataFilter
extends ReliableAsyncChannelDataFilter {
    private final ITemplatePacket[] _templatePackets;
    private final TemplateEntryData[] _templates;
    private final RegexCache _regexCache;
    private final SpaceTypeManager _typeManager;
    private final String _groupName;
    private final CacheManager _cacheManager;
    private static final CopyOnUpdateMap<String, Integer> _createdGroupFilterIndicator = new CopyOnUpdateMap();

    public static boolean hasCreatedFilters(String groupName) {
        return _createdGroupFilterIndicator.containsKey(groupName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ViewReplicationChannelDataFilter(CacheManager cacheManager, String groupName, ITemplatePacket[] templates, RegexCache regexCache, SpaceTypeManager typeManager) {
        this._cacheManager = cacheManager;
        this._groupName = groupName;
        CopyOnUpdateMap<String, Integer> copyOnUpdateMap = _createdGroupFilterIndicator;
        synchronized (copyOnUpdateMap) {
            Integer existingViews = _createdGroupFilterIndicator.get(this._groupName);
            if (existingViews == null) {
                existingViews = 0;
            }
            existingViews = existingViews + 1;
            _createdGroupFilterIndicator.put(this._groupName, existingViews);
        }
        this._templatePackets = templates;
        this._typeManager = typeManager;
        this._templates = this.initTemplates(this._templatePackets);
        if (this._cacheManager.isBlobStoreCachePolicy()) {
            for (int i = 0; i < this._templatePackets.length; ++i) {
                if (TemplateHolder.isOptimizedForBlobStoreClear(cacheManager, this._templatePackets[i], this._templates[i])) continue;
                this._cacheManager.getEngine().getLocalViewRegistrations().setBlobStoreClearOptimizationNotAllowed(this._templates[i].getEntryTypeDesc().getTypeDesc().getTypeName());
                break;
            }
        }
        this._regexCache = regexCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        super.finalize();
        CopyOnUpdateMap<String, Integer> copyOnUpdateMap = _createdGroupFilterIndicator;
        synchronized (copyOnUpdateMap) {
            Integer existingCount = _createdGroupFilterIndicator.get(this._groupName);
            if (existingCount == 1) {
                _createdGroupFilterIndicator.remove(this._groupName);
            } else {
                _createdGroupFilterIndicator.put(this._groupName, existingCount - 1);
            }
        }
    }

    private TemplateEntryData[] initTemplates(ITemplatePacket[] templates) {
        TemplateEntryData[] result = new TemplateEntryData[templates.length];
        for (int i = 0; i < templates.length; ++i) {
            result[i] = new TemplateEntryData(templates[i].getTypeDescriptor(), templates[i], Long.MAX_VALUE, false);
        }
        return result;
    }

    public ReplicationChannelEntryDataFilterResult filterBeforeReplicatingEntryData(IReplicationPacketEntryData entryData, PlatformLogicalVersion targetLogicalVersion, IReplicationPacketEntryDataContentExtractor contentExtractor, Logger contextLogger, IReplicationPacketData data) {
        switch (entryData.getOperationType()) {
            case WRITE: 
            case REMOVE_ENTRY: 
            case ENTRY_LEASE_EXPIRED: 
            case CANCEL_LEASE: 
            case EXTEND_ENTRY_LEASE: {
                return this.filterSingleEntry(contentExtractor.getMainEntryData(entryData), entryData.getOperationType());
            }
            case UPDATE: 
            case CHANGE: {
                IEntryData prevEntry = contentExtractor.getSecondaryEntryData(entryData);
                IEntryData entry = contentExtractor.getMainEntryData(entryData);
                if (prevEntry == null) {
                    contextLogger.log(Level.WARNING, "update operation of entry [" + entryData + "] is missing previous entry state, this may result with inconsistent local view state");
                }
                return this.filterUpdateEntry(entry, prevEntry);
            }
            case DATA_TYPE_INTRODUCE: 
            case DATA_TYPE_ADD_INDEX: {
                return this.filterType(contentExtractor.getMainTypeName(entryData)) ? ReplicationChannelEntryDataFilterResult.PASS : ReplicationChannelEntryDataFilterResult.FILTER_DATA;
            }
            case INSERT_NOTIFY_TEMPLATE: 
            case REMOVE_NOTIFY_TEMPLATE: 
            case EXTEND_NOTIFY_TEMPLATE_LEASE: 
            case NOTIFY_TEMPLATE_LEASE_EXPIRED: {
                return ReplicationChannelEntryDataFilterResult.FILTER_DATA;
            }
            case DISCARD: {
                return ReplicationChannelEntryDataFilterResult.PASS;
            }
            case EVICT: {
                return ReplicationChannelEntryDataFilterResult.FILTER_DATA;
            }
        }
        return ReplicationChannelEntryDataFilterResult.FILTER_DATA;
    }

    private ReplicationChannelEntryDataFilterResult filterSingleEntry(ServerEntry entry, ReplicationSingleOperationType operationType) {
        if (entry == null) {
            return ReplicationChannelEntryDataFilterResult.PASS;
        }
        SpaceTypeDescriptor spaceTypeDescriptor = entry.getSpaceTypeDescriptor();
        String typeName = spaceTypeDescriptor.getTypeName();
        IServerTypeDesc typeDesc = this._typeManager.getServerTypeDesc(typeName);
        for (int i = 0; i < this._templates.length; ++i) {
            if (!this._templates[i].isAssignableFrom(typeDesc) || !this._templates[i].match(this._cacheManager, entry, -1, null, this._regexCache)) continue;
            if (this._templatePackets[i].getProjectionTemplate() == null || operationType != ReplicationSingleOperationType.WRITE) {
                return ReplicationChannelEntryDataFilterResult.PASS;
            }
            ReplicationEntryDataConversionMetadata metadata = new ReplicationEntryDataConversionMetadata().projectionTemplate(this._templatePackets[i].getProjectionTemplate());
            return ReplicationChannelEntryDataFilterResult.getConvertToOperationResult(metadata);
        }
        return ReplicationChannelEntryDataFilterResult.FILTER_DATA;
    }

    private ReplicationChannelEntryDataFilterResult filterUpdateEntry(ServerEntry entry, ServerEntry prevEntry) {
        boolean matchPrevious = false;
        boolean matchCurrent = false;
        SpaceTypeDescriptor spaceTypeDescriptor = entry.getSpaceTypeDescriptor();
        String typeName = spaceTypeDescriptor.getTypeName();
        IServerTypeDesc typeDesc = this._typeManager.getServerTypeDesc(typeName);
        ITemplatePacket templatePacket = null;
        for (int i = 0; !(i >= this._templates.length || matchPrevious && matchCurrent); ++i) {
            if (!this._templates[i].isAssignableFrom(typeDesc)) continue;
            if (!matchPrevious && prevEntry != null && this._templates[i].match(this._cacheManager, prevEntry, -1, null, this._regexCache)) {
                matchPrevious = true;
            }
            if (matchCurrent || !this._templates[i].match(this._cacheManager, entry, -1, null, this._regexCache)) continue;
            templatePacket = this._templatePackets[i];
            matchCurrent = true;
        }
        if (matchCurrent) {
            if (matchPrevious) {
                if (templatePacket.getProjectionTemplate() == null) {
                    return ReplicationChannelEntryDataFilterResult.PASS;
                }
                ReplicationEntryDataConversionMetadata metadata = new ReplicationEntryDataConversionMetadata().projectionTemplate(templatePacket.getProjectionTemplate());
                return ReplicationChannelEntryDataFilterResult.getConvertToOperationResult(metadata);
            }
            if (templatePacket.getProjectionTemplate() == null) {
                return ReplicationChannelEntryDataFilterResult.CONVERT_WRITE;
            }
            ReplicationEntryDataConversionMetadata metadata = new ReplicationEntryDataConversionMetadata(ReplicationSingleOperationType.WRITE).projectionTemplate(templatePacket.getProjectionTemplate());
            return ReplicationChannelEntryDataFilterResult.getConvertToOperationResult(metadata);
        }
        if (matchPrevious) {
            return ReplicationChannelEntryDataFilterResult.CONVERT_REMOVE;
        }
        return ReplicationChannelEntryDataFilterResult.FILTER_DATA;
    }

    private boolean filterType(String typeName) {
        IServerTypeDesc typeDesc = this._typeManager.getServerTypeDesc(typeName);
        for (TemplateEntryData template : this._templates) {
            if (!template.isAssignableFrom(typeDesc)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean filterBeforeReplicatingUnreliableOperation(IReplicationUnreliableOperation operation, PlatformLogicalVersion targetLogicalVersion) {
        return false;
    }

    @Override
    public Object[] getConstructionArgument() {
        for (ITemplatePacket templatePacket : this._templatePackets) {
            templatePacket.setSerializeTypeDesc(true);
        }
        return this._templatePackets;
    }
}

