/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.cluster.node.replica;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.cluster.node.impl.directPersistency.DirectPersistencySyncListFetcher;
import com.gigaspaces.internal.cluster.node.replica.ISpaceCopyReplicaParameters;
import com.gigaspaces.internal.io.IOUtils;
import com.gigaspaces.internal.transport.ITemplatePacket;
import com.gigaspaces.internal.utils.StringUtils;
import com.gigaspaces.internal.version.PlatformLogicalVersion;
import com.gigaspaces.lrmi.LRMIInvocationContext;
import com.j_spaces.core.SpaceContext;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.LinkedList;
import java.util.List;

@InternalApi
public class SpaceCopyReplicaParameters
implements ISpaceCopyReplicaParameters {
    private static final long serialVersionUID = 1L;
    private boolean _copyNotifyTemplates;
    private boolean _isTransient;
    private boolean _memoryOnly;
    private boolean _includeEvictionReplicationMarkers;
    private LinkedList<ITemplatePacket> _templatePackets = new LinkedList();
    private ReplicaType _replicaType;
    private SpaceContext _spaceContext;
    private DirectPersistencySyncListFetcher _fetcher;
    private transient List<String> _syncList;

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeBoolean(this._copyNotifyTemplates);
        if (this._memoryOnly && LRMIInvocationContext.getEndpointLogicalVersion().lessThan(PlatformLogicalVersion.v9_1_0)) {
            this._isTransient = true;
        }
        out.writeBoolean(this._isTransient);
        IOUtils.writeObject(out, this._templatePackets);
        if (LRMIInvocationContext.getEndpointLogicalVersion().greaterOrEquals(PlatformLogicalVersion.v9_1_0)) {
            out.writeBoolean(this._memoryOnly);
            out.writeBoolean(this._includeEvictionReplicationMarkers);
        }
        IOUtils.writeObject(out, (Object)this._replicaType);
        IOUtils.writeObject(out, this._spaceContext);
        if (LRMIInvocationContext.getEndpointLogicalVersion().greaterOrEquals(PlatformLogicalVersion.v10_2_0)) {
            IOUtils.writeObject(out, this._fetcher);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this._copyNotifyTemplates = in.readBoolean();
        this._isTransient = in.readBoolean();
        this._templatePackets = (LinkedList)IOUtils.readObject(in);
        if (LRMIInvocationContext.getEndpointLogicalVersion().greaterOrEquals(PlatformLogicalVersion.v9_1_0)) {
            this._memoryOnly = in.readBoolean();
            this._includeEvictionReplicationMarkers = in.readBoolean();
        } else {
            this._memoryOnly = this._isTransient;
            this._includeEvictionReplicationMarkers = false;
        }
        this._replicaType = (ReplicaType)((Object)IOUtils.readObject(in));
        this._spaceContext = (SpaceContext)IOUtils.readObject(in);
        if (LRMIInvocationContext.getEndpointLogicalVersion().greaterOrEquals(PlatformLogicalVersion.v10_2_0)) {
            this._fetcher = (DirectPersistencySyncListFetcher)IOUtils.readObject(in);
        }
    }

    public boolean isCopyNotifyTemplates() {
        return this._copyNotifyTemplates;
    }

    public boolean isTransient() {
        return this._isTransient;
    }

    public void setCopyNotifyTemplates(boolean copyNotifyTemplates) {
        this._copyNotifyTemplates = copyNotifyTemplates;
    }

    public void setTransient(boolean isTransient) {
        this._isTransient = isTransient;
    }

    public void addTemplatePacket(ITemplatePacket templatePacket) {
        this._templatePackets.add(templatePacket);
    }

    public List<ITemplatePacket> getTemplatePackets() {
        return this._templatePackets;
    }

    public ReplicaType getReplicaType() {
        return this._replicaType;
    }

    public void setReplicaType(ReplicaType replicaType) {
        this._replicaType = replicaType;
    }

    public SpaceContext getSpaceContext() {
        return this._spaceContext;
    }

    public void setSpaceContext(SpaceContext spaceContext) {
        this._spaceContext = spaceContext;
    }

    public boolean isMemoryOnly() {
        return this._memoryOnly;
    }

    public void setMemoryOnly(boolean memoryOnly) {
        this._memoryOnly = memoryOnly;
    }

    public void setIncludeEvictionReplicationMarkers(boolean includeReplicationMarkers) {
        this._includeEvictionReplicationMarkers = includeReplicationMarkers;
    }

    public void setSynchronizationListFetcher(DirectPersistencySyncListFetcher fetcher) {
        this._fetcher = fetcher;
    }

    public DirectPersistencySyncListFetcher getSynchronizationListFetcher() {
        return this._fetcher;
    }

    public List<String> getSyncList() {
        return this._syncList;
    }

    public void setSyncList(List<String> _syncList) {
        this._syncList = _syncList;
    }

    public boolean isIncludeEvictionReplicationMarkers() {
        return this._includeEvictionReplicationMarkers;
    }

    public String toString() {
        return "ReplicaType=" + (Object)((Object)this._replicaType) + StringUtils.NEW_LINE + "CopyNotifyTemplate=" + this._copyNotifyTemplates + StringUtils.NEW_LINE + "IsTransient=" + this._isTransient + StringUtils.NEW_LINE + "MemoryOnly=" + this._memoryOnly + StringUtils.NEW_LINE + "IncludeEvictionReplicationMarkers=" + this._includeEvictionReplicationMarkers + StringUtils.NEW_LINE + "TemplatePackets=" + this._templatePackets + StringUtils.NEW_LINE + "SpaceContext=" + String.valueOf(this._spaceContext != null);
    }

    public static enum ReplicaType {
        SYNCRONIZE,
        COPY,
        BROADCAST_NOTIFY_TEMPLATES_COPY;

    }
}

