/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.collections;

import com.gigaspaces.internal.collections.IntegerList;
import com.gigaspaces.internal.collections.IntegerObjectMap;
import com.gigaspaces.internal.collections.IntegerSet;
import com.gigaspaces.internal.collections.LongObjectMap;
import com.gigaspaces.internal.collections.MapProcedure;
import com.gigaspaces.internal.collections.ObjectIntegerMap;
import com.gigaspaces.internal.collections.ObjectLongMap;
import com.gigaspaces.internal.collections.ObjectShortMap;
import com.gigaspaces.internal.collections.ShortList;
import com.gigaspaces.internal.collections.ShortLongMap;
import com.gigaspaces.internal.collections.ShortObjectMap;
import com.gigaspaces.internal.collections.standard.StandardCollectionsFactory;
import com.gigaspaces.internal.collections.standard.StandardObjectShortMap;
import com.gigaspaces.internal.collections.standard.StandardShortLongMap;
import com.gigaspaces.internal.collections.trove.TroveCollectionsFactory;
import com.gigaspaces.internal.io.IOUtils;
import com.gigaspaces.internal.reflection.ReflectionUtil;
import java.io.IOException;
import java.io.ObjectInput;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class CollectionsFactory {
    private static final Logger _logger = Logger.getLogger(CollectionsFactory.class.getName());
    private static final CollectionsFactory instance = CollectionsFactory.initialize();

    private static CollectionsFactory initialize() {
        Class<TroveCollectionsFactory> factoryClass = TroveCollectionsFactory.class;
        CollectionsFactory factory = (CollectionsFactory)ReflectionUtil.createInstanceWithOptionalDependencies(factoryClass);
        if (factory == null) {
            _logger.log(Level.WARNING, "Failed to create collections factory [" + factoryClass.getName() + "], falling back to standard factory instead");
            factory = new StandardCollectionsFactory();
        }
        return factory;
    }

    public static CollectionsFactory getInstance() {
        return instance;
    }

    public abstract <K, V> Map<K, V> createMap();

    public abstract <K, V> Map<K, V> createMap(int var1);

    public abstract <K, V> Map<K, V> createMap(int var1, float var2);

    public abstract <K, V> Map<K, V> createMap(Map<K, V> var1);

    public abstract ShortList createShortList();

    public abstract IntegerList createIntegerList();

    public abstract IntegerSet createIntegerSet();

    public abstract IntegerSet createIntegerSet(int var1);

    public abstract ShortLongMap createShortLongMap();

    public ShortLongMap deserializeShortLongMap(ObjectInput in) throws IOException, ClassNotFoundException {
        Object map = IOUtils.readObject(in);
        if (map instanceof Map) {
            return new StandardShortLongMap((Map)map);
        }
        return this.deserializeShortLongMap(map);
    }

    protected abstract ShortLongMap deserializeShortLongMap(Object var1);

    public abstract <V> ShortObjectMap<V> createShortObjectMap();

    public abstract <V> ShortObjectMap<V> createShortObjectMap(int var1);

    public abstract <K> ObjectShortMap<K> createObjectShortMap();

    public abstract <V> LongObjectMap<V> createLongObjectMap();

    public abstract <K> ObjectLongMap<K> createObjectLongMap();

    public <K> ObjectShortMap<K> deserializeObjectShortMap(ObjectInput in) throws IOException, ClassNotFoundException {
        Object map = in.readObject();
        if (map instanceof Map) {
            return new StandardObjectShortMap((Map)map);
        }
        return this.deserializeObjectShortMap(map);
    }

    protected abstract <K> ObjectShortMap<K> deserializeObjectShortMap(Object var1);

    public abstract <V> IntegerObjectMap<V> createIntegerObjectMap();

    public abstract <K> ObjectIntegerMap<K> createObjectIntegerMap();

    public <K, V> boolean forEachEntry(Map<K, V> map, MapProcedure<K, V> procedure) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            if (procedure.execute(entry.getKey(), entry.getValue())) continue;
            return false;
        }
        return true;
    }
}

